package GUI::Providers;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use Html::Tabs;
use strict;

sub display {
  my($q, $post, $util) = @_;
  my(@M, @tabs, $out);

  print Html->body();
  my $L = Labels->read('Provider')->section('names');

  if (my $err = Roles->verifyRole($q, "admin")) {
     print $err;
     return;
  }

  my $renv = System->get_renv();

  $out .= Html->header2("admin.gen_maint.providers", "90%", undef, " ");

  opendir(O, System->get_home() . "/lib/Provider");
  my @list = ('NetConnect.pm');
  my @list0 = readdir(O); closedir(O);
  foreach my $el (sort @list0) {
     push(@list, $el) if ($el !~ /NetConnect/);
  }

  my $cnt = 1;
  foreach my $p (@list) {
     next if ($p !~ /.pm$/);
     my $name = substr($p, 0 , -3);
     next if ($name eq "Email" || $name eq "NSM");
     next if ($name eq "Http" && $renv->{production})  ;
     # next if ($name eq "NSM" && $renv->{activate_nsm} ne "Y");
     $M[$cnt]= $name;
     $cnt++;
     if (!(eval "require \"Provider/$name.pm\"")) {
       $out .= "$name: $!";
     }
  }

  $q->{option} = 1 if (!$q->{option});

  my $pack = $M[$q->{option}];
  my $module = "Provider::$pack";


  my $form =  $module->UPDATE($q);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  $cnt = 1;
  foreach my $p (@list) {
     next if ($p !~ /.pm$/);
     my $name = substr($p, 0 , -3);
     my $name0 = lc($name);
     next if ($name0 eq "email" || $name0 eq "nsm");
     next if ($name eq "Http" && $renv->{production})  ;
     #next if ($name eq "NSM" && $renv->{activate_nsm} ne "Y");

     $module = "Provider::$name";
     my $desc =  $L->{$name0};
     my $flag;
     if ($module->can("ISACTIVE")) {
        $flag = $module->ISACTIVE($renv);
        if ($flag eq "NA") {
            $cnt++; next;
        }
     } else {
        $flag = ($renv->{"pro.$name0.active"} eq "Y")? "<b>(On)</b>":"(Off)";
     }
     push(@tabs, "$cnt=$desc $flag");
     $cnt++;
  }

  my $table = Html::Tabs->create(list  =>  \@tabs,
                       url  => "$Http::WEBPROC?GO=GUI::Providers::display",
                     width  => "90%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
               );

  my($info) = Util->readHtdocs("provider_$pack");

  print $out;
  print $table;
  print $info;
  print $form;

}

1;
