package GUI::MessageLog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: MessageLog.pm,v 1.26 2003/05/07 21:45:12 ccadieux Exp $

use System;
use Util::Http;

sub process {
  my($renv, $l, $label) = @_;
  my ($name, $host, $type);
  if (exists $renv->{GSV_NAME}) {
    $type = "Master";
    $host = "local";
  } else {
    $type = "Slave";
    $host = $renv->{hostname};
  }
  $name = $renv->{hostname};
  my $ex = $type eq "Master" ? -f $l : 1;
  if ($ex) {
    my $l2 = $l; $l2 =~ s/\/var\/adm\///;
    my $url = "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$host&file=$l>$l2</a>";
    my $ip = $renv->{ipno} ||Util->name2ip();
    my ($display);

    if ($name ne $LAST) {
       $LAST= $name;
       $display = "$name / $ip";
       return "<tr><td></td><tr>
        <td width=50%><b>$display</td>
        <td><center>$label</td>
        <td>&nbsp;$url</td>";
    } else {
       return "<tr>
        <td width=50%><b>$display</td>
        <td><center>$label</td>
        <td>&nbsp;$url</td>";
    }
  }
}


sub list {
  my($q) = @_;

  $hname = System->hostname;
  $hid = System->hostid;
  $ip  = System->local_ip;
  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  $head = Html->header2("monitor.log.messages");
  my $L = Labels->read('GUI::MessageLog')->section('list');
  my $G = Labels->read();
  print Html->body();
  $o =<<EOF;

<center>
$head
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<form  method=get><input type=hidden name=GO value=start>
<table border=0 cellspacing=2 width=100% bgcolor=#F0F0F0>
<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>
<tr bgcolor=$Style::LIGHT>
    <td ><center><b>$L->{hostname}</td>
    <td ><center><b>Log Type</td>
    <td ><center><b>$L->{log}</td>
<tr>
EOF
  $LAST = "";
  $ERR = "";
  foreach my $log ($renv, @$hosts) {
    $o .= &process($log, $log->{logfile}, "Message");
    for ($x=1; $x <= 2; $x++) {
      $o .= &process($log, "$log->{logfile}.$x", "Message");
    } 
    $o .= &process($log, "/var/adm/trap_messages", "Trap") if (exists $log->{GSV_NAME});

    my @L = split(/\s+/, $log->{t300logfile}, "Array");
    foreach my $t3log (@L) {
      $o .= &process($log, $t3log, "Array");
    }
    $o .= &process($log, "/var/adm/messages.3310", "3510");
  }

  $o .= "</table></table>";
  print $o;

}

sub list2 {
  my($q) = @_;
  my(@a, $cnt, $name, $more, $more4, $more8); 

  my $LB = Labels->read('GUI::MessageLog')->section('list');
  print Html->body();
  print '</center>';
  $menu = "<td align=right><b>[ <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&file=$q->{file}&host=$q->{host}>$LB->{refresh}</a> | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list>$LB->{list}</a> ]
   </td>
   ";


  $q->{size} = 40 if (!$q->{size});
  $q->{size} = 80 if ($q->{size} > 80);

  if ($q->{host} eq "local") {
     $hname = System->hostname;
     my($size) = int ((stat($q->{file}))[7] / 1000);
     $more4 = 
      "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=local&file=$q->{file}&size=40>$LB->{k40}</a>";
     $more4 = "<b>$more4</b>" if ($q->{size} eq 40);
     if ($size > 40) {
       $more8 = " | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=local&file=$q->{file}&size=80>$LB->{k80}</a>";
       $more8 = "<b>$more8</b>" if ($q->{size} eq 80);
  
     }

     print "<table border=0 cellspacing=0 cellpadding=3 width=100% bgcolor=#D0D0D0>
          <tr><td><b>$q->{file} $LB->{local} /$hname&nbsp; ($LB->{size}: ${size}K) <br>
            </b> [ $more4  $more8 ]</td>
              $menu
            </table><small>";
     if (open(O, $q->{file})) {
        my $size0 = (stat($q->{file}))[7];
        my($s1) = $q->{size} * 1000;
        if ($s1 < $size0) {
          seek(O,- $s1, 2);
          $l = <O>;
        }
        while ($l = <O>) {
           if (substr($l,0,1) eq "\t") {
             $a[$#a] .= $l;
           } else {
             push(@a, $l);
           }
        }
        close(O);
        for ($x=$#a; $x >= 0; $x--) {
          print "$a[$x]<br>";
        }
     } else {
        print "Cannot read $q->{file}: $!<br>";
     }
     print "&nbsp;<p>";
  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
     foreach $h (@$host) {
       if ($h->{ipno} eq $q->{host}) {
         $name = $h->{hostname};
         last;
       }
     }
     print "$LB->{calling} $q->{host}...<br>\n";

     $page = Util::Http->getCommand($q->{host}, 
                    "GUI::MessageLog::read&file=$q->{file}&size=$q->{size}", 
                    $main::TO) || "Error";

     $ix = index($page, "\t");
     $size = substr($page,0,$ix) if ($ix > 0);

     $more4 = 
      "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$q->{host}&file=$q->{file}&size=40>Display 40K</a>";
     $more4 = "<b>$more4</b>" if ($q->{size} eq 40);

     if ($size > 40) {
       $more8  = 
      " | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$q->{host}&file=$q->{file}&size=80>Display 80K</a>";
       $more8 = "<b>$more8</b>" if ($q->{size} eq 80);
     }

     print "<table border=0 cellspacing=0 cellpadding=3 width=100% bgcolor=#D0D0D0>
          <tr><td><b>$q->{file} $LB->{local} $name/$q->{host}&nbsp; ($LB->{size}: ${size}K) <br>
            </b> [ $more4  $more8 ]</td>
              $menu
            </table><small>";

     print $header;
     print $page;
  }

}


sub get_read {
  my($q) = @_;
  my(@a);
  print "\n";
  $q->{size} = 40 if (!$q->{size});
  $q->{size} = 80 if ($q->{size} > 80);

  my $LB = Labels->read('GUI::MessageLog')->section('list');

  my($s1) = $q->{size} * 1000;

  if (open(O, $q->{file})) {
     my $size0 = (stat($q->{file}))[7];
     my $size  = int($size0/1000);
     print "$size\t";
     if ($s1 < $size0) {
        seek(O,- $s1, 2);
        $l = <O>;
     }
     while ($l = <O>) {
        push(@a, $l);
     }
     close(O);
     for ($x=$#a; $x >= 0; $x--) {
       print "$a[$x]<br>";
     }
  } else {
     print "\n$LB->{cannot_read} $q->{file}: $!<br>";
  }
}



1;

