package GUI::Instr;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Instr.pm,v 1.161 2003/05/16 22:43:40 ccadieux Exp $

use Util;
use Grid;
use Labels;
use Launch;
use Html;
use System;
use AdminGroup;
#use Agent;
use Modules;
use Report;
use State;
use strict;
#
#  dates are in ISO8601 (e.g. "1972-09-24 20:05") 
use vars qw($FRAME2);
$FRAME2 = "BS";

use vars qw (@Map);

sub frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};

  if (index($FRAME2, $window) < 0 || $q->{DOC}) {
     GUI::Instr::explore($q);
  } else {
     print Html->text_header();
     print <<EOF;
<frameset cols=50%,* border=1>
  <frame src=$Http::WEBPROC?GO=GUI::Instr::explore name=top  scrolling=auto>
  <frame src=$Http::WEBPROC?GO=GUI::Navigation::help2&ROOT=monitor.devices&file=monitordevice&NOHREF=9 name=tree scrolling=auto>
</frameset>

EOF
  }
}


sub reverse {
  my($d) = @_;
  return (3000 - substr($d,0,4)) .   # year
         (20 - substr($d,5,2))   .   # month
         (40-substr($d,8,2))     .   # day
         (999999- (substr($d,11,2).substr($d,14,2).substr($d,17,2)));
}

sub short {
  my($e) = @_;
  my $ix = index($e,".");
  if (ord(substr($e,0,1)) > 57 && $ix > 0) {
    return substr($e,0,$ix);
  } else {
    return $e;
  }
}

sub explore {
  my($q, $post, $util) = @_;
  my(%D, $data, $head);
  print Html->body();

  my($renv, $dev, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my(%MAP);
  my($local) = System->hostname();
  my $sel = ($q->{host} eq "ALL")? "selected":"";
  my $sel1 = ($q->{host} eq "local")? "selected":"";
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('explore') ;
  my($hostsD) = "<select name=host><option value=ALL $sel>$L->{all_hosts}</option>".
                "<option value=local $sel1>" . &short($local) . "</option>";
  my (%LABEL, %MGMT);
  if ($q->{ACTION_CLEAR}) {
       State->clearAllComponents(undef, undef, $q->{tstamp});
       State->clearAllLinks(undef, undef, $q->{tstamp});
       State->write();
  }
  if ($renv->{solution} ne "N") {
    $LABEL{"host:$renv->{hostname}"} = "sp";
     $MGMT{"host:$renv->{hostname}"} = "C";
  }
  my $x;
  for ($x=0; $x <= $#$hosts; $x++) {
     $MAP{$hosts->[$x]{hostname}} = $hosts->[$x];
  }
  foreach my $hname (sort keys %MAP) {
     my $h = $MAP{$hname};
     if ($h->{solution} ne "N") {
       $LABEL{"host:$h->{hostname}"} = "sp" ;
        $MGMT{"host:$h->{hostname}"} = "C";
     }
     my $sel  = ($h->{hostname} eq $q->{host})? "selected":"";
     $hostsD .= "<option value=\"$h->{hostname}\" $sel>" . &short($h->{hostname})  ."</option>";
  }

  $hostsD    .= "</select>";
  my $groups = AdminGroup->new();

  $q->{GROUP} = $ruser->{adm_group} if (!exists $q->{GROUP} && $ruser->{adm_group});

  my $groupsD = $groups->select("GROUP", $q->{GROUP}, "All");

  my $val = $q->{PREFIX} || $G->{search};
  my $tstamp = Util->get_today();
  $head = Html->header2("monitor.devices", "95%" ) . 
   "
   <table border=0><tr><td></table>
   <table border=0 cellspacing=1 cellpadding=1 width=95% bgcolor=white>
   <tr><td><form>
           <input type=hidden name=GO value=GUI::Instr::explore>
           <input type=hidden name=tstamp value=\"$tstamp\">
       <b>&nbsp;$L->{host}: $hostsD</td>
       <td><b>&nbsp;$L->{adm_group}: $groupsD</td>
       <td valign=top><b>&nbsp;$L->{search}: 
            <input type=text size=10 name=PREFIX value=$val onfocus=\"if(this.value==this.defaultValue) this.value='';\"></td>
       <td><b><input type=submit name=ACTION value=GO>&nbsp;

    </table>";
  my $prefix = $q->{PREFIX} eq $G->{search} ? "" : $q->{PREFIX};

  my $shost = $q->{host} || "ALL";
  my $sort = $q->{sort} || "HOST";

  print $head;

  my(%CONF) = ();
  my($types, %NAMES, %IP);
  $types = "host,";
  foreach my $d1 (@$dev) {
     $LABEL{$d1->{type} . ":" . $d1->{key}} = $d1->{userLabel};
     $MGMT{$d1->{type} . ":" . $d1->{key}} = $d1->{mgmtLevel};
     $IP{$d1->{type} . ":" . $d1->{key}} = $d1;
     $types .= "$d1->{type},";
  }
  my $DB = State->getComponentState(1); # worst severity for each comp.

  my @GIF = ("al_ok3.gif alt=$G->{ok}",
             "al_alert3.gif alt=$G->{warning}",
             "al_crit3.gif alt=$G->{error}",
             "al_down3.gif alt=$G->{down}"
             );
  
# REPORT-LIST
  my $RL = Report->reportList();
  my($out, $found, @LIST);
  $prefix =~ s/\*//g;
  $prefix =~ s/\./\\./g;
  my $target = (index($FRAME2, $window) < 0) ? "" : "target=tree";
  my $agroups = $Config->adminGroups();

  foreach my $r0 (keys %$RL) { #host, type, date, XX, name
    my $r    = $RL->{$r0};
    my $file = $r0;
    my $type = $r->[1];
    my $host = $r->[0];
    my $label = $LABEL{$r0} || $type;
    next if ($ruser->{isCustomer} && $MGMT{$r0} eq "C");
    next if (index($Report::EXCLUDE, ",$type,") >= 0);
    next if ($prefix and $r->[4] !~ /$prefix/);
    #next if (index($types, $type) < 0); # only display types that are in confg
    next if ($q->{GROUP} && ($agroups->{$file} ne $q->{GROUP}));
    my ($ok, $h1);
    if ($renv->{hostname} eq $r->[0]) { # local
       if ($shost eq "local" || $shost eq "ALL") {
         $ok = 1;
       }
    } else {
       $out .= "<tr><td colspan=7></td>";
       if ($shost eq $host || $shost eq "ALL") {
          $ok = 1;
          $h1 = $MAP{$host}{hostname} || $host;
       }
    }
    if ($ok) {
       my $name = $r->[4];
       my $date = $r->[2];
       $name =~ s/\.([a-zA-Z])/. $1/;
       $found++;
       my $url = "<a href=$Http::WEBPROC?GO=GUI::Instr::rStart&file=$file&type=$type&host=$h1 $target>$name</a>";
       my $report = "<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$file&type=$type&host=$h1 $target>Report</a> ";
       
       my $state = $DB->{$file};
       my($v);
       if ($sort eq "TYPE") {
          $v = lc($type);
       } elsif ($sort eq "NAME") {
          $v = $name;
       } elsif ($sort eq "STATUS") {
          $v = sprintf("%2.2d", 10 - $state->[0]);
       } elsif ($sort eq "DATE") {
          $v = &reverse($date);
       } else {  # if ($sort eq "HOST") {
          $v = $host . $name;
       }
       $v .= "\t$host\t$label\t$url\t$report\t$state->[0]\t$file\t$date\thost_local\t$MGMT{$r0}";
       push(@LIST, $v);
    }
  }

  my $g1 = "&GROUP=$q->{GROUP}" if (exists $q->{GROUP});
  $out =<<EOF;
<table border=1 cellpadding=1 cellspacing=0 width=95% bgcolor=white><tr bgcolor=$Style::DARK>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=HOST&host=$q->{host}$g1><font color=#FFFFCC>$L->{host}</font></a></td>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=TYPE&host=$q->{host}$g1><font  color=#FFFFCC>$L->{type}</font></a></td>
   <td><b><font color=white><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=NAME&host=$q->{host}$g1><font  color=#FFFFCC>$L->{name}</font></a></td>
   <td><b><center>
      <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=STATUS&host=$q->{host}$g1><font  color=#FFFFCC>$L->{sev}</font></a></td>
   <td><b><center>
     <a href=$Http::WEBPROC?GO=GUI::Instr::explore&sort=DATE&host=$q->{host}$g1><font  color=#FFFFCC>$L->{last_report}</font></a></td>
EOF


  my($gif, $details, $url);

  my $urls = Launch->read();
  my $last_h;
  foreach my $l (sort @LIST) {
     my @a = split(/\t/, $l);
     $gif = $details = "";
     my($t, $k) = split(/:/, $a[6]);
     my $mgmtLevel = $a[9];
     my $sev = int($a[5]+0.5);
     if ($sev > 0) {
        my $g = $GIF[$sev];
        $gif = "<a href=\"$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&file=$a[6]&host=$a[1]\" $target><img src=/gif/$g $L->{click} border=0 ></a>";
        $details = $DB->{$a[6]}->[1];
     } else {
     }

     my $h = Util->shortHostname($a[1]);
     my ($launch, $l1);

     if ($urls->{$t}[0] && $mgmtLevel ne "DS") {
        $launch = $urls->link($t, $IP{$a[6]});

        $l1 = "<table border=0 width=100% cellspacing=0 cellpadding=0><tr><td>$a[3]</td><td align=right>$launch</table>";
     } else {
        $l1 = $a[3];
     }

     if ($sort eq "HOST") {
        if ($h ne $last_h) {
           $out .= "<tr><td></td><tr><td>&nbsp;<b>$h</td>";
           $last_h = $h;
        } else {
           $out .= "<tr><td>&nbsp;$h</td>";
        }
        $out .= "<td>&nbsp;$a[2]</td>
       <td xnowrap>$l1</td>
       <td valign=middle><center>&nbsp;$gif</td>
       <td nowrap><center>&nbsp;" . substr($a[7],5) . "</td>";
     } else {
       $out .= "<tr><td>&nbsp;$h</td>
       <td>&nbsp;$a[2]</td>
       <td xnowrap>$l1</td>
       <td valign=middle><center>&nbsp;$gif</td>
       <td norap><center>&nbsp;" . substr($a[7],5) . "</td>";
     }

  }

  $out .= "</table>&nbsp;
  <input type=submit name=ACTION_CLEAR value=\"$L->{clear}\" 
           onclick=\"return confirm('$L->{confirm_del}')\"></form>";

  print $out;
  my($x, $g);

  print Html->readHtdocs('explore_trailer');
}

sub explore1F {
  my($q, $port, $util) = @_;
  my($url) = "host=$q->{host}&file=$q->{file}";
  print "<frameset rows=50%,* border=0>
     <frame src=$Http::WEBPROC?GO=GUI::Instr::explore1&$url name=left0 scrolling=auto>
     <frame src=javascript:return() name=main2 scrolling=auto>
 </frameset>
  ";
}

#@Map = ('al_ok3','al_alert3','al_crit3','al_down3');
@Map = ('bgcolor=#90F090><b>&nbsp;- ' ,
        'bgcolor=yellow><b>&nbsp;/ ',
        'bgcolor=red>&nbsp;<b>I&nbsp;'   ,
        'bgcolor=red><center><img src=/gif/al_down3.gif>',
       );

sub addAlert {
  my($k, $file, $Comp, $isLink) = @_;
  return "" if ($Comp->[0] < 0);
  my $G = Labels->read();
  my ($n, $grid, $ac);
  if ($isLink) {
    $n = $k; $grid = "";
    my $ev = State->eventHash($Comp->[2], "\t");
    if (exists $ev->{GridCode}) {
      my $gc = $ev->{GridCode};
      my $sev = $ev->{Severity};
      $ac = $ev->{Actionable} eq "TRUE" ? "Act." : "";
      $gc = Util->encode($gc);
      my $grid_no = Grid->getNo($ev->{GridCode});
      $grid = "[ <a href=javascript:info2('$gc','$sev')>$G->{advisor}</a> ]" if ($grid_no);
      $n .= "</b>";
    }
  } else {
    $n = substr($k,length($file)+1);
    $n = "Enclosure" if (index(",ei,eo,e,", ",$n,") >= 0);
    my $ev = State->eventHash($Comp->[4]);
    my $gc = $ev->{GridCode};
    my $sev = $ev->{Severity};
    $ac = $ev->{Actionable} eq "TRUE" ? "Act." : "";
    $gc = Util->encode($gc);
    my $grid_no = Grid->getNo($ev->{GridCode});
    $grid = "[ <a href=javascript:info2('$gc','$sev')>$G->{advisor}</a> ]" if ($grid_no);
    $n .= "</b> $ev->{OrigTargetName}" if (exists($ev->{OrigTargetName}));
  }
  #my $gif = "<img src=\"/gif/" . $Map[int($Comp->[0]+0.5)]. ".gif\">";
  my $gif = $Map[int($Comp->[0]+0.5)];
  return 
    "<tr><td><center><table border=0 cellspacing=0 cellpadding=0><tr><td $gif</table></td>
         <td><b>$n</b>&nbsp;$grid $ac</td>
     <tr><td></td><td><small> $Comp->[1]</td>
    ";
}

sub san_graph {
  my($q, $to, $parms, $to_dev) = @_;
  return if (!$to_dev);
  $q->{FILTER} = $q->{file};
  my ($t, $F) = System->newPngName();
  $q->{zoom} = 1 if (!defined($q->{zoom}));
  my ($map, $Coords) = TO::Graph->display($parms, $F, {zoom => $q->{zoom}, 
                 width => "MAX", height => "MAX",
                 circle => $q->{file},
                 text   => "Click to select",
                 url => "$Http::WEBPROC?GO=GUI::Instr::rStart&host=$q->{host}&".
                        "topo=$q->{topo}&Roption=5&file=",
                });
  print <<EOF;
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=95%><tr><td>
  <img src=/Web/$t ismap usemap=#map1 border=0>
  </table>
  <map name=map1> $map </map>

EOF
}

sub san_connections {
  my($q, $to, $to_dev) = @_;
  my $file = $q->{file};
  return if (!$to_dev);
  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
require TO;
  my $s =  $to->toC_dev($to_dev, 2, 
    "[ <a href=$Http::WEBPROC?GO=GUI::Test::get_testlink&topo=MERGE-MASTER&LINKH=0", 
    "LinkTest</a> ]") ;
  $s =~ s/\n\s+/\n&nbsp;/g;
  $s =~ s/\n/<br>/g;
  return ("<a href=#san_con>Connection Details</a>&nbsp;", 
         "<table border=1 width=95% cellspacing=0 cellpadding=1 bgcolor=white>$s</table>");

}


# HEALTH or GRAPH

sub state {
  my($q, $diagram) = @_;
  my($title);
  my $file = $q->{file};
  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my $deny = Roles->verifyRole($q, "admin|c_admin");
require TO;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{name}) {
    $title = "$q->{cat}:$q->{name}";
  } else {
    $title = $q->{file};
  }
  my($type, $key) = split(/\:/, $title);
  my $dev = $Config->deviceByKey($title);

  if ($q->{ACTION_delete}) {
     if ($q->{key}) {
       State->clearComponent($q->{key}, $q->{tstamp});
       State->clearAllLinks(undef, $q->{key}, $q->{tstamp});
       State->write();
     }
  }
  $q->{FILTER} = $q->{file};

  my $State;
  if ($q->{host} && $q->{host} ne $renv->{hostname} && 
      index(",host,se,se2,", ",$type,") < 0 && !$Config->deviceByKey($file) ) {
    my $i  = Util->rasInfo($q->{host});
    print "</b>Calling $q->{host}...<br>\n";
    $State = State->readFromDevice($q->{host}, $i->{hostname});
  } else {
    $State = State->read();
  }
  my $Comp   = $State->components();
  my $t1     = $diagram ? $L->{graph} : $L->{alerts};
  my $title2 = $dev ? ($dev->{userLabel} || $dev->{type}) . " $dev->{name} $dev->{ipno}" : $title ;

  print "<script>
   function info2(a, sev) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&code=' + a + '&sev=' + sev;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
   }
   </script>
   <table border=0 cellspacing=1 cellpadding=2 width=95% bgcolor=$Style::DARK>
      <tr><td><b><font color=white>&nbsp;$t1 of $title2</td> </table> ";

  my ($san_con, $san_con_link, $t3_diag, $t3_diag_link);

  if ($diagram) {
    $q->{topo}   = "MERGE-MASTER" if (!$q->{topo});
    my ($parms, $to) = TO::Applet->genAppletData($q) ;
    if ($to) {
      my $to_dev = $to->nodeByName($q->{file});
      &san_graph($q, $to, $parms, $to_dev);
      # GRAPH
      ($san_con_link, $san_con) = &san_connections($q, $to, $to_dev);
      if ($type eq "t3") {
        my $diag =TO::T3->diagramApplet($title, $Comp, $to);
        $t3_diag_link = "<a href=#diag>T3 Graph</a>";
        $t3_diag = "<a name=diag>&nbsp;
          <table border=0 width=95% cellpadding=2 cellspacing=0>
           <tr><td><b>T3 Graph</td>
               <td align=right>[ <a href=#top>$L->{top}</a> ]</td></table>
        <table border=0 cellspacing=1 cellpadding=0 width=90% bgcolor=black>
           <tr><td><center>$diag</table>";
      }
      my $ll = $san_con_link;
      $ll .= " | " if ($t3_diag_link && $san_con_link);
      $ll .= $t3_diag_link;
      print "<table border=0 cellspacing=2 width=95%><tr>
           <td align=right>[ $ll ]&nbsp;</table>";
    } else {
      print "<table border=1 cellspacing=0 cellpadding=2 width=95% bgcolor=white><tr>
           <td>$L->{noTopo}</table>";
    }
  }
  print " <table border=1 cellpadding=2 cellspacing=0 width=95% bgcolor=white>\n";

  # COMPONENT HEALTH
  my ($cnt, $out, @LL);
  foreach my $k (keys %$Comp) {
     if (substr($k,0,length($file)) eq $file) {
       my $dd = substr($Comp->{$k}[1],0,20);
       push(@LL, "$dd\t$k\t$file\t");
     }
  }

  # LINK HEALTH
  my $Links = $State->links();
  foreach my $k (sort keys %$Links) {
     my($f1,$f2) = split(/\|/, $k);
     my $dd = substr($Links->{$k}[1],0,20);
     if (substr($f1,0,length($file)) eq $file) {
       my $el = "link to " . $f2;
       push(@LL, "$dd\t$k\t$file\t$el");

     } elsif (substr($f2,0,length($file)) eq $file ) {
       my $el = "link to " . $f1;
       push(@LL, "$dd\t$k\t$file\t$el");
     }
  }
  # SORT AND MERGE
  foreach my $ll (reverse sort @LL) {
     my($dd, $k, $file, $el) = split(/\t/, $ll);
     my $new;
     if ($el) {
       $new = &addAlert($el,$file, $Links->{$k}, 1);
     } else {
       $new = &addAlert($k,$file, $Comp->{$k});
     }
     $out .= $new;
     $cnt++ if ($new);
  }

  print $out;
  if (!$cnt) {
    print "<tr><td colspan=3><b>$L->{no_alerts}</td>";
  } 
  print "</table>&nbsp;";
  if ($san_con) {
    print "<p><a name=san_con>&nbsp;";
    print "<table border=0 width=95% cellpadding=2 cellspacing=0>
           <tr><td><b>$L->{conn_details}</td>
               <td align=right>[ <a href=#top>$L->{top}</a> ]</td>
         </table>
          $san_con &nbsp<p> $t3_diag &nbsp;<p>";
  }
  if (!$diagram) {
    my $tstamp = Util->get_today();
    print "<form>
      <input type=hidden name=GO value=GUI::Instr::rStart>
      <input type=hidden name=tstamp value=\"$tstamp\">
      <input type=hidden name=key value=\"$title\">
      <input type=hidden name=Roption value=2>
      <input type=hidden name=file value=$file>";
    if ($cnt && !$deny) {
      print "<b><input type=submit name=ACTION_delete value=\"$L->{submit_del}\">";
    }
    print "</form>";
  }
}


sub explore1 {
  my($q, $port, $util) = @_;
  my($data, @a);
  print Html->text_header();

  my($WIN) = "WIN=$q->{WIN}" if ($q->{WIN});
  
  print "\n<body bgcolor=$Style::BGCOLOR leftmargin=2 topmargin=2 marginwidth=2 marginheight=2>";
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";
  my($ip);
  my($renv) = System->get_renv();
  $q->{host} = "" if ($q->{host} eq $renv->{hostname});
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{host}) {
    print "$G->{calling} $q->{host}...<br>\n";
    my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
    foreach my $h (@$hosts) {
      if ($h->{hostname} eq $q->{host} || $q->{host} eq $h->{ip}) {
        $ip = $h->{ip};
        last;
      }
    }
    $ip = $q->{host} if (!$ip);
  }

  my ($err, $VAR1) = Report->readSpecial({ host  => $ip,
                                  timeout  => 10,
                                  file     => $q->{file},
                                  wwn      => $q->{wwn},
                                  name     => $q->{name} });
     
  if ($err) {
    print Html->warning($G->{no_report});
    print "&nbsp;<p><small>$err<br>";
    return;
  }
  require Report;

  my($id) = $VAR1->id();
  my $lost;
  if ($VAR1->status() eq "CC") {
    $lost = "<font color=red><b>$G->{cannot_comm}</b></font>" ;
  }
  $q->{file} = "$id->{category}:$id->{deviceName}";

 # $pl = "<font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Instr::explore1&host=$q->{host}&file=$q->{file}&level=0><font color=white>$G->{close}</font></a> ] ";
  print "
 $lost
<table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
  <tr><td bgcolor=$Style::DARK colspan=2>
   <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td colspan=2><b><font color=white>" . uc($id->{category}) . ":$id->{name}</td>
      <tr><td colspan=2><b><font color=white>$G->{last_probe}: $VAR1->{_created}</td>
   </table>
<tr><td colspan=2><font face=arial,helvetica>
  <table border=0><tr><td></table>
 ";

  my $h = $VAR1->value();

  if ($id->{category} eq "t3" || $id->{category} eq "6120") {
     foreach my $el ('loop','volume','fc_stats', 'volume_disk') {
        $h->{"$el.header"} = $el;
     }
  }
  require Html::Tree;
  my $tree =  Html::Tree->new({
                     this => "$Http::WEBPROC?GO=GUI::Instr::rStart&file=$q->{file}&host=$q->{host}&Roption=4",
                           q => $q,
                      sysgif => '/gif',
                     linkall => 1,
                        name => "ROOT"});
  my %X = ();
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    my $ix = rindex($k, ".");
    my $k1 = $k;
    if ($ix > 0) {
      $k1 = substr($k, 0, $ix);
    }
    $X{$k1} = 1;
  }
  my(@X) = ();
  print " <img src=/gif/menu_root.gif border=0 align=top>&nbsp;<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$q->{file}&host=$q->{host} >$id->{category}:$id->{deviceName}</a><br>";

  foreach my $k (sort keys %X) {
    my $k2 = $k; $k2 =~ s/\./\//g;
    push(@X, [ $k2, "$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=4&file=$q->{file}&section=$k2&host=$q->{host}" ]);
  }
  print $tree->read(\@X);
  print "<br>&nbsp;</table></table>";
  if ($q->{section}) {
     print "<table border=0><tr><td></table>";
     &explore2($q);
  }
}


sub explore2 {
  my($q, $port, $util) = @_;
  my($local);
  require Report;
  my($data);
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";

  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";
  
  if ($q->{host}) { # remote file
     my($D2) = System->get_home() . "/DATA/remote";
     $data = Util->readf("$D2/$q->{file}");

#     $url = Util->makeUrl($q->{host}, "?GET=run_file&file=$q->{file}");
#     print "Retrieving data from $url...<br>";
#     $data = Util::Http->get($url, 30);
     $local =0;
  } else {          # local file
     $data = Util->readf("$P/$q->{file}");
     $local =1;
  }
  if (substr($data,0,3) =~ /ER/) {
     print "$data<br>";
     return;
  }
  my($VAR1);
  eval $data;
  my $h = $VAR1->value();
  my($id) = $VAR1->id();
  my $section = $q->{section};

  my $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=1 cellpadding=1 cellspacing=0 width=100% bgcolor=white>
  <tr><td colspan=2 bgcolor=$Style::DARK>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my ($val, $k0, $v, $ix, $cnt);
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    next if ($l && substr($k,0,$l) ne $section);
    next if ($l && length($k) > $l && substr($k,0,$l+1) ne "$section.");
    $k0 = $k;
    $k0 = substr($k, $l+1) if ($l);
    $ix = index($k0,".");
    if ($ix > 0) {
      $v = substr($k0,0,$ix);
      if ($v ne $last) {
        print "<tr><td colspan=2>&nbsp;</td>" if (defined($last));
        $last = $v;
      }
    }
    my $co = ($cnt++ % 2 == 0) ? "bgcolor=#F0F0F0" : "";
    
    print "<tr $co><td>&nbsp;";
    print "$k0</td><td>";
    $val= $h->{$k};
    require Data::Dumper;
    $Data::Dumper::Indent = 1;
    if (ref($val)) {
      print "<pre>" . substr(Data::Dumper::Dumper($val),7) . "</td>";
    } else {
      print " = $val</td>";
    }
  }
  print "</table></table><center>";
  print "&nbsp;";


}

# NU
sub update {

  my($q, $port, $util) = @_;
  require Report;
  print "\n<body bgcolor=$Style::BGCOLOR>";
  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";
  my $G = Labels->read();

  my($l);
  if ($q->{ACTION} eq "Update") {
     open(O, System->get_home() ."/$q->{file}");
     open(W, ">" . System->get_home() . "/$q->{file}.new");  
     while ($l = <O> ) {
         chop($l);
         @a = split(/ *\= */, $l);
         if ($a[0] eq "$q->{section}.$q->{value}") {
            print W "$a[0]  = $q->{new}\n";
         } else {
            print W $l . "\n";
         }
     }
     close(O); close(W);
  }
  my($data);
  if ($q->{host}) { # remote file
     print "$G->{ret_data} $q->{host}...<br>";
     require Util::Http;
     $data = Util::Http->getCommand($q->{host}, "run_file&file=$q->{file}", $main::TO);

  } else {          # local file
     $data = Util->readf(System->get_home() ."/$q->{file}");
  }
  if (substr($data,0,3) =~ /ER/) {
    print "$data<br>";
    return;
  }
  my $r = eval substr($data, 7);
  my $h = $r->value();
  my $id = $r->id();
  my $section = $q->{section};

  $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white><tr><td bgcolor=black>
<table border=0 cellpadding=0 cellspacing=0 width=100% bgcolor=white>
 <form  method=get>
 <input type=hidden name=GO value=update>
 <input type=hidden name=section value=$q->{section}>
 <input type=hidden name=value value=$q->{value}>
  <tr><td colspan=2 bgcolor=$Style::DARK>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my($k0);
  foreach my $k (sort keys %$h) {
    next if ($l && substr($k,0,$l) ne $section || substr($k,0,1) eq "_");
    $k0 = $k;
    next if (substr($k0, 0 - length($q->{value})) ne $q->{value});
    $k0 = substr($k, $l+1) if ($l);
    my $ix = index($k0,".");

    print "<tr><td align=right><b>$k0: </td>
               <td><input type=text name=new value=\"$h->{$k}\"></td>";
  }
  print "</table></table><center><input type=submit name=ACTION value=Update>";
  print "</form>&nbsp;";
  
}


sub mon {
  my($type, $name) = @_;
  my(%D);
  if (defined($D{$type}{$name})) {
    return ($D{$type}{$name}[0] eq "Y")? "<font color=green><b>On":"<font color=red><b>Off"
  } else {
    return "<font color=red><b>No";
  }
}

sub header {
  my($q,  $url0, $title, $url, $window) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window= $ruser->{window} || $renv->{window};

  my $u = "> <a href=$url0&Roption=$q->{Roption}>Device $title</a>" if (index($FRAME2, $window) < 0);
  print Html->header2("monitor.devices", "95%", $u);

  #} else {
  #  print "</center><b>$title</b><center>";
  #}
  print "<table border=0 bgcolor=#F0F0F0 cellspacing=0><tr><td nowrap>$url</table>";
  print "<table border=0><tr><td></table>";
}

sub rStart {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $window= $ruser->{window} || $renv->{window};
  my $summ  = (index($FRAME2, $window) < 0) ? $L->{summary2}: $L->{summary}, 

  my $h     = "$Http::WEBPROC?GO=GUI::Instr::rStart&host=$q->{host}&file=$q->{file}&topo=$q->{topo}";
  my @S;
  $S[1] = "<a href=$h&Roption=1><font color=blue>$summ</font></a>";
  $S[2] = "<a href=$h&Roption=2><font color=blue>$L->{alerts}</font></a>";
  $S[3] = "<a href=$h&Roption=3><font color=blue>$L->{log}</font></a>";
  $S[4] = "<a href=$h&Roption=4><font color=blue>$L->{report}</font></a>";
  $S[5] = "<a href=$h&Roption=5><font color=blue>$L->{graph}</font></a>";
  $S[6] = "<a href=$h&Roption=8><font color=blue>$L->{info}</font></a>";
  my $tst   = " | <a href=$h&Roption=6><font color=blue>$L->{test}</font></a>" if ($q->{topo});

  print Html->body();
  print "<a name=top>";
  my($x);
  my $url= "[ ";
  for ($x=1; $x <= 5; $x++) {
     $url .= $q->{Roption} eq $x ? "<b>$S[$x]</b>" : $S[$x];
     $url .= " | " if ($x < 5);
  }
  $url .= "$tst ]<br>";

  if ($q->{Roption} == 2) {       # ALARMS
     &header($q, $h, $L->{alerts}, $url, $window);
     &state($q);

  } elsif ($q->{Roption} == 6) {  # TEST
     $q->{enc} = "$q->{file}:e";
     delete($q->{file});
     $q->{TAB} = 1;
     require GUI::Test;
     GUI::Test::get_test($q);

  } elsif ($q->{Roption} == 3) {  # LOG

     require GUI::EventLog;
     &header($q, $h, $L->{log}, $url, $window);
     $q->{NOBACK} = 1;
     GUI::EventLog::display($q);

  } elsif ($q->{Roption} == 4) {  # REPORT
     &header($q,$h,  $L->{report}, $url, $window);
     &explore1($q); 

  } elsif ($q->{Roption} == 5) {  # GRAPH
     &header($q, $h, $L->{graph}, $url, $window);
     &state($q, 1); 
  } else {                        # SUMMARY
     &header($q, $h, $summ, $url, $window);
     &report($q);  
  }
}



sub report {
  my($q) = @_;
  require TO;
  my($type, $wwn) = split(/:/, $q->{file});
  my $host1 = substr($q->{file}, 5) if ($type eq "host");

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart');

  if (0) {
   if ($type eq "host") {
     my $to = TO->readTopo($q->{topo});
     if ($to) {
       my $ho = $to->nodeByName($q->{file});
       $host1 = substr($ho->name(), 5);
       if ($ho) {
         $q->{file} = "host:$ho->{info}{hostid}";
       }
     }
   }
  }
  my($renv) = System->get_renv();
  my $Config = PDM::ConfigFile->read();

  $q->{host} = "" if ($q->{host} eq $renv->{hostname});
  if ($q->{host}) {
    print "Calling $q->{host}...<br>\n";
  }
  my($err, $VAR1) = Report->readReport($q->{file}, $q->{host}, 10);
  if (!$VAR1) {
     print Html->warning($L->{err_no_report});
     $err =~ s/</&lt;/g;
     print "<p><small>$err";
     return ;
  }

  if ($err) {
   $VAR1 = undef;
   if ($type ne "host") {
     print Html->warning($L->{err_no_report});

     return ;
   }
  }
  my $t1 = $VAR1->category();
  my $ip1 = $VAR1->value("id.ipno");

  if ($renv->{solution} eq "N") { # launch option
    my $urls = Launch->read();
    my $dev = $Config->deviceByKey($q->{file});
    if ($urls->{$t1}[0] && $dev) {
       my $u_out = $urls->link($t1, $dev, 1);
       print "<table border=0 cellspacing=0 width=90% cellpadding=0><tr><td align=right>Launch: $u_out</table>";
    }
  }
  my $Comments = Util->deserialize("Comments.txt");
  if ((my $com = $Comments->{$wwn})) {
    print "<table border=0 cellspacing=1 width=95% bgcolor=white><tr><td>$com</table>";
  }
  print "\n<body bgcolor=$Style::BGCOLOR topmargin=2 marginheight=2><center>";

  my $module = uc($type);
  eval "require \"Agent/$module.pm\"";
  $module = "Agent::$module";

  if (!$@) {
    print $module->REPORT($q->{host}|| $renv->{hostname}, $VAR1, {host => $host1, q => $q});
  }

}

  

sub readR {
  my($file) = @_;
  my(@a, $v);
  open(O, System->get_home() . "/DATA/OLD_REPORTS/$file");

  @a = <O>; close(O);

  my $l = '$v = ' . substr("@a",7);
  eval $l;
  return $v;
}


1;
 
