package GUI::FruReport;

use Report;
use Reports;
use Reports::Fru;
use System;
use Html::List;
use strict;
use Modules;
use Process;
use Math;

sub compare {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');
  my @L;

  foreach my $el (keys %$q) {
     if (substr($el,0,4) eq "sel_") {
       push(@L, substr($el,4));
       last if ($#L == 1);
     }
  }
  my $r1 = Util->deserialize("FruReport_history/$L[0]");
  my $r2 = Util->deserialize("FruReport_history/$L[1]");
  my (%ENC, %ENC2, %FRU, %FRU2);
  print "<table border=1 width=95% cellpadding=2 cellspacing=0 bgcolor=white><tr>
          <tr><td colspan=4 bgcolor=$Style::DARK>
             <font color=white><b>$LB->{title4}</td>
         <tr><td colspan=4><b>$L[0] &nbsp; and &nbsp; $L[1]
         <tr><td></td>
         <tr bgcolor=$Style::LIGHT>
             <th>$LB->{action}</td>
             <th>$LB->{dev}</td>
             <th>$LB->{old}</td>
             <th>$LB->{new}</td>";

  my $changes;
  foreach my $el (@$r1) {
     $ENC{$el->[0]} = $el;
     my $fru = "$el->[0].$el->[1].$el->[2].$el->[3]";
     $FRU{$fru} = $el;
  }
  foreach my $el (@$r2) {
     $ENC2{$el->[0]} = $el;
  }
  foreach my $el (keys %ENC) {
     my $v = $ENC{$el};
     if (!$ENC2{$v->[0]}) {
       print "<tr><td>$LB->{del}</td><td>$v->[0]</td><td colspan=2>&nbsp;</td>\n";
       $changes++;
     }
  }
  foreach my $el (keys %ENC2) {
     my $v = $ENC2{$el};
     if (!$ENC{$v->[0]}) {
       print "<tr><td>$LB->{add}</td><td>$v->[0]</td><td colspan=2>&nbsp;</td>\n";
       $changes++;
     }
  }

  foreach my $el (@$r2) {
     my $dev = $el->[0];
     next if (!$ENC{$dev});
     my $fru = "$el->[0].$el->[1].$el->[2].$el->[3]";

     if (!$FRU{$fru}) {
        print "<tr><td>$LB->{new_fru}</td><td>$fru</td><td colspan=3>&nbsp;</td>\n";
        $changes++;
     } else {
        my $el0 = $FRU{$fru};
        if ($el0->[4] ne $el->[4] || $el0->[5] ne $el->[5] || $el0->[6] ne $el->[6]) {
          my $v1 = "$LB->{vendor}:$el0->[4], $LB->{model}: $el0->[5], $LB->{serial}:$el0->[6]";
          my $v2 = "$LB->{vendor}:$el->[4], $LB->{model}: $el->[5], $LB->{serial}:$el->[6]";
          print "<tr><td>$LB->{rep}</td><td>$fru</td><td>$v1 <td>$v2</td>\n";
          $changes++;
        } elsif ($el0->[7] ne $el->[7]) {
          print "<tr><td>$LB->{rev}</td><td>$fru</td><td>$el0->[7]<td>$el->[7]</td>\n";
          $changes++;
        }
     }
  }
  print "</table>";
  if (!$changes) {
     print $LB->{no_diff} . "!<br>";
  }

}

sub history {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');
  print Html->body();

  if ($q->{ACTION_delete}) {
    my $del;
    print Html->header2("report.general.fru_hist");
    foreach my $el (keys %$q) {
      if (substr($el,0,4) eq "sel_") {
        my $file = System->get_home() . "/DATA/FruReport_history/" . substr($el, 4);
        unlink $file;
        $del++;
      }
    }
    print Html->info("Deleted $del archived report(s).");

  } elsif ($q->{ACTION_compare}) {
     print Html->header2("report.general.fru_hist", 0, 0, {noHelp => 1});
     &compare($q);
     return;
  } else {
    print Html->header2("report.general.fru_hist");
  }

  my $D = System->get_home() . "/DATA/FruReport_history";

  opendir(O, $D);
  my @l = readdir(O); closedir(O);
  print "
    <table border=0><tr><td></table>
    <table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
  <tr><td colspan=2 bgcolor=$Style::DARK>
     <form><input type=hidden name=GO value=GUI::FruReport::history>
     <font color=white><b>$LB->{hist}
     <tr bgcolor=$Style::LIGHT>
        <td><b>&nbsp;$LB->{creation}
        <td>&nbsp;<b>$LB->{sel}
  ";
  my $cnt;
  foreach my $f (@l) {
     next if ($f !~ /fru_report/);
     my($name, $date) = split(/\./, $f);
     $date =~ s/_/ /g;
     my $sel = "<input type=checkbox name=sel_$f>";
     print "<tr><td>$date</td><td>$sel</td>";
     $cnt++;
  }
  if (!$cnt) {
    print "<tr><td colspan=2>$LB->{no_arch}</td>";
  }
  print "</table>
   <b><input type=submit name=ACTION_compare value=\"$LB->{submit_comp}\"> &nbsp;
   <b><input type=submit name=ACTION_delete value=\"$LB->{submit_sel}\">";
}

sub frus {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');

  my $LIST = [
    [ "fruDetail.html",   "GUI::FruReport::frus0", $LB->{report1}],
    [ "fruDetail2.html",  "GUI::FruReport::frus0_health", $LB->{report1_health}],
    [ "fruSummary1.html", "GUI::FruReport::summ1", $LB->{report2}],
    [ "fruSummary2.html", "GUI::FruReport::summ2", $LB->{report3}],
    [ "fruSummaryB.html", "GUI::FruReport::battery", $LB->{reportB}],
    [ "fruTemp.html",     "GUI::FruReport::temperature", $LB->{reportTemp}],
    [ "fruTemp2.html",    "GUI::FruReport::temperature2", $LB->{reportTempUCL}],
    ];
  my ($info, $started);
  
  if ($q->{ACTION_archive}) {
    my $D = System->get_home() . "/DATA/FruReport_history";
    my $F = System->get_home() . "/DATA/tmp/fru_report";
    my $date1 = Util->get_file_created($F);
    $date1 =~ s/ /_/g;
    mkdir $D, 0777 if (!-d $D);
    open(O, $F);
    open(W, ">$D/fru_report.$date1");
    my ($l);
    while ($l = <O>) {
       print W $l;
    }
    close(O); close(W);
    print Html->info($LB->{arch_done});

  } elsif ($q->{ACTION_new}) {
    my $st = Process->status(undef, "fru_report");
    my $cpid;
    if ($st =~ /Running/) {
       print Html->warning($LB->{running});
    } else {
      $SIG{CHLD} = 'IGNORE';
      if (($cpid = fork()) == 0) {
        Process->start("fru_report");
        close STDIN; close STDOUT; close STDERR;
        Reports::Fru->new(1);
        exit;
      } else {
        sleep(1);
        $info = Html->info($LB->expand(started => $cpid) );
        $started = 1;
      }
    }

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Fru Report", $LIST);
      $info= "Email sent!<br>";
    } else {
      print Html->error($LB->{email});
    }
  }
  my $st = Process->status(undef, "fru_report");
  my($new, $meta);
  if ($st =~ /Running/ || $started) {
    $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=GUI::FruReport::frus\">" 
  } else {
    $new = "<input type=submit name=ACTION_new value=\"$LB->{submit_new}\">";
  }

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/fru_report");
  my ($archive);

  print Html->body();
  print $meta;
  print Html->header2("report.general.fru_report");
  my $dis1 = $st;
  $dis1 .= "..." if ($st =~ /Running/);

  if ($date) {
    $archive = "<input type=submit name=ACTION_archive value=\"$LB->{submit_archive}\">" 
  }

  print "$info
   <form>
   <input type=hidden name=GO value=GUI::FruReport::frus>
  <table border=1 cellspacing=0 width=90% bgcolor=white cellpadding=1>
   <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$LB->{create}</td>
   <tr><td align=right width=45% bgcolor=$Style::LIGHT>
         <table border=0><tr><td>$LB->{report_status}:</table></td><td><b>&nbsp;$dis1</td>
   </table><b>
     $new
     &nbsp;
     $archive
     </b>
  <table border=0><tr><td></table>
   ";

   print Reports->list($q, $LIST, $date);
   print "</form>";


}

sub frus0_health {
  my($q) = @_;
  $q->{health} = 1;
  return &frus0($q);
}

sub frus0 {
  my($q) = @_;
  my (%TYPE, %DEV, @NEW, $out);
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  $out .= Html->body();
  my $LB = Labels->read('GUI::FruReport');

  $out .= "<table border=0><tr><td></table>";
  $out .= Html->header2("report.general.fru_report", undef, undef, undef, 
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  $out .= "<table border=0><tr><td></table>";

  my $REP = Reports::Fru->new();
  if (! $REP) {
     print Html->error($LB->{no_report});
     return ;
  } 
  $REP = Reports::Fru->health($REP) if ($q->{health});

  foreach my $el (@$REP) {
	  $DEV{$el->[1]} = 1;
	  $TYPE{$el->[2]} = 1;
	  next if ($q->{DEV} && ($q->{DEV} ne $el->[1]));
	  next if ($q->{TYPE} && ($q->{TYPE} ne $el->[2]));
	  push(@NEW, $el);
  }
  $REP = \@NEW;
  my @tt = split(/\,/, $LB->{titles1}); 
  my($pageInfo, $list) = Html::List->makeList($q, $REP,
        [@tt],
        [  'l',   'l',    'l',    'l',   'l',    'l'  ,   'l',      'l',      'l' ],
        [ '+sn',  '+',    '+',    '+',   '+' ,   '+',     '+',      '+',      '+' ],
                     {pageSize => 200, interactive => !$q->{email} });

  my $sel = "<select name=DEV><option value=\"\">[$LB->{device_type}]</option>"; 
  foreach my $el (sort keys %DEV) {
	  my $ck = $el eq $q->{DEV} ? "selected" : "";
	  $sel .= "<option value=\"$el\" $ck>$el</option>";
  }
  $sel .= "</select>";
  my $types = "<select name=TYPE><option value=\"\">[$LB->{fru_type}]</option>"; 
  foreach my $el (sort keys %TYPE) {
	  my $ck = $el eq $q->{TYPE} ? "selected" : "";
	  $types .= "<option value=\"$el\" $ck>$el</option>";
  }
  $types .= "</select>";
  my $title1 = $q->{health} ? $LB->{report1_health} : $LB->{report1};
  my $jump   = $q->{health} ? "frus0_health"        : "frus0";
  $out .= "
  <table border=0 cellspacing=0 cellpadding=0 bgcolor=white cellpadding=0 width=90%>
    <tr><td>&nbsp;$title1</td>
    <td align=right><form><input type=hidden name=GO value=GUI::FruReport::$jump>
	 <input type=hidden name=SORT value=$q->{SORT}>
	 <input type=hidden name=SIGN value=$q->{SIGN}>
        <b>&nbsp;Filters: $sel 
        &nbsp; &nbsp; $types 
	<input type=submit name=ACTION_filter value=GO>&nbsp;</td>
  </table>
  <table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
    $list
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=95%>
    <tr><td>$pageInfo</td>
        <td align=right>
  </table>
  ";
  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }
}

sub summ1 {
  my($q) = @_;
  my $out;
  $out .= Html->body();
  $out .= Html->header2("report.general.fru_report", undef, undef, undef, 
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my $R = $REP->summ1();
  my @tt = split(/,/, $LB->{titles2});
  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [@tt],
        [  'l',   'l',     'l',       'l',      'l',    'l'  ,      'r',   ],
        [ '+sn',  '+',     '+',       '+',      '+' ,   '+',        '-'    ],
                     {pageSize => 200, interactive => !$q->{email} });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=90%>
    <tr><td colspan=7>$LB->{report2}</td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>

    $list
  </table>
  ";
  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}

sub summ2 {
  my($q) = @_;

  my $out= Html->body();
  $out .= Html->header2("report.general.fru_report", undef, undef, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my ($R, $tot) = $REP->summ2();
  my @tt = split(/,/, $LB->{titles3});
  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ @tt ],
        ['l',     'l',       'l',      'l',    'l'  ,      'r',    ],
        [ '+sn',   '+',      '+',      '+',    '+' ,       '-'     ],
                     {pageSize => 200, interactive => !$q->{email} });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=90%>
    <tr><td colspan=7>$LB->{report3}</td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>

    $list
   <tr><td align=right colspan=5>Total:</td><td align=right><b>$tot&nbsp;</td>
  </table>
  ";
  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}

sub temp {
  my($q) = @_;

  print Html->body();
  my $REP = Reports::Fru->new();
  my @R;
  foreach my $el (@$REP) {
     next if ($el->[0] ne $q->{name});
     if (defined ($el->[9])) {
       push(@R, [$el->[2], $el->[3], $el->[4], $el->[5], $el->[7], $el->[9]]);
     }
  }

  my($pageInfo, $list) = Html::List->makeList($q, \@R,
        [ "Type", "Fru",   'Vendor','Model' , 'Rev', "Temp"    ],
        ['l',     'l',     'l',     'l',      'l',    'r'       ],
        [ '+',    '+',     '+',     '+',      '+',    '-'       ],
             {pageSize => 200, interactive => 1 });

  print  "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=90%>
    <tr><td colspan=3>Temperature Details for $q->{name}</td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>
    $list
  </table>
  ";
  
}

sub temperature2 {
  my($q) = @_;

  my $out = Html->body();

  my $LB = Labels->read('GUI::FruReport');
  $out .= Html->header2("report.general.fru_report", undef, $LB->{reportTempUCL}, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});

  $out .= "<table border=0><tr><td></table>";
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();

  if (! $REP) {
     $out .= Html->error($LB->{no_report});
     return $out;
  } 
  my ($R, $tot, $std, $avg, $lcl, $ucl) = $REP->temperature({ucl => 1});
  my(@R2);
  foreach my $el (@$R) {
     push(@R2, [$el->[0], $el->[1],$el->[2],$el->[3],$el->[4],$el->[5], 
               $el->[6], $el->[7],$el->[9]]);
  }
  $avg = sprintf("%.2f", $avg);
  $std = sprintf("%.2f", $std);
  $lcl = sprintf("%.2f", $lcl);
  $ucl = sprintf("%.2f", $ucl);

  $out .= "<table border=0 cellpadding=2 width=90% bgcolor=white>
  <tr><td>Fru Count: <b>$tot</b>, Average temp. of all frus: <font color=blue><b>$avg</b></font>, Std-Dev: <b>$std</b><br> Lower Control Limit: <font color=red><b>$lcl</b></font>, Upper Control Limit: <font color=red><b>$ucl</b></font></table>";

  my($pageInfo, $list) = Html::List->makeList($q, \@R2,
        [ "DeviceName", "Type", "Fru",   'FruId', 'Vendor','Model' , 'Serial#', 'Rev', "Temp"    ],
        ['l',           'c',     'l',    'l',     'l',     'l',      'l',       'l',    'c'       ],
        ['+',           '+',    '+',     '+',     '+',     '+sn',      '+',       '+',    '-'       ],
         {pageSize => 200, interactive => 1 });

  $out .= "
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>
    $list
  </table>
  &nbsp;<p>
  <table border=0 width=60% bgcolor=white><tr><td>
    Note: Upper Control Limit (UCL) is 3 standard deviations from the median, excluding
      99.73% of the frus.
   </table>
  ";

  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}

sub temperature {
  my($q) = @_;

  my $out = Html->body();

  $out .= "<script>
  function win1(a) {
     var b = '$Http::WEBPROC?GO=GUI::FruReport::temp&name=' + a;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
      O.focus();
  }
  </script>
  " ;
  my $LB = Labels->read('GUI::FruReport');
  $out .= Html->header2("report.general.fru_report", undef, $LB->{reportTemp}, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});

  $out .= "<table border=0><tr><td></table>";
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();

  if (! $REP) {
     $out .= Html->error($LB->{no_report});
     return $out;
  } 
  my ($R, $tot, $std, $avg, $lcl, $ucl) = $REP->temperature();

  foreach my $e (@$R) {
     $e->[0] = "<a href=javascript:win1('$e->[0]')>$e->[0]</a>";
     $e->[4] = sprintf("%2.2d", $e->[3] - $e->[2]+ 1);
  }
  $avg = sprintf("%.2f", $avg);
  $std = sprintf("%.2f", $std);
  $lcl = sprintf("%.2f", $lcl);
  $ucl = sprintf("%.2f", $ucl);

  $out .= "<table border=0 cellpadding=2 width=90% bgcolor=white>
  <tr><td>Device Count: <b>$tot</b>, Average Temp: <font color=blue><b>$avg</b></font>, Std-Dev: <b>$std</b>, Lower Control Limit: <font color=red><b>$lcl</b></font>, Upper Control Limit: <font color=red><b>$ucl</b></font></table>";

  my $head ="Temperature Distribution</b> (Number of frus for each degree Celsius)<pre>0         1         2         3         4         5         6\n0123456789012345678901234567890123456789012345678901234567890</td>";

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ "DeviceName", $head,     "Low", "High" , "Spread"   ],
        ['l',           'x',       'c',     'c' , 'c'     ],
        [ '+',         undef,      '+',    '-'  , '-'    ],
          { pageSize => 200, interactive => 1 });


  $out .= "
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>
    $list
  </table>
   &nbsp;
  <table border=0 width=90%><tr><td>Device Count: <b>$tot</b>, Average: <font color=blue><b>$avg</b></font>, StdDev: <b>$std</b>, LCL: <font color=red><b>$lcl</b></font>, UCL: <font color=red><b>$ucl</b></font><br><small>Lower and Upper Control Limits are 3 standard deviations under and over the median.</table>
  ";


  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}


sub battery {
  my($q) = @_;

  my $out= Html->body();
  $out .= Html->header2("report.general.fru_report", undef, undef, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my ($R, $tot) = $REP->battery();
  my @tt = split(/,/, $LB->{titlesB});
  $q->{SORT} = 1 if (!$q->{SORT});

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ @tt ],
        ['l',     'l',       'l'           ],
        [ '+sn',    '+',     '+'            ],
             {pageSize => 200, interactive => !$q->{email},
              colDisplay => [\&p_age] });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=90%>
    <tr><td colspan=3>$LB->{reportB}</td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>

    $list
   <tr><td align=right colspan=2>Total:</td><td align=right><b>$tot&nbsp;</td>
  </table>
  ";
  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}

# age is hours

sub p_age {
  my($age) = @_;
  if ($age == 0) {
     return "<td>Data Not Available</td>";
  } elsif ($age < 0) {
     my $days = 0 - int($age / 24);
     return "<td bgcolor=#FFD0D0><b>PAST REPLACEMENT DATE (by $days days)</td>";
  } else {
     my $days = int($age / 24);
     my $dd = "$days days " if ($days > 0);
     my $hours = $age - $days * 24;
     if ($days < 38) {
       return "<td bgcolor=#FFD0D0><b>$dd $hours hrs</td>";
     } else {
       return "<td>$dd $hours hrs</td>";
     }
  }
}



1;

