package GUI::Discover;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict 'vars';
use System;
use Util;
use TO;
use GUI::Devices;
use Logic::SWITCH;


sub details {
  my($q) = @_;
  my $type = $q->{type};
  print Html->body();
  print "<table border=1 cellspacing=0 width=100% bgcolor=white>
   <tr><td bgcolor=$Style::DARK colspan=4><font color=white><b>Discovered devices</td>
   <tr bgcolor=$Style::LIGHT>
       <th>Agent</th>
       <th>Type</th>
       <th>Name</th>
       <th>IP</th>
  ";
 my $D = System->get_home() . '/DATA/Discover';
 opendir(O1, $D);
 my @files = readdir(O1); closedir(O1);
 my ($agent, $l);
 foreach my $f (@files) {
    if ($f =~ /^$type.(.+)/) {
       $agent = $1;
       open(O1, "$D/$f");
       while ($l = <O1>) {
           chop($l);
           next if (substr($l,0,1) eq "#");
           my @a = split(/\|/, $l);
           if ($a[0] eq "ERR") {
             print "<tr><td colspan=4>$a[0]: $a[1]</td>";
           } else {
             my $t = $a[8] || $a[1];
             print "<tr><td>$agent</td>
              <td><center>$t</td>
              <td>$a[9]</td>
              <td>$a[2]</td>";
           }
       }
       close(O1);
    }
 }
 print "</table>";
       
}
#
# called from the left_frame, generate the welcome to discovery page with buttons
# for each device type that can be discovered.
#
sub run {
  my($q) = @_;

  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  my(@admins, $fun);
  print Html->body();
  if (my $err = Roles->verifyRole($q, "admin")) {
     print $err;
     return;
  }
  if (-f System->get_home() . "/DATA/Solution.golden" && !$q->{ALL}) {
     GUI::Discover::discover({product => "Solution"});
     return;
  }
  my $G     = Labels->read();
  my $L     = Labels->read('GUI::Discover');
  my $L2    = Labels->read('GUI::Discover')->section('disco');
  my $header= Html->header2("admin.gen_maint.discovery");
  my $MODS  = Modules->load("GUIAdmin");

  my($input, $input2, $input3);
  my ($cnt, $cnt2, @L);
  $input    = "<select name=product>";

  foreach my $m (sort @$MODS) {
    $fun = "GUIAdmin::${m}::discover";

    if (defined(&$fun)) {
      my $f1 = "GUIAdmin::${m}" ; 
      my $i = $f1->isDevice();
      my $pk = "GUIAdmin::${m}";
      my $name2 = $pk->description("Dis_Screen");
    
      if ($name2) {
        push(@L, "$name2|$i|$m");
      }
    }
  }
  foreach my $l (sort @L) {
     my($name2, $i, $m) = split(/\|/, $l);
     $name2 .= " (background)" if (index("DeviceFromIP,SWITCH,T3,6120", $m) >= 0);
     if (lc($m) eq "subnet") {
         $input3 .= "<option value=$m>$name2</option>";
     } elsif ($i) {  
         $input2 .= "<option value=$m>$name2</option>";
     } else {
         $input .= "<option value=$m>$name2</option>";
     }
  }
  $input .= "$input2 $input3</select>";
  my $select_hosts = "<select name=select_host><option value=\"\">$G->{all_hosts}<option value=local>" . $renv->{hostname};
  $select_hosts .= $Config->slaveSelect();
  $select_hosts .= "</select>";

  my $TOT = Discover->stats();
  my $total_running;
  my $summary = "
       <table border=0><tr><td></table>
       <table border=1 cellspacing=0 width=90% bgcolor=white> 
       <tr bgcolor=$Style::DARK><td colspan=4><font color=white><b>$L2->{title}</td>
       <tr bgcolor=$Style::LIGHT><td><b>$L2->{method}
          <td align=right><b>$L2->{running}&nbsp;</td>
          <td align=right><b>$L2->{done}&nbsp;</td>
          <td align=right><b>$L2->{dev}&nbsp;</td>";
    my $c1;
  foreach my $el (keys %$TOT) {
       my $r1 = $TOT->{$el}{start} - $TOT->{$el}{stop};
       $r1 = 0 if ($r1 < 0);
       $total_running += $r1;
       my $url = "<a href=javascript:details('$el')>&nbsp;$TOT->{$el}{lines}&nbsp;</a>";
       $summary .= "<tr><td>&nbsp;$el
                 <td align=right>$r1&nbsp;</td>
                 <td align=right>$TOT->{$el}{stop}&nbsp;</td>
                 <td align=right>$url&nbsp;</td>
                  </td>";
       $c1++;
  }
  if ($c1) {
       $summary .= "</table>
       <table border=0 width=90%><tr><td align=right><b>
        <input type=submit name=ACTION_clear value=\"$L2->{clear2}\">
        <input type=submit name=ACTION_process value=\"$L2->{submit2}\">
       </td></table>";
  } else {
      $summary .= "<tr><td colspan=4>$L2->{none}</td></table>&nbsp; ";
  }

  print "\n<meta http-equiv=Refresh content=\"60;URL=$Http::WEBPROC?GO=GUI::Discover::run\">" if ($total_running);

  my $o .=<<EOF;
<body bgcolor=$Style::BGCOLOR>
<script>
function details(a) {
  var b = '$Http::WEBPROC?GO=GUI::Discover::details&type=' + a;
  var O = window.open(b,'win1','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();

}
</script>
<center>
&nbsp;
$header
<table border=0 cellspacing=0><tr><td> <form  method=get>
 <input type=hidden name=GO value=GUI::Discover::discover>
</table>
$summary
 <table border=1 width=90% cellspacing=0 bgcolor=white cellpadding=2>
  <tr bgcolor=$Style::DARK><td colspan=2>
     <b><font color=white>$L->{'disco.l1'}</td>
  <tr><td bgcolor=$Style::LIGHT align=right><b>$L->{'disco.l2'}: </td>
       <td> $select_hosts</td>

  <tr><td bgcolor=$Style::LIGHT align=right><b>Product/<br> $L->{'disco.l3'}: </td>
      <td><b>$input</td>
   </table><b>
  <input type=submit name=ACTION_d value=\"$L->{'disco.submit1'}\">
</form>
EOF
  print $o;
}

sub process_discovery {
  my($q) = @_;
  my($l);
  my $D1 = System->get_home() . "/DATA/Discover";
  my(%TOT, $c1, %F);
  opendir(O, $D1);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  foreach my $d (@$devs) {
     $F{$d->{key}} = 1;
  }
  my $all_running;
  my @F = readdir(O); closedir(O);
  foreach my $f (@F) {
     next if (substr($f,0,1) eq "." || -d "$D1/$f");
     open(O, "$D1/$f");
     my($adding, $running);
     while ($l = <O>) {
        chop($l);
        if ($l =~ /#START/) {
           $running = 1;
        } elsif ($l =~ /#END/) {
           $running = 0;
        }
        next if (substr($l,0,1) eq "#");
        if (substr($l,0,3) eq "ERR") {
          print "$l<br>";
        } else {
          my $err_text;
          my($adding0, $nodes) = Logic::SWITCH::process_line({}, $l, \%F, \$err_text, $devs, undef, "<br>");
          $adding += $adding0;
        }
     }
     close(O);
     if ($adding) {
        PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);
     }
     unlink "$D1/$f" if (!$running);
     $all_running += $running;
  }
  print "$all_running agent(s) still running!" if ($all_running);
  use GUI::Devices;
  GUI::Devices::list($q);
}

#
# Called to discover a specific type of device
#
sub discover {
  my($q, $post, $util) = @_;
  my($fun);
  print "\n";
  if ($q->{ACTION_clear}) {
      my $DIR = System->get_home() . "/DATA/Discover";
      opendir(OO, $DIR);
      my @files = readdir(OO); closedir(OO);
      foreach my $f (@files) {
         next if (substr($f,0,1) eq ".");
         unlink "$DIR/$f";
      }
      &run($q);
      return;

  } elsif ($q->{ACTION_process}) {
      &process_discovery($q);
      return;
  }
  my $MODS = Modules->load("GUIAdmin");

  if (($fun=$q->{PKG})) { # it's a callback
    if (defined(&$fun)) {
      my $rc = &$fun($q,$post,$util);
      if ($rc eq "DONE") {
        GUI::Devices::list($q);
      } elsif ($rc eq "DISCO") {
        &run($q);
      }
    }
    return;
  }

# find which button was pressed

  my $name;
  if ($q->{product}) {
     $name = $q->{product};
     $fun = "GUIAdmin::${name}::discover";

     if (defined(&$fun)) {
        my $rc = &$fun($q,$post,$util);
        if ($rc eq "DONE") {
          GUI::Devices::list($q) ;
        } elsif ($rc eq "DISCO") {
          &run($q);
        }
     }
  }
  #run($q,$post,$util);
}




sub rediscover {
  my($q) = @_;

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;

  my $head = Html->header("Save SnapShop ","","","rediscover");
  my $info =  Html->readHtdocs("rediscover");

  print "\n<body bgcolor=$Style::BGCOLOR>&nbsp;<center>$head
  <table border=0 bgcolor=white width=90% cellpadding=4><tr><td>$info</table>\n";

  print "<table border=0><tr><td></table>\n";
  print "<table border=1 cellspacing=0 width=90% bgcolor=white>
  <tr bgcolor=$Style::LIGHT>
      <td><form><input type=hidden name=GO value=GUI::Discover::rediscover>
          <b><center>Select</td>
      <td><b><center>Host</td>
      <td><b><center>Last Discover</td>
  ";
  my $F = System->get_home() . "/DATA/topo/$renv->{hostname}";
  my $c = "N/A";
  $c = Util->get_file_created($F) if (-f $F);

  print "<tr>
    <td><center><input type=checkbox name=host_$renv->{hostname}>
    <td>&nbsp;$renv->{hostname}
    <td>&nbsp;$c
     ";

  foreach my $h (@$hosts) {
    my $F = System->get_home() . "/DATA/topo/$h->{hostname}";
    my $c = "N/A";
    $c = Util->get_file_created($F) if (-f $F);
    print "<tr>
       <td><center><input type=checkbox name=host_$h->{hostname}>
       <td>&nbsp;$h->{hostname}
       <td>&nbsp;$c
         ";
  }
  print "</table>";
  print "<b><input type=submit name=ACTION value=Re-Discover></form>";
}



1;

