package Filters;

use System;
use strict;

sub new {
  my($class) = @_;

  my $v = Util->deserialize("Filters") || [];
  my @NEW;
  foreach my $el (@$v) {
     push(@NEW, $el) if ($el);
  }
  $v = \@NEW;
  bless($v, "Filters");
  return $v;
}

sub add {
  my($filters, $code, $type, $days, $pattern, $severity) = @_;

  my $last = $#$filters+1;
  $filters->[$last] = {code => $code, 
                       type => $type,
                       days => $days,
                    pattern => $pattern,
                    severity=> $severity };
  return $filters->[$last];
}



sub write {
  my($filters) = @_;
  my @new;
  foreach my $f (@$filters) {
     push(@new, $f) if ($f);
  }
  Util->serialize("Filters", \@new);
}

# return a new severity if a filter applies
# returns undef otherwize
# 9 : no event at all

sub severity {
  my($filters, $code, $type, $desc) = @_;
  my ($x);
  return undef if ($#$filters  < 0);

  my $today = Util->get_today();
  my $year  = substr($today, 0,4);
  my $month = substr($today, 5,2);
  my $day   = substr($today, 8,2);
  my $hour  = substr($today, 11,2);
  my ($jul, $dow) = Util->julian($year, $month, $day);
  $dow .= ($hour >= 5 && $hour < 17) ? "a":"p";

  for ($x=0; $x <= $#$filters; $x++) {
     my $f = $filters->[$x];
     my $p = $f->{pattern};
     next if ($f->{code} && $code  ne $f->{code});
     next if ($f->{type} && $type  ne $f->{type});
     next if ($f->{days} && index($f->{days}, $dow) < 0);
     next if ($p && $desc !~ /$p/);
     return $f->{severity};
  }
  return  undef;
}

1;
