package Debug;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Debug.pm,v 1.26 2003/04/08 21:39:32 ccadieux Exp $

use System;
use Labels;

@SYSTEM_ERRORS = ();

sub warning {
  my($debug, $line, $var1, $var2, $var3, $var4 ) = @_;

  $debug->err_war("WRN", $line, $var1, $var2, $var3, $var4);
}

# don't repeat same error for $hours

sub errNoRepeat {
  my($class, $err, $text, $hours, $text2) = @_;

require Timer;

  my $rc = Timer->isXhours("$err-$text", $hours, "_debug");
  if ($rc) {
     $class->err($err, $text, $text2 ,undef,undef, $text2);
  }
  return $rc;
}

# goes in errors.log and generate events
#
sub err {
  my($debug, $line, $var1, $var2, $var3, $var4, $extra ) = @_;

  $debug->err_war("ERR", $line, $var1, $var2, $var3, $var4, $extra);
}

# goes in info.log only, does not generate event
#
sub info {
  my($debug, $line, $var1, $var2, $var3, $var4 ) = @_;

  $debug->err_war("INFO", $line, $var1, $var2, $var3, $var4);
}

sub err_war {
  my($debug, $type, $line, $var1, $var2, $var3, $var4, $extra ) = @_;

  $ERROR_LOGFILE = System->get_home . "/log/" . 
                   ($type eq "INFO"? "info.log": "errors.log");

  my $GS = Labels->read('SYS_ERRORS');

  if (!exists $GS->{$line} ) {
    print STDERR "Unknown error Code: $line\n";
  } else {
    $o = $GS->expand($line, $var1, $var2, $var3, $var4);
    $o .= " $extra" if ($extra && index($o, $extra) < 0);
    Debug->truncate($ERROR_LOGFILE, 2);
    $dt1 = &datetime . " $type ";
    if (open(O,">>$ERROR_LOGFILE")) {
       print O "$dt1 $o\n";
       close(O);
       if ($0 =~ /rasagent/) {
          print "   ***$type: $o\n";
       } else {
          print "   ***$type: $o<br>\n";
       }

       Util->string2file($o, "last_sys_error");
    } else {
       print STDERR "  Cannot write to log file $ERROR_LOGFILE!\n";
    }
    if ($type ne "INFO" && ($0 =~ /rasagent/) ) {
       push(@SYSTEM_ERRORS, $dt1 . $o);
    }
  }
}

$LEVEL          = 0;

sub dump {
  my($class, $file, $obj, $recurse) = @_;
  my($o, $i);
  require Data::Dumper;
  return if ($LEVEL < 1);
  if (!open(O, ">" . System->get_home . "/DATA/dump/$file")) {
     Debug->err(CANNOT_WRITE => "dump/$file");
  } else {
    print O "-----------------------\nFILE: $file\n-----------------------\n";
    if ($recurse) {
      $Data::Dumper::Indent = 1;
      $o = Data::Dumper::Dumper($obj);
      print O "FILE: $file \n$o\n";
    } else {
      my($curr) = "";
      foreach $x (sort keys %$obj) {
          my($y) = index($x, ".");
          if (substr($x, 0, $y) ne $curr) {
            print O "\n" if ($curr);
            $curr = substr($x, 0, $y) ;
          }
          my($pat) = "%-35s = %s\n";
          print O sprintf($pat, $x,$obj->{$x});
      }
    }
    close(O);
  }
}

sub level {
  my($class, $level) = @_;
  $LEVEL = $level if (defined($level));
  return $LEVEL;
}

sub new {
  my($class, $env) = @_;  
  my($debug) =  {};
  $LEVEL                = $env->{debug_flag};

  bless ($debug , $class);
}

sub datetime {
  my(@date) = localtime(time); $date[4]++; $date[5] += 1900;
  sprintf("%2.2d-%2.2d-%d %2.2d:%2.2d:%2.2d",
           $date[4],$date[3],$date[5],$date[2],$date[1],$date[0]);
}

sub truncate {
  my($debug, $file, $max) = @_;
  $max = 2 if (!$max);
  $size = (stat($file))[7];
  if ($size > $max * 1000000) {
     rename $file, $file . ".2";
  }
}



# returns a string 
sub get_system_errors {
  my($debug) = @_;
  my($l, $out);

  if ($#SYSTEM_ERRORS >= 0) {
    return " " . join("\n ", @SYSTEM_ERRORS);
  } else {
    return undef;
  }
}

sub log {
  my($class, $line) = @_;
  open(O, ">>/tmp/ras.log"); print O $line . "\n"; close(O);
}

sub snapshot {
  my($class, $line) = @_;
  return if (Debug->level() <= 2);
  open(O, ">>"  . System->get_home() . "/DATA/snapshot.log"); 
  print O $line . "\n"; 
  close(O);
}

# indented in log file
sub snapshot1 {
  my($class, $line) = @_;
  return if (Debug->level() <= 2);
  open(O, ">>"  . System->get_home() . "/DATA/snapshot.log"); 
  $line =~ s/\n/\n  /g;
  print O $line . "\n"; 
  close(O);
}

# print debugging info

sub print {
  my($debug, $line, $var1, $var2, $var3, $var4) = @_;
  my($o);
  my $GS = Labels->read('SYS_ERRORS');

  if (!exists $GS->{$line}) {
    print STDERR "  Unknown error Code: $line\n";
  } else {
    $o = $line . " " . $GS->expand($line, $var1, $var2, $var3, $var4);
    print STDERR "  $o\n" if ($LEVEL);
  }
}

sub print0 {
  my($debug, $line) = @_;
  if ($0 =~ /rashttp/) {
    print "$line<br>";
  } else {
    print STDERR "  $line\n" 
  }
}

# print debugging info
sub print1 {
  my($debug, $line) = @_;
  print STDERR "  $line\n" if ($LEVEL > 0);
}

sub print2 {
  my($debug, $line) = @_;

  if ($LEVEL > 1) {
    if ($0 =~ /rashttp/) {
      print "$line<br>";
    } else {
      print STDERR "  $line\n" 
    }
  }
}
sub print3 {
  my($debug, $line) = @_;
  if ($LEVEL > 2) {
    if ($0 =~ /rashttp/) {
      print "$line<br>";
    } else {
      print STDERR "  $line\n" 
    }
  }
}

sub print4 {
  my($debug, $line) = @_;
  if ($LEVEL > 3) {
    if ($0 =~ /rashttp/) {
      print "$line<br>";
    } else {
      print STDERR "  $line\n" 
    }
  }
}

sub dot2 {
  my($debug) = @_;
  print STDERR "." if ($LEVEL > 1);
}

1;



__END__

=head1 NAME

Debug.pm - Debug static class


=head3 SYNOPSIS

 use Debug;


=head3 DESCRIPTION

This module handles data-dump, printing to the logfiles and validated 
error and warnings.


=head3 METHODS

=over 4

=item dump(<file>, <object> , <recurse_flag>);

Will dump any  data-structure (hash and array ref) to a file.
with recurse_flag=1, it will use data-dumper, otherwise , it will
assume a one level deep hash-ref.

=item level();

Sets the debugging level: 0,1,2. 2 has the most debugging.

=item truncate(<file>, <Megs>);

Will truncate a file to a maximum size.

=item warning(<ERROR_CODE>, <arg1>, <arg2>, <arg3>);

Writes to HOME/log/errors.log a valid warning.Will also print the error
to STDERR.

=item error(<ERROR_CODE>, <arg1>, <arg2>, <arg3>);

Writes to HOME/log/errors.log a valid error. Will also print the error
to STDERR.

=item get_system_errors();

returns a ARRAYREF to all generated errors and warnings. Used to
create events.

=item print(<line>, $arg, $arg2);

Will print to STDERR a valid error if LEVEL > 0;

=item print1($text)

Will print to STDERR any text if LEVEL > 0;

=item print2($text)

Will print to STDERR any text if LEVEL > 1;


=back 4

=head3 SEE ALSO




=head3 AUTHOR

 Christian Cadieux (ccadieux@central.sun)



=head3 COPYRIGHT

Copyright (c) 2000 Sun Microsystems

=cut
