package Storstat;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Config::Matrix;

use System;
use Util;

# Storstat->run("ALL | FAN | FW | MIN | PS | PC | DISK | FRU | DRIVER | SDS");

sub run {
   my($class, $option) = @_;

   my $PLATFORM = System->model();
   my $RELEASE =  System->os_version();
   $option = "VRTS|FAN|FW|MIN|PS|PC|DISK|FRU|DRIVER|SDS" if (index($option, "ALL") >= 0);
   $option = ",$option,";

  $S = {};
  # make_port_list
  $S->{VERITAS_VERSION} = $class->get_veritas_version();

  $S->{SDS_VERSION} = $class->get_solstice_version();

  my($PRESENT, $LD_ON_PORTS, $LD_OFF_PORTS, $LD_ORIG_PORTS,
     $SOCPP, $PORTNUM, $PHYS_PATH, $TEST) = $class->hbas_present();

  
  my $renv = { RELEASE         => $RELEASE,
               PLATFORM        => $PLATFORM,
               VERITAS_VERSION => $S->{VERITAS_VERSION},
               SDS_VERSION     => $S->{SDS_VERSION},
               HBA             => $PRESENT
             };

  $storage_present = $class->find_from_lux();

  $M = Config::Matrix->read($renv);

  $PATCHES = $class->readInstalledPatches();

  my($text, $perr, $text2, $verr, $vtext, $derr, $dtext);

  if ($M->{PATCH_CHECK_REQUIRED} && index($option, ",PC,") >= 0) {
    ($perr, $text) = $class->patch_check($M, $PATCHES, $storage_present);
  }

  if (index($option, "VRTS") >= 0 ) {
    if ($renv->{VERITAS_VERSION}) {
      ($verr, $vtext) = $class->check_patch("VERITAS", $M, $P);
    }
  }

  if (index($option, ",SDS,") >= 0 ) {
    #&solstice_patch_check;
  }

  if (index($option, "DRIVERS") >= 0 ) {
    ($derr,$dtext) =  $class->check_all_drivers($M, $P);
  }
  my $DI;

  if (index($option, ",FW,") >= 0 ) {
    $DI = $class->run_disk_inquiry();
    
    $class->check_t300_fw($M, $DI, $PATCHES);

    if ($PRESENT->{A5000}) {
       &check_disk_firmware($DI);
       &check_ib_firmware($DI);
    }
    &check_hba_fcode($DI);
}

  return;
}


# P : Installed patches
# M : Matrix

sub  check_t300_fw {
  my($class, $M, $DI, $P) = @_;
  my $line;
  my($err, $installed_rev);
  my $found ;
  foreach $line (@$DI) {
     $line =~ /\s+(\S+)\s+\S+\s*$/;
     $current_rev = $1;
     $line =~ /\s(c\d+t\d+d\d+)\s/;
     $device = $1;
     next if ($line !~ /T3/) ;
     $found = 1;
     $mat = $M->{T300}{T300FW}{$current_rev};
     if ($mat) {
        $req_patch = $mat->[0];
        my($req_base, $req_rev) = $class->baseRev($req_patch);
        if ($P->{patch}{$req_patch}) {
           $text .= "patch $req_patch found for rev $current_rev\n";
        } else {
           $installed_rev = $P->{base}{$req_base};
           if (!$installed_rev) {
              $text .= "patch $req_patch not installed\n"; $err = 1;
           } elsif ($installed_rev < $req_rev) {
              $text .= "installed ($req_base-$installed_rev is less than required ($req_patch)\n"; $err = 1;
           } else {
              $text .= "installed ($req_base-$installed_rev is greater than required ($req_patch)\n"; $err = 1;
           }
        }
     } else {
        $err++; 
        $text .= "T3 ($line) cannot be verified against the matrix\n";
     }
  }
  if (!$found) {
    return (0, "No T3 found using disk_inquiry");
  } 
  return ($err, $text);
}

#  REV REQ_PATCH INST_PATCH ERR TEXT





sub run_disk_inquiry {
   my($class) = @_;

  my $F = System->get_home() . "/bin/disk_inquiry";
  open(O, "$F 2>&1|");
  my @l = <O>;
  close(O);
  return \@l;
}
   

sub ckeck_all_drivers {
  my($class, $M, $P) = @_;

  my($err, $text, %S);
  open(O, "/usr/sbin/modinfo|") ;
  my(@mod) = <O>; close(O);
  my $mod = "@mod";

  foreach $port (@LD_ALL_PORTS) {
     if ($port =~ /socal/) {
        $S{socal} = 1; $S{sf} = 1;

     } elsif ($port =~ /usoc/) {
        $S{usoc} = 1; $S{fp} = 1;

     } elsif ($port =~ /qlc/) {
        $S{qlc} = 1; $S{fp} = 1;

     } elsif ($port =~ /ifp/) {
        $S{ifp} = 1;
     }
  }
  foreach my $k (keys %S) {
    if ($mod !~ / $k /) {
       $err++; 
       $text .= "  $k driver not configured\n";
    } 
  }
  return ($err, $text);

}


#############################################################

sub find_from_lux {
  my($class) = @_;
  my($a5, $t3);
  open(O, "luxadm probe|");
  while ($l = <O>) {
     if ($l =~ /SENA/) {
        $a5 = 1;
     } elsif ($l =~ /T3/) {
        $t3 = 1;
     }
  }
  close(O);
  return {A5000 => $a5, T300 => $t3};

}
  
sub baseRev {
  my($class, $patch) = @_;
  my($base, $req_rev);
  if ($patch =~ /-/) {
      ($base, $req_rev) = split (/-/, $patch);
   } else {
      $base = $patch;
      $req_rev = "";
   }
  return ($base, $req_rev);
}



#############################################################
#  PATCH CHECKING

sub readInstalledPatches {
  my($class) = @_;
  my($l,%PATCHES);
  open(O, "/bin/showrev -p 2>&1|");
  while ($l = <O>) {
     chop($l);
     my($a,$b,$c) = split(/\s+/, $l);
     if ($l =~ /\-/) {
       my($base, $rev) = split(/\-/, $l);
       $PATCHES{base}{$base} = $rev if ($rev >  $PATCHES{base}{$c});
     } else {
       $PATCHES{patch}{$c} = 1;
     }
  }
  close(O);
  return \%PATCHES;
}

sub check_patch {
  my($class, $section, $M,  $P, $highok) = @_;
  my($base, $req_rev);

  my $x = $M->{$section};
  my($err,$high, $text, $text0);
  foreach my $req_patch (keys %$x) {
     ($req_base, $req_rev) = $class->baseRev($req_patch);

     if ($P->{patch}{$req_patch}) {
         print "  $req_patch installed\n" if ($VERBOSE);
     } elsif ($req_rev) {
         my $rev = $P->{base}{$req_base};
         if ($rev == $req_rev) {
            print "  Patch $base-$rev installed\n" if ($VERBOSE);
         } elsif ($rev < $req_rev) {
            $text0 = "  $req_patch needed, only $req_base-$rev is too low \n";
            $text .= $text0; $err += 1;

            print $text0 if ($VERBOSE);
         } elsif ($rev > $req_rev) {
            $text0 = "  $req_patch needed, $req_base-$rev is too high\n";
            $err += 1 if (!$highok);
            $text .= $text0;
            print $text0 if ($VERBOSE);
         }
     } else {
         $err0 = "  $req_patch is not installed \n";
         $err .= $err0;
         print $err0 if ($VERBOSE);
     }
  }
  return ($err, $text);
}
            
sub patch_check {
  my($class, $M, $P, $ST_PRESENT) = @_;
  my($patch, $l);
  my($err0 , $text1, $text2, $text3, $err);
     
  ($err0, $text1) = $class->check_patch("PATCH-DEFAULT", $M, $P);
  $err += $err0;

  if ($ST_PRESENT->{A5000}) {
     ($err0, $text2) =  $class->check_patch("PATCH-A5000", $M, $P);
     $err += $err0;
  }
  if ($ST_PRESENT->{T300} ) {
     ($err0, $text3) = $class->check_patch("PATCH-T300", $M, $P);
     $err += $err0;
  }
  return ($err, $text1.$text2.$text3);

}

  
  


  

sub hbas_present {
   my($class) = @_;
   my($l);
   my $PRESENT = {};
   open(O, "luxadm -e port|");
   my(@luxdiag_on_ports, @luxdiag_off_ports);
   my(%LD_ORIG_PORTS, %socpp, %portnum, %phys_path, %TEST);
   my(@LD_OFF_PORTS);

   while ($l = <O>) {
        chop($l);
        next if ($cur_port !~ /CONN/);
        $cur_port = $l;
        my @cur_port_info = split(/\s+/, $cur_port);
        if ($cur_port =~ /^(.*socal.*):(\d+)(\s+.*)$/ ) {
            $cur_port = "$1/sf\@$2,0:devctl$3";
            $LD_ORIG_PORTS{"$1/sf\@$2,0:devctl"} =  $cur_port_info[0];
        } else {
            $LD_ORIG_PORTS{$cur_port_info[0]} = $cur_port_info[0];
        }
        if ($cur_port =~ /^(\S+)\s+NOT\s+CONNECTED/) {
            # allow offline ports to trigger storstat firmware checks #

            push @luxdiag_off_ports, $1;

            $PRESENT->{SOCAL} = 1 if ($cur_port =~ /^(.*socal.*)\/sf\@(\d+)/);
            $PRESENT->{USOC} = 1 if ($cur_port =~ /^(.*usoc.*)\/fp\@(\d+)/);
            $PRESENT->{QLC}  = 1 if ($cur_port =~ /^(.*qlc.*)\/fp\@(\d+)/);
            $PRESENT->{IFP}  = 1 if ($cur_port =~ /^(.*pci.*ifp\@)(\d+)/);

        } elsif ($cur_port =~ /^(\S+)\s+CONNECTED/) {
            push @luxdiag_on_ports, $1;
        }
    }
    close(O);
    @LD_OFF_PORTS = @luxdiag_off_ports;

    return ({}) if (@luxdiag_on_ports == -1);

    @temporary_ports = @luxdiag_on_ports;

    # convert luxdiag output to match disklist and path-to-inst

    foreach my $ldprt (@temporary_ports) {
        chomp $ldprt;
        if ($ldprt =~ /^(.*socal.*)\/sf\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{SOCAL} = 1;

        } elsif ($ldprt =~ /^(.*usoc.*)\/fp\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{USOC} = 1;

        } elsif ($ldprt =~ /^(.*qlc.*)\/fp\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex";
            $PRESENT->{QLC} = 1;

        } elsif ($ldprt =~ /^(.*pci.*ifp\@)(\d+)/) {
            $socpp{$ldprt} = "$1";
            #$portnum{$ldprt} = $2;
            $portnum{$ldprt} = 0;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "dex con";
            $PRESENT->{IFP}= 1;

        } elsif ($ldprt =~ /^(.*pci.*)\/scsi\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{IFP} = 1;
        } else {
            print "Error: unknown Host Adapter port $ldprt\n";
        }
    }

    return ($PRESENT, \@luxdiag_on_ports, \@luxdiag_off_ports,
            \%LD_ORIG_PORTS, \%socpp, \%portnum, \%phys_path, \%TEST);
}


  

#############################
#  VERITAS
#############################

sub  veritas_patch_check {
    my ($class, $M, $P) = @_;

   my($err, $text) = $class->check_patch("VERITAS", $M, $P);
   return ($err, $text);
}




sub get_veritas_version {
    my($class) = @_;

    # Check the different names that Veritas could be installed under #
    # The newest name is VRTSvxvm. Then extract the version number.   #
    my ($line, $status);

    my $VERITAS_VERSION;
    my $last_command = "/bin/pkginfo -l SUNWvxvm";
    my $pkginfo = `/bin/pkginfo -l SUNWvxvm 2>&1`;

    # localized packages would be SUNWvxvmr
    if ($pkginfo =~ /^ERROR/) {
        $last_command = "/bin/pkginfo -l SUNWvxvmr";
        $pkginfo = `/bin/pkginfo -l SUNWvxvmr 2>&1`;
        $last_command = "";
    }
    # VRTSvxvm will be the new name
    if ($pkginfo =~ /^ERROR/) {
        $last_command = "/bin/pkginfo -l VRTSvxvm";
        $pkginfo = `/bin/pkginfo -l VRTSvxvm 2>&1`;
        $last_command = "";
    }
    # If it were localized VRTSvxvm would become VRTSvxvmr
    if ($pkginfo =~ /^ERROR/) {
        $last_command = "/bin/pkginfo -l VRTSvxvmr";
        $pkginfo = `/bin/pkginfo -l VRTSvxvmr 2>&1`;
        $last_command = "";
    }

    my @pkginfo = split(/\n/, $pkginfo);

    foreach my $line (@pkginfo) {
        if ($line =~ /Sun Cluster Volume Manager/) {
            # Skip checks for Cluster version of Veritas #
            # bug 4302969                                #
            last;
        }
        if ($line =~ /ERROR/) {
            last;
        } elsif ($line =~ /^\s+VERSION:\s+(\S+)/) {
            $VERITAS_VERSION = $1;
            $VERITAS_VERSION = $1 if ($VERITAS_VERSION =~ /(.*),(.*)/);
        } elsif ($line =~ /^\s+STATUS:\s+(.*)/) {
            $status = $1;
            if ($status !~ /completely installed/) {
                Debug->err(STORSTAT => "4008,SUNWvxvm not completely installed");
                last;
            }
        }
    }

    return $VERITAS_VERSION;

}


sub get_solstice_version {
    my($class) = @_;

    my($S) = @_;
    my $last_command = "/bin/pkginfo SUNWmd 2>&1";
    my $SDS_VERSION = `/bin/pkginfo SUNWmd 2>&1`;
    $last_command = "";

    if ($SDS_VERSION =~ /ERROR/) {
        $SDS_VERSION = "";
    } else {
        open(O, "/bin/pkginfo -l SUNWmd 2> /dev/null|");
        my($l);
        while ($l = <O>) {
           chop($l);
           if ($l =~ /VERSION/) {
              my($a,$b, $c) = split(/\s+/, $l);
              $SDS_VERSION = $c;
              last;
           }
        }
        close(O);
    }
    return $SDS_VERSION;
}

1;






