package Client::Control;
use Client;
use strict;
use Events;

use vars qw ($PRO);

$PRO = "|sae|srs|sunmc|nsm|ssrr|netconnect";

sub getProviderSettings {
  my($q) = @_;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  print Client->http_OK();
  if ($q->{format} eq "xml") {
     print <<EOF;
<?xml version ="1.0"?>
<PROVIDER_REPORT>
EOF
    my %P;
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.([^\.]+)\./) {
          $P{$1} = 1;
       }
    }
    foreach my $pro (sort keys %P) {
       next if (!$pro);
       print "  <PROVIDER ID=\"$pro\">\n";
       foreach my $x (sort keys %$renv) {
          my @l = split(/\./, $x);
          next if ($l[2] eq "maxsize");
          if ($l[0] eq "pro" && $l[1] eq $pro) {
            print "    <VALUE ID=\"$l[2]\">$renv->{$x}</VALUE>\n";
          }
       }
       print "  </PROVIDER>\n";
    }
    print "</PROVIDER_REPORT>\n";

  } else {
    print "#<pre>\n";
    foreach my $x (sort keys %$renv) {
       my @l = split(/\./, $x);
       next if (index($PRO, $l[1]) < 0);

       if (substr($x,0,4) eq "pro.") {
          print "$x\t$renv->{$x}\n";
       }
    }
    print "#Done.\n";
  }
}

#
#  provider=srs|sunmc|netconnect|http
#  active=Y/N
#  ip=ipnumber
#  frequency=6 (hours hb)

sub setProviderSettings {
  my($q) = @_;
  my $VALID     = "|sunmc|srs|sae|";
  my $provider  = $q->{provider};
  my $active    = $q->{active};
  my $frequency = $q->{frequency};
  my $ip        = $q->{ip};

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  if (index($VALID, "|$q->{provider}|") < 0) {
     print Client->error($q->{format}, 301, "Invalid provider ($VALID)");
     return;
  }
  $renv->{"pro.$provider.active"}    = uc($active);
  $renv->{"pro.$provider.ip"}        = $ip       if ($ip);
  $renv->{"pro.$provider.frequency"} = $frequency +0 if (exists $q->{frequency});
  if ($provider eq "sae") { 
    $renv->{"pro.$provider.components"} = $q->{components} if ($q->{components});
  }

  PDM::ConfigFile->write( $renv, $devices, $hosts, $notifs);
  Events->saveEvent("PRO", $provider, $active, $ENV{REMOTE_USER});

  print Client->http_OK();
  if ($q->{format} eq "xml") {
     print <<EOF;
<?xml version ="1.0"?>
<PROVIDER_REPORT>
   <PROVIDER ID=\"$provider\">
EOF
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.$provider\.(.*)/) {
         my $id = $1;
         print "    <VALUE ID=\"$id\">$renv->{$x}</VALUE>\n";
       }
    }
    print "  </PROVIDER>\n</PROVIDER_REPORT>\n";
  } else {
    print "#<pre>\n";
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.$provider\./) {
         print "$x\t$renv->{$x}\n";
       }
    }
    print "#Done\n";
  }

}

sub providerHelp {

  print Client->http_OK();

  print <<EOF;
<pre>
GO=Client::Control::getProviderSettings

pro.srs.active = Y
pro.srs.frequency = 0
pro.srs.ip = 172.20.6.124

GO=Client::Control::setProviderSettings&provider=sae&active=Y&ip=1.1.1.1
GO=Client::Control::setProviderSettings&provider=sae&active=Y&ip=1.1.1.1&components=Y
GO=Client::Control::setProviderSettings&provider=srs&active=Y&ip=1.1.1.1
GO=Client::Control::setProviderSettings&provider=srs&active=N
EOF
}
  
1;
