package Agent::HOST;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: HOST.pm,v 1.72 2003/05/21 15:03:12 ccadieux Exp $
use Agent;
use Carp;
use TO;
use vars qw($AUTOLOAD);
use System;
use base 'Agent';
use Agent::T3;
use strict;
use Luxadm;

sub isSelectable {"Host"}
sub revision {'$Revision: 1.72 $'}



sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::HOST');
  return $self;
}


sub RUN {
  my($agent,$ras_flag) = @_;
  my($showrev, $backup, $report);
  my $renv = System->get_renv();
  my($log_err, $lines);
  $DB::single = 1;
  Timelapse->start(ref($agent));
  my $mgmtLevel = $renv->{solution} ne "N" ? "C": "D";

  if ($agent->category_selected("HOST")  &&
      Timer->isXdays('readPatch', 1)) { # runs once a day

    $report = {};
    $agent->showrev($report);
    $agent->backup($report);
    $report->{"id.mgmtLevel"} = $mgmtLevel;

    $agent->addIdentification($report);

    my $id = {  
              deviceName  => $renv->{hostname},
              active      => "Y",
              logFile     => "",
              class       => "backup",
              name        => $renv->{hostname},
              category    => Report::CAT_BACKUP,
              ip          => System->hostname(),
           };

    PDM->saveReport(Report->new($id, $report , undef));
  }

  my($err, $cache1, %ENC, @HBA, %MPX);

  $report = {};
  $agent->readPorts($report);
  $agent->readLuns($report);
  $agent->readFreeSpace($report);
  $agent->agent_patches($report);

  $err = Agent::T3->readT3IB($cache1, \%ENC, \@HBA, \%MPX, 1);
  foreach my $x (keys %MPX) {
     $report->{"mpxio.$x"} = $MPX{$x};
  }
  $report->{"id.ipno"} = System->get_ipno();
  $report->{"id.mgmtLevel"} = $mgmtLevel;

  $agent->addIdentification($report);

  my $id = {     
              deviceName  => $renv->{hostname},
              active      => "Y",
              logFile     => "",
              class       => "host",
              name        => $renv->{hostname},
              category    => Report::CAT_HOST,
              ip          => System->hostname(),
        };

  if ($renv->{solution} eq "se") {
    require Provider::SSRR;
    if (-x $Provider::SSRR::S2S) { # service processor related report
      my $ping = Util->ping("10.0.0.3") ? "OK":"CannotPing";
      $report = {'sp.ntc.status' => $ping, 'sp.ntc.ip' => '10.0.0.3' };
    }
    $report->{'id.solution_model'} = $renv->{solution_model};
    $report->{'id.sp_version'} =    System->get_se_version();
    my $sec = System->getPackageInfo("", "SUNWsecfg", "VERSION");
    $report->{'id.secfg_version'} = Util->ltrim($sec);
    $report->{'id.seuucp_login'} =  Util->uucpLogin();
  }

  PDM->saveReport(Report->new($id, $report , undef));

  Timelapse->stop(ref($agent));
}

# '3|50020f20000009b7|port.0|t3' => '0    44      0       72      44      0',

sub FCCounters {
  my($class) = @_;
  my $rep = {};
  my $renv = System->get_renv();
  my $to = TO->getCurrentTopo(undef, 0, 1);
  my $hosts = $to->hostList();
  my $host = $hosts->[0];
  my $info = $host->info();
  my $hbas = $host->portInfo();
  my($x);
  for ($x=0; $x <= $#$hbas; $x++) {
     my $hba = $hbas->[$x];
     foreach my $el (sort keys %$hba) {
         $rep->{"hba.$x.$el"} = $hba->{$el};
     }
  }
  my %X;
  my $key = $renv->{hostname};
  for ($x=0; $x <= $#$hbas; $x++) {
     my $val = $rep->{"hba.$x.Link failures"}  . "\t" .
               $rep->{"hba.$x.Signal loss"}    . "\t" .
               $rep->{"hba.$x.Sequence error"} . "\t" .
               $rep->{"hba.$x.CRC errors"}     . "\t" .
               $rep->{"hba.$x.Sync Loss"}      . "\t" .
               $rep->{"hba.$x.Invalid words"}  ;
     $X{"0|$key|port.$x|host"} = $val;
  }
  return {data => \%X, hba => {}} ;
}



#  NEW FORMAT
#  luxadm  display /dev/rdsk/c23t50020F2300004331d1s2
#  DEVICE PROPERTIES for disk: /dev/rdsk/c23t50020F2300004331d1s2
#    Vendor:               SUN     
#    Product ID:           T300            
#    Revision:             0200
#    Serial Num:           Unsupported
#    Unformatted capacity: 125320.039 MBytes
#    Write Cache:          Enabled
#    Read Cache:           Enabled
#      Minimum prefetch:   0x0
#      Maximum prefetch:   0x0
#    Device Type:          Disk device
#    Path(s):
#  
#    /dev/rdsk/c23t50020F2300004331d1s2
#    /devices/pci@b,2000/fibre-channel@2/fp@0,0/ssd@w50020f2300004331,1:c,raw
#      LUN path port WWN:          50020f2300004331
#      Host controller port WWN:   210000e08b05041c
#      Path status:                O.K.
#    /dev/rdsk/c23t50020F23000068CCd1s2
#    /devices/pci@b,2000/fibre-channel@2/fp@0,0/ssd@w50020f23000068cc,1:c,raw
#      LUN path port WWN:          50020f23000068cc
#      Host controller port WWN:   210000e08b05041c
#      Path status:                O.K.



sub readLuns {
  my($class, $report) = @_;
  my($lux) = System->find_luxadm;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};

  my $PATHS = Luxadm->luxadmDiskPaths({} );
  my %W;
  foreach my $p (@$PATHS) {
     $W{$p->[0]} = 1;  # use patch, not wwn
  }
  foreach my $w (keys %W) {
    my $rep = Luxadm->luxadmDisplay($w);
    foreach my $l (@$rep) {
         my $prod = $l->{ProductID};
         $prod =~ s/\W/_/g;
         my $lun;
         if ($prod =~ /SESS/) {
            $lun = "lun.VE";
         } else {
            $lun = "lun.$prod";
         }
         my $i = $l->{logical};
         $i = substr($i,1) if (substr($i,0,1) eq "/");
         $i =~ s/dev\/rdsk\///g;
         $i =~ s/\///g;
         foreach my $A ('A', 'B') {
            if (exists($l->{"StatusPort$A"})) {
               my $v = $l->{"StatusPort$A"};
               $v =~ s/ /_/g;
               $report->{"$lun.$i.status$A"} = $v;
            }
         }
	 my $node = $l->{"WWNPort"};
         $node = "29" . substr($node,2) if ($prod =~ /SESS/);

         $report->{"$lun.$i.wwn"} =  $node;
	 $report->{"$lun.$i.wwnid"} =  $l->{"WWNPORTID"};

     }
  }
  my $done = 1;
}

#   'ProductID' => 'T300'
#   'Revision' => 0117
#   'SerialNum' => 'Unsupported'
#   'StatusPortB' => 'O.K.'
#   'Vendor' => 'SUN'
#   'WWNNode' => '50020f2000003ee5'
#   'WWNPortB' => '50020f2300003ee5'
#   'logical' => '/dev/rdsk/c14t50020F2300003EE5d1s2'
#   'physical' => '/devices/pci@f,2000/pci@2/SUNW,qlc@4/fp@0,0/ssd@w50020f2300003ee5,1:c,raw'


sub readPorts {
  my($class, $report) = @_;

  my $lux  = System->find_luxadm;
  my $renv = System->get_renv();
  my $TO   = $renv->{'timeout.luxadm'};

  my ($err, $data) = Util->run_command("$lux -e port","port", $TO);
  foreach my $l (@$data) {
     my($path, $status) = split(/\s+/, $l, 2);
     next if ($status !~ /CONNEC/);
     $report->{"ports.$path"} = $status;
  }
}


sub readFreeSpace {
  my($class, $report) = @_;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};
  my $df = System->find_command("df");

  my ($err, $data) = Util->run_command("$df -k /var/opt/SUNWstade","cap.txt", $TO);
  foreach my $l (@$data) {
     next if ($l !~ /^\/dev/);
     my($path, $kbyts, $used, $avail, $capacity, $mount) = split(/\s+/, $l, 6);
     $report->{"freeSpace./var/opt/SUNWstade"} = $capacity;
  }
  my ($err, $data) = Util->run_command("$df -k","cap.txt", $TO);
  foreach my $l (@$data) {
     my($path, $kbyts, $used, $avail, $capacity, $mount) = split(/\s+/, $l, 6);
     next if ($path eq "Filesystem");
     $report->{"freeSpace.$path|$mount"} = $capacity;
  }
}


sub backup {
  my($agent, $report) = @_;
  my($out, $l);
  return {} if (Util->findMaster() ) ;

  open(O, System->get_home() . "/DATA/rasagent.conf");
  while ($l = <O>) {
     $out .= " " . $l;
  }
  close(O);
  $report->{"backup_config"} = $out;
}


sub agent_patches {
  my($agent, $report) = @_;
  my ($data, %R, $out);

  my $DIR = System->get_home() . "/docs";
  opendir(O, $DIR);
  my @files = readdir(O); closedir(O);
  foreach my $f (@files) {
     next if ($f !~ /ReleaseNotes.+-.+/);
     my(@a) = split(/\./, $f);
     $out .= "$a[1]|";
  }
  $report->{"id.patches.local"} = $out;
}

   
sub showrev {
  my($agent, $report) = @_;
  my($patch, $ob, $req, $inc, $pack);
  my %R ;

  my ($err, $com) = Util->run_command("/usr/bin/showrev -p", "test", 100);

  foreach my $l (@$com) {
     if ($l =~ /Patch: (.+) Obsoletes: (.*) Requires: (.*) Incompatibles: (.*) Packages: (.*)/) {
       $patch = $1;
       $ob    = $2;
       $req   = $3;
       $inc   = $4;
       $pack  = $5;
       $pack =~ s/ //g;
       $req  =~ s/ //g;
       $report->{"showrev.patch.$patch"} = "$ob|$req|$inc|$pack";
     }
  }
 
  ($err, $com) = Util->run_command("/usr/bin/pkginfo -l", "test", 100);
  my($sys, $pk, $name, $vers, $install);

  foreach my $l (@$com) {
     my(@a) = split(/:  /, $l, 2);
     $a[0] = Util->ltrim($a[0]);

     if ($a[0] eq "PKGINST") {
        $pk = $a[1];

     } elsif ($a[0] eq "NAME") {
        $name = $a[1];

     } elsif ($a[0] eq "CATEGORY") {
        $sys = $a[1];

     } elsif ($a[0] eq "VERSION") {
        $vers = $a[1];

     } elsif ($a[0] eq "INSTDATE") {
        $install = $a[1];
        $report->{"showrev.package.$pk"} = "$sys|$vers|$install|";    # $name";
     }
  }
}

sub REPORT {
  my($class, $host, $r, $arg) = @_;
  
  my $ho;
  my($renv, $devs, $hosts,$notifs, $Config) = PDM::ConfigFile->read();

  if ($renv->{hostname} eq $host) {
     $ho = $renv;
  } else {
    foreach my $h (@$hosts) {
       if ($h->{hostname} eq $host) {
          $ho = $h; last;
       }
    }
  }
  my $SLICE = Util->deserialize("slice_map");

  my $typ = "Host";
  my $line1;
  if ($r->value("id.solution_model")) {
    $typ = $r->value("id.solution_model") ."-SP";
    $line1 = "
     <tr><td bgcolor=$Style::LIGHT width=40% align=right>Sun Series: <td>&nbsp;" . 
        $r->value('id.solution_model')  . "</td>
     <tr><td bgcolor=$Style::LIGHT width=40% align=right>SUNWsecfg Version: <td>&nbsp;" . $r->value('id.secfg_version')  . 
     "<tr><td bgcolor=$Style::LIGHT width=40% align=right>SP Version: <td>&nbsp;" . $r->value('id.sp_version')  ;
  }
  my $out = "<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$typ $host";
  $out .= $line1;

  my $to = TO->readExistingTopo($arg->{host});
  if ($to) {
     my $node = $to->nodeByName("host:$arg->{host}");
     my $ip = $r ? $r->value("id.ipno") : $node->{info}{ipno};
     if ($node) {
       my $ports = $node->portInfo();
       $out .= "
        <tr><td bgcolor=$Style::LIGHT width=40% align=right>IP: <td>$ip&nbsp;</td>
        <tr><td bgcolor=$Style::LIGHT width=40% align=right>Model: <td>$node->{info}{model}</td>";
       $out .= "<tr><td colspan=2><font color=red><b>Warning:</b>
                  $node->{info}{errors}</td>"  if ($node->{info}{errors});

       $out .= "</table>
      <table border=1 cellspacing=0 width=95% bgcolor=white>
       <tr bgcolor=$Style::LIGHT>
       <th>#</th>
       <th>Reg</th>
       <th>Slot</th>
       <th>Port-WWN</th>
       ";
       my ($x);
       for ($x=0; $x <= $#$ports; $x++) {
         my $p = $ports->[$x];
         my($p1, $p2, $p3) =  split(/:/, $p->{BoardSlotPort});
         my ($wwn, $bsp);
         if ($p->{PortWWN} !~ /^0*$/) {
            $wwn = $p->{PortWWN};
         } else {
            next;
         }
         my $pp = $p->{RegisterName};$pp =~ s/\-/- /;
         my $bg = ($p->{Mode} eq "online") ? "<b><font color=blue>":"";
         $out .= "<tr><td>$x</td>
                    <td>$bg$pp</td>
                    <td>Board:$p1 Slot:$p2 Port:$p3</td>
                    <td>$bg<small>$wwn</td>
               ";
       }
       $out .= "<tr><td colspan=5>&nbsp;No HBA found!</td>" if ($#$ports < 0);
       $out .= "</table>";
     } else {
       $out .= "</table>";
     }
  } else {
    $out .= "</table>";
  }
  if ($r) {
    my($v) = $r->{_value};
    $out .= "
    <table border=0><tr><td></table>
    <table border=1 width=95% bgcolor=white cellspacing=0 cellpadding=0>
    <tr bgcolor=$Style::LIGHT><th>LunType<th>Device<th>WWN<th>Node/Status<th>ID";
    my $cnt;
    foreach my $x (sort keys %$v) {
      if (substr($x,0,4) eq "lun." && substr($x,-4) eq ".wwn") {
         my($l1, $type, $dev, $st) = split(/\./, $x);
         my $wwn = $v->{$x};
         my $cdev = $Config->deviceByWWN($wwn);
         my $name;
         my $type1  = $type;
         my $stA    = $v->{"$l1.$type.$dev.statusA"};
         my $stB    = $v->{"$l1.$type.$dev.statusB"};
         my $wwnid  = hex($v->{"$l1.$type.$dev.wwnid"});
         my $ID;
         if ($cdev) {
           $name = $cdev->{name};
           $type1 = $cdev->{userLabel} || $cdev->{type};
           $ID    = $SLICE->{"$cdev->{key}.slice.$wwnid"};
         }
         
         my $st;
	 $st  = "Prim/$stA" if($stA);
         $st .= " Alt/$stB" if ($stB);
         my $len1 =length($dev)/ 2;
         $dev = substr($dev,0,$len1) ." " . substr($dev,$len1) if ($len1 > 10);
         $wwn = substr($wwn, 0, 8) . " " . substr($wwn,8) if ($wwn);
         $out .= "<tr><td><center>$type1 $name<td><small>&nbsp;$dev<td>$wwn<td>&nbsp;$st</td><td>$ID&nbsp;</td>\n";
         $cnt++;
      }
    }
    $out .= "<tr><td colspan=4>&nbsp;No Luns found!</td>" if ($cnt == 0);
    $out .= "</table>";

    my ($k, $x);

# FREE SPACE
    my $first = 1;
    foreach my $x (sort keys %$v) {
        if (substr($x,0,10) eq "freeSpace.") {
           next if ($x =~ /\w{30}/);
           if ($first) {
              $out .= "
               <table border=0><tr><td></table>
                <table border=1 width=95% bgcolor=white cellspacing=0 cellpadding=1>
                <tr bgcolor=$Style::LIGHT><td><b>&nbsp;Filesystem<th>Mounted<th>Capacity";
              $first=0;
           }
           my ($fs,$mounted) = split(/\|/, substr($x,10));
           $fs =~ s/:/: /;
            
           $out .= "<tr><td>&nbsp;$fs<td>&nbsp;$mounted<td align=right>$v->{$x}&nbsp;</td>";
        }
    }
    $out .= "</table>";

# PORT OFFLINE 
    $first = 1;
    foreach my $x (sort keys %$v) {
        if (substr($x,0,6) eq "ports.") {
           if ($first) {
              $out .= "
               <table border=0><tr><td></table>
                <table border=1 width=95% bgcolor=white cellspacing=0 cellpadding=1>
                <tr bgcolor=$Style::LIGHT><td><b>&nbsp;Hba Status<th>Status";
              $first=0;
           }
           my $path = substr($x,6);
           $path =~ s/:devctl$//;
           my $col = "<b>" if ($v->{$x} !~ /NOT/);
           $out .= "<tr><td>&nbsp;$path<td>$col &nbsp;" . lc($v->{$x}) ."</td>";
        }
    }
    $out .= "</table>";

#  PATCHES
    my $valu = $r->{"_value"};
    my @B = split(/\|/, $valu->{"id.patches.local"});
    my $pkgname;
    if($renv->{solution} ne "N"){
       $pkgname = "SUNWstads";
    }else{
       $pkgname = "SUNWstade";
    }

    $out .= "
       <table border=0><tr><td></table>
       <table border=1 width=95% bgcolor=white cellspacing=0 cellpadding=0>
       <tr bgcolor=$Style::LIGHT><td><b>&nbsp;$pkgname Patches";
    for ($x=0; $x <= $#B; $x++) {
      $out .= "<tr><td><center>$B[$x]&nbsp;</td>\n";
    }
    if ($#B < 0) {
      $out .= "<tr><td colspan=2>&nbsp;No $pkgname Patches Installed!</td>";
    }
    $out .= "</table>";
  }

  $out .= "&nbsp;<p>&nbsp;";
  return $out;
}
    
  1;
