/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Edge
extends Selectable
implements Serializable {
    public int multi = 1;
    char severity;
    Node start;
    Node end;
    VertexApplet applet;
    String label;
    String label2;
    String label3;
    public char type;
    static int edgecnt = 0;
    int edgeno;
    int w1;
    int startPos;
    int endPos;
    Point lastP1;
    Point lastP2;

    public Edge(VertexApplet vertexApplet, String string, Node node, int n, Node node2, int n2, String string2, String string3, String string4, String string5) {
        this.applet = vertexApplet;
        this.start = node;
        this.startPos = n;
        this.label = string2;
        if (string3.length() > 0) {
            int n3 = 2;
        }
        this.label2 = string3;
        this.label3 = string4;
        this.severity = (char)32;
        if (string5.length() == 1) {
            this.severity = string5.charAt(0);
        }
        this.endPos = n2;
        this.edgeno = edgecnt++;
        this.type = string.charAt(0);
        this.end = node2;
        this.lastP1 = new Point(0, 0);
        this.lastP2 = new Point(0, 0);
        this.revalidate();
    }

    public final void calcCenter(Point point, Point point2) {
        point.x = (int)(this.applet.scale * (float)this.start.position.x + (float)(this.start.width / 2));
        point.y = (int)(this.applet.scale * (float)this.start.position.y + (float)(this.start.height / 2));
        point2.x = (int)(this.applet.scale * (float)this.end.position.x + (float)(this.end.width / 2));
        point2.y = (int)(this.applet.scale * (float)this.end.position.y + (float)(this.end.height / 2));
    }

    public final int calcEdge(Point point, Point point2) {
        Point point3 = this.start.position;
        Point point4 = this.end.position;
        Point3 point32 = this.start.portOffset(this.startPos, 0, 0, 0, null, null, null, null);
        Point3 point33 = this.end.portOffset(this.endPos, 0, 0, 0, null, null, null, null);
        if (point32.x == -1 || point33.x == -1) {
            return 0;
        }
        point.x = (int)(this.applet.scale * (float)point3.x + (float)point32.x + (float)(this.start.portSize / 2));
        point2.x = (int)(this.applet.scale * (float)point4.x + (float)point33.x + (float)(this.end.portSize / 2));
        point.y = (int)(this.applet.scale * (float)point3.y + (float)point32.y + (float)(this.start.portSize / 2));
        point2.y = (int)(this.applet.scale * (float)point4.y + (float)point33.y + (float)(this.end.portSize / 2));
        return 1;
    }

    public final void defaultLabel() {
        this.revalidate();
        Point3 point3 = this.start.portOffset(this.startPos, 0, 0, 0, null, null, null, null);
        Point3 point32 = this.end.portOffset(this.endPos, 0, 0, 0, null, null, null, null);
        int n = this.start.position.x + point3.x + this.end.position.x + point32.x >> 1;
        int n2 = this.start.position.y + point3.y + this.end.position.y + point32.y >> 1;
        this.moveLabel(n, n2);
    }

    public String info() {
        if (this.label2.length() > 0) {
            return String.valueOf(this.label) + " " + this.label2 + " " + this.label3;
        }
        String string = String.valueOf(this.start.label) + ":" + this.startPos + " <-> " + this.end.label + ":" + this.endPos;
        return String.valueOf(this.label) + " " + string;
    }

    public String inside(int n, int n2) {
        int n3;
        Point point = new Point();
        Point point2 = new Point();
        int n4 = this.calcEdge(point, point2);
        int n5 = 15;
        int n6 = 8;
        if (this.applet.zoom >= 2) {
            n5 = 10;
            n6 = 6;
        } else {
            n3 = this.label.length() * 7;
            if (n3 > n5) {
                n5 = n3;
            }
        }
        n3 = (point.x + point2.x) / 2 - n5 / 2;
        int n7 = (point.y + point2.y) / 2 - n6 / 2;
        if (n < n3 || n > n3 + n5 + 4) {
            return null;
        }
        if (n2 < n7 || n2 > n7 + n6 + 1) {
            return null;
        }
        return "E";
    }

    public final void moveRelative(double d, double d2) {
        this.moveLabelRelative((int)d, (int)d2);
    }

    public final boolean nearEnd(int n, int n2) {
        int n3 = 10 + this.size + this.end.size;
        return this.end.near(n, n2, n3);
    }

    public final boolean nearStart(int n, int n2) {
        int n3 = 10 + this.size + this.start.size;
        return this.start.near(n, n2, n3);
    }

    public final void paint(Graphics graphics) {
        this.paintLine(graphics);
    }

    public final void paintArrows(Graphics graphics) {
        this.revalidate();
        this.paintEndArrow(graphics);
    }

    public final void paintEndArrow(Graphics graphics) {
    }

    public final void paintLine(Graphics graphics) {
        this.validate();
        Point point = this.start.position;
        Point point2 = this.end.position;
        graphics.setColor(this.getColor(this.color));
        Point point3 = new Point();
        Point point4 = new Point();
        Font font = new Font("Dialog", 0, 9);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = 15;
        int n2 = 8;
        if (this.applet.zoom == 2) {
            n = 10;
            n2 = 8;
        } else if (this.applet.zoom > 2) {
            n = 10;
            n2 = 6;
        }
        if (this.type == 'S') {
            int n3 = this.calcEdge(point3, point4);
            if (n3 == 0) {
                return;
            }
            graphics.setColor(new Color(210, 210, 210));
            graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
            graphics.drawLine(point3.x + 1, point3.y, point4.x + 1, point4.y);
            graphics.drawLine(point3.x, point3.y + 1, point4.x, point4.y + 1);
            graphics.setColor(Color.black);
            graphics.drawString(this.label, (point3.x + point4.x) / 2, (point3.y + point4.y) / 2);
        } else {
            int n4;
            int n5 = this.calcEdge(point3, point4);
            if (n5 == 0) {
                return;
            }
            boolean bl = false;
            int n6 = 0;
            int n7 = (point3.x + point4.x) / 2 - n / 2;
            int n8 = (point3.y + point4.y) / 2 - n2 / 2;
            graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
            int n9 = n;
            if (this.applet.zoom >= 0 && this.applet.zoom < 3 && (n4 = fontMetrics.stringWidth(this.label) + 3) > n9) {
                n9 = n4;
            }
            if (this.type == 'E') {
                if (this.severity == '2') {
                    graphics.drawRect(n7 - 1, n8, n9 + 1, n2);
                    graphics.setColor(new Color(250, 100, 100));
                    bl = true;
                } else if (this.severity == '1') {
                    graphics.drawRect(n7 - 1, n8, n9 + 1, n2);
                    graphics.setColor(Color.yellow);
                    bl = true;
                } else if (this.severity == '0') {
                    graphics.drawRect(n7 - 1, n8, n9 + 1, n2);
                    graphics.setColor(Color.green);
                    bl = true;
                }
                n6 = 1;
            } else {
                n6 = this.applet.showLinkHandle;
            }
            if (n6 == 1) {
                graphics.fillRect(n7, n8, n9, n2);
                if (!bl) {
                    graphics.setColor(Color.white);
                    graphics.fillRect(n7 + 1, n8 + 1, n9 - 2, n2 - 2);
                } else if (this.selected) {
                    graphics.setColor(Color.blue);
                    graphics.drawLine(n7, n8 + n2, n7 + n, n8 + n2);
                }
                graphics.setColor(Color.black);
                if (this.applet.zoom >= 0 && this.applet.zoom < 3) {
                    Font font2 = graphics.getFont();
                    graphics.setFont(font);
                    graphics.drawString(this.label, n7 + 1, n8 + n2);
                    graphics.setFont(font2);
                }
            }
        }
    }

    public final void paintXOR(Graphics graphics) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        int n = this.calcEdge(point, point2);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        if (this.lastP1.x > 0) {
            graphics.drawLine(this.lastP1.x, this.lastP1.y, this.lastP2.x, this.lastP2.y);
        }
        this.lastP1.x = point.x;
        this.lastP1.y = point.y;
        this.lastP2.x = point2.x;
        this.lastP2.y = point2.y;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.start = (Node)objectInputStream.readObject();
        this.end = (Node)objectInputStream.readObject();
        this.multi = objectInputStream.readInt();
    }

    public void reset() {
        this.lastP2.y = 0;
        this.lastP2.x = 0;
        this.lastP1.y = 0;
        this.lastP1.x = 0;
    }

    public final void revalidate() {
        this.validate();
    }

    public String toC() {
        String string = "1|e|f|0|0|0|" + this.label + "|" + this.start.number + "," + this.startPos + "|" + this.end.number + "," + this.endPos;
        return string;
    }

    public String toString() {
        String string = "(Edge";
        string = String.valueOf(string) + " " + String.valueOf(this.start.hashCode());
        string = String.valueOf(string) + " " + String.valueOf(this.end.hashCode());
        string = String.valueOf(string) + " " + this.multi;
        string = String.valueOf(string) + " " + super.toString() + " ";
        return String.valueOf(string) + " )";
    }

    public final void validate() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.start);
        objectOutputStream.writeObject(this.end);
        objectOutputStream.writeInt(this.multi);
    }
}

