/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.AttrTableModel;
import com.netscape.admin.dirserv.panel.SchemaAttributesPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPSchema;

public class SchemaMatchingRulesPanel
extends SchemaAttributesPanel
implements ListSelectionListener {
    private JButton _helpButton;
    private JTable _stdTable;
    private AttrTableModel _stdTableModel;
    private static int[] _widths = new int[]{190, 155, 90, 65};
    private static int TABLE_ROWS = 18;
    private static final String _section = "matchingrules";

    public SchemaMatchingRulesPanel(IDSModel model) {
        super(model, _section, false);
        this._helpToken = "configuration-schema-mrule-help";
        String s = DSUtil._resource.getString(_section, "cis-name");
        if (s != null) {
            this.SyntaxStrings[1] = s;
        }
    }

    public void init() {
        this.getModel().setWaitCursor(true);
        EmptyBorder border = new EmptyBorder(this.getBorderInsets());
        this._myPanel.setBorder((Border)border);
        this._myPanel.setLayout(new GridBagLayout());
        this.resetGBC();
        JLabel introLabel = this.makeJLabel(_section, "intro");
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, UIFactory.getDifferentSpace(), 0);
        this._myPanel.add((Component)introLabel, this._gbc);
        JComponent scroll = this.createAttributeListArea((Container)this._myPanel);
        this.populateTables();
        this._gbc.weighty = 0.0;
        this._myPanel.add(Box.createVerticalStrut((int)UIFactory.getDifferentSpace()), this._gbc);
        JComponent buttonPanel = this.createButtonsPanel();
        this.resetGBC();
        this._gbc.fill = 2;
        this._gbc.gridwidth = 0;
        this._gbc.weightx = 1.0;
        this._gbc.insets.top = 0;
        this._myPanel.add((Component)buttonPanel, this._gbc);
        this.getModel().setWaitCursor(false);
    }

    protected JComponent createAttributeListArea(Container myContainer) {
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.anchor = 17;
        this._gbc.fill = 2;
        String[] colNames = new String[]{DSUtil._resource.getString(_section, "namecolumn-label"), DSUtil._resource.getString(_section, "oidcolumn-label"), DSUtil._resource.getString(_section, "syntaxcolumn-label"), DSUtil._resource.getString(_section, "description-label")};
        this._stdTableModel = new AttrTableModel(colNames);
        this._stdTable = new JTable((TableModel)this._stdTableModel);
        this.setColumnWidths(this._stdTable, _widths);
        Dimension d = new Dimension();
        d.height = this._stdTable.getRowHeight() * TABLE_ROWS + 8;
        d.width = 0;
        int i = 0;
        while (i < _widths.length) {
            d.width += _widths[i];
            ++i;
        }
        this._gbc.fill = 1;
        this._gbc.weighty = 0.7;
        this._gbc.weightx = 1.0;
        JScrollPane scrollPane = this.addTableInScrollPane(this._stdTable, myContainer, d);
        return scrollPane;
    }

    protected void populateTables() {
        this._stdTableModel.removeAllRows();
        LDAPSchema sch = this.getModel().getSchema();
        if (sch == null) {
            return;
        }
        LDAPSchema lDAPSchema = sch;
        synchronized (lDAPSchema) {
            Enumeration e = sch.getMatchingRules();
            while (e.hasMoreElements()) {
                LDAPMatchingRuleSchema las = (LDAPMatchingRuleSchema)e.nextElement();
                this.addAttributeRow(las);
            }
        }
        this.setColumnWidths(this._stdTable, _widths);
        this._stdTable.repaint();
    }

    private void addAttributeRow(LDAPMatchingRuleSchema las) {
        Object[] row = new Object[]{las.getName(), las.getOID(), this.SyntaxStrings != null ? this.SyntaxStrings[las.getSyntax()] : "", las.getDescription()};
        this._stdTableModel.addRow(row);
    }

    protected JComponent createButtonsPanel() {
        this._helpButton = this.makeJButton("general", "Help");
        JButton[] buttons = new JButton[]{this._helpButton};
        return UIFactory.makeJButtonPanel((JButton[])buttons);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._helpButton)) {
            this.helpCallback();
        }
    }
}

