/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.WFilterDef;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.servlet.WrapperFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WFilterChain
implements FilterChain {
    private WFilterDef filterDef;
    private WebApplication webApp;
    private WFilterChain next;

    public WFilterChain(WFilterDef wFilterDef, WebApplication webApplication) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.webApp = webApplication;
        this.filterDef = wFilterDef;
        this.next = null;
    }

    void destroy() {
        this.webApp = null;
        this.filterDef = null;
        this.next = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.getNext().doFilter(servletRequest, servletResponse, (FilterChain)this.getNextChain());
    }

    Filter getFilter() {
        return this.filterDef.getFilter();
    }

    private Filter getNext() {
        if (this.next == null) {
            return null;
        }
        return this.next.getFilter();
    }

    WFilterChain getNextChain() {
        return this.next;
    }

    public Servlet getServlet() {
        WFilterChain wFilterChain = this;
        Filter filter = null;
        while (wFilterChain != null) {
            filter = wFilterChain.getFilter();
            wFilterChain = wFilterChain.getNextChain();
        }
        Servlet servlet = null;
        if (filter instanceof WrapperFilter) {
            servlet = ((WrapperFilter)filter).getServlet();
        }
        return servlet;
    }

    void setNextChain(WFilterChain wFilterChain) {
        this.next = wFilterChain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WFilterChain[");
        stringBuffer.append("context=");
        stringBuffer.append(this.webApp.getContextPath());
        stringBuffer.append(", filterClass=");
        stringBuffer.append(this.filterDef.getFilterClass());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

