/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletOutputStream;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.util.MapEncoding;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

class NSServletResponse
implements ServletResponse {
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    protected NSServletSession _session;
    protected WServletContext _context;
    protected NSServletOutputStream _outputStream = null;
    protected PrintWriter _printwriter = null;
    protected boolean _withinInclude = false;
    private String _content_charset = "ISO-8859-1";
    private String _content_type = "text/html";
    private Locale _locale = null;
    private int _bufferSize;

    public NSServletResponse(WServletContext wServletContext, NSServletSession nSServletSession) {
        this._context = wServletContext;
        this._session = nSServletSession;
        this._bufferSize = 8192;
        if (this._context != null) {
            this._bufferSize = this._context.getResponseBufferSize();
        }
    }

    protected void clearOutputStream() {
        if (this._outputStream != null) {
            if (this._printwriter != null) {
                this._outputStream.setWriteIgnore(true);
                this._printwriter.flush();
                this._outputStream.setWriteIgnore(false);
            }
            this._outputStream.clear();
        }
    }

    protected void closeOutputStream() {
        try {
            if (this._printwriter != null) {
                this._printwriter.close();
            }
            if (this._outputStream != null) {
                this._outputStream.close();
            }
            this._session.startResponse();
        }
        catch (IOException iOException) {}
    }

    public void flushBuffer() throws IOException {
        boolean bl = true;
        this.flushOutputStream(true);
    }

    protected void flushOutputStream(boolean bl) {
        try {
            if (this._outputStream != null) {
                this._outputStream.setNativeStreamFlushMode(false);
                if (this._printwriter != null) {
                    this._printwriter.flush();
                }
                this._outputStream.flush();
                this._outputStream.setNativeStreamFlushMode(true);
            }
            if (bl) {
                this._session.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getCharacterEncoding() {
        return this._content_charset;
    }

    protected boolean getIncludeFlag() {
        return this._withinInclude;
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this._locale = Locale.getDefault();
        }
        return this._locale;
    }

    public ServletOutputStream getOutputStream() throws IOException, IllegalStateException {
        if (this._outputStream == null) {
            int n = this._context.getResponseFlushTimeout();
            this._outputStream = new NSServletOutputStream(this._session, this._bufferSize, n);
        }
        this._outputStream.enableStream();
        return this._outputStream;
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException, UnsupportedEncodingException {
        if (this._printwriter == null) {
            if (this._outputStream == null) {
                int n = this._context.getResponseFlushTimeout();
                this._outputStream = new NSServletOutputStream(this._session, this._bufferSize, n);
            }
            try {
                Writer writer = this._outputStream.getWriter(this._content_charset);
                this._printwriter = new PrintWriter(writer, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedEncodingException();
            }
        }
        return this._printwriter;
    }

    public boolean isCommitted() {
        return this._session.ostream_wasFlushed();
    }

    protected void markOutputStreamClosed() {
        if (this._outputStream != null) {
            this._outputStream.setWriteIgnore(true);
        }
    }

    public void reset() throws IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.clearOutputStream();
    }

    public void setBufferSize(int n) throws IllegalStateException {
        if (this.isCommitted() || this._session.responseStarted()) {
            throw new IllegalStateException();
        }
        this._bufferSize = n <= 0 ? 0 : (n > 65536 ? 65536 : n);
        try {
            if (this._outputStream != null) {
                this._outputStream.resize(this._bufferSize);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private void setCharset(String string) {
        if (this._content_type != null && string != null) {
            this.setContentType(String.valueOf(this._content_type) + ";charset=" + string);
        }
    }

    public void setContentLength(int n) {
        if (!this._withinInclude) {
            this._session.setContentLength(n);
        }
    }

    public void setContentType(String string) {
        if (string != null && !this._withinInclude) {
            int n = string.indexOf(59);
            this._content_type = string;
            if (!this._session.isSSI()) {
                this._session.setHeader("Content-type", string);
            }
            if (n > 0) {
                this._content_type = string.substring(0, n).trim();
                int n2 = string.indexOf("charset=", n);
                if (n2 > 0) {
                    this._content_charset = string.substring(n2 + 8).trim();
                }
            }
        }
    }

    protected void setIncludeFlag(boolean bl) {
        this._withinInclude = bl;
    }

    public void setLocale(Locale locale) {
        if (locale != null && !this._withinInclude) {
            CharSequence charSequence;
            this._locale = locale;
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            String string3 = locale.getVariant();
            if (string != null && string.length() > 0) {
                charSequence = new StringBuffer(string);
                if (string2 != null && string2.length() > 0) {
                    ((StringBuffer)charSequence).append('-');
                    ((StringBuffer)charSequence).append(string2);
                    if (string3 != null && string3.length() > 0) {
                        ((StringBuffer)charSequence).append('-');
                        ((StringBuffer)charSequence).append(string3);
                    }
                }
                this._session.setHeader("content-language", ((StringBuffer)charSequence).toString());
            }
            charSequence = MapEncoding.getMimeCharset((Locale)locale);
            this.setCharset((String)charSequence);
        }
    }
}

