/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletOutputStream;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class NSServletOutputStreamWriter
extends Writer {
    private char[] _buffer;
    private int _bufferSize;
    private int _nChars = 0;
    private NSServletOutputStream _os = null;
    private OutputStreamWriter _writer = null;
    private boolean _isOpen;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    NSServletOutputStreamWriter(NSServletOutputStream nSServletOutputStream, String string) throws UnsupportedEncodingException {
        int n = nSServletOutputStream.getBufferSize();
        if (n > 0) {
            this._buffer = new char[n];
            this._bufferSize = n;
        } else {
            this._buffer = null;
            this._bufferSize = 0;
        }
        this._os = nSServletOutputStream;
        this._writer = new OutputStreamWriter((OutputStream)((Object)nSServletOutputStream), string);
        this._isOpen = true;
        this._os.enableWriter();
    }

    private void checkOpen() throws IOException {
        if (!this._isOpen) {
            throw new IOException(_res.getProp("servlet.NSServletOutputStream.msg_outputStreamWriterClosed"));
        }
    }

    protected void clear() throws IOException {
        this._os.setInWriterMethod(true);
        this._os.setWriteIgnore(true);
        this.flush();
        this._os.setWriteIgnore(false);
        this._os.setInWriterMethod(false);
    }

    public void close() throws IOException {
        if (this._os != null && this._isOpen) {
            this._os.setNativeStreamFlushMode(false);
            this.flush();
            this._os.setInWriterMethod(true);
            this._writer.close();
            this._os.setInWriterMethod(false);
            this._isOpen = false;
            this._buffer = null;
            this._bufferSize = 0;
            this._writer = null;
            this._os = null;
        }
    }

    public void flush() throws IOException {
        this.checkOpen();
        this._os.setInWriterMethod(true);
        if (this._nChars != 0) {
            this.writeBuffer();
        }
        this._writer.flush();
        this._os.setInWriterMethod(false);
    }

    protected void resize(int n) throws IOException {
        if (n == this._bufferSize) {
            return;
        }
        this._os.setInWriterMethod(true);
        this.writeBuffer();
        this._buffer = null;
        this._bufferSize = 0;
        if (n > 0) {
            this._buffer = new char[n];
            this._bufferSize = n;
        }
        this._os.setInWriterMethod(false);
    }

    public final void write(int n) throws IOException {
        this.checkOpen();
        this._os.setInWriterMethod(true);
        if (this._bufferSize > 0) {
            this._buffer[this._nChars++] = (char)n;
            if (this._nChars == this._bufferSize) {
                this.writeBuffer();
            }
        } else {
            this._writer.write(n);
        }
        if (this._os.hasFlushTimeoutExpired()) {
            this.flush();
        }
        this._os.setInWriterMethod(false);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.checkOpen();
        this._os.setInWriterMethod(true);
        if (this._bufferSize > 0) {
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this._bufferSize - this._nChars;
                int n6 = n4 - n3;
                int n7 = Math.min(n5, n6);
                string.getChars(n3, n3 + n7, this._buffer, this._nChars);
                n3 += n7;
                this._nChars += n7;
                if (this._nChars != this._bufferSize) continue;
                this.writeBuffer();
            }
            if (this._nChars == this._bufferSize) {
                this.writeBuffer();
            }
        } else {
            this._writer.write(string, n, n2);
        }
        if (this._os.hasFlushTimeoutExpired()) {
            this.flush();
        }
        this._os.setInWriterMethod(false);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.checkOpen();
        if (n < 0 || n >= cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this._os.setInWriterMethod(true);
        if (this._bufferSize > 0) {
            if (n2 >= this._bufferSize) {
                this.writeBuffer();
                this._writer.write(cArray, n, n2);
            } else {
                int n3 = n;
                int n4 = n + n2;
                while (n3 < n4) {
                    int n5 = this._bufferSize - this._nChars;
                    int n6 = n4 - n3;
                    int n7 = Math.min(n5, n6);
                    System.arraycopy(cArray, n3, this._buffer, this._nChars, n7);
                    n3 += n7;
                    this._nChars += n7;
                    if (this._nChars != this._bufferSize) continue;
                    this.writeBuffer();
                }
                if (this._nChars == this._bufferSize) {
                    this.writeBuffer();
                }
            }
        } else {
            this._writer.write(cArray, n, n2);
        }
        if (this._os.hasFlushTimeoutExpired()) {
            this.flush();
        }
        this._os.setInWriterMethod(false);
    }

    private void writeBuffer() throws IOException {
        if (this._nChars != 0) {
            this._writer.write(this._buffer, 0, this._nChars);
            this._nChars = 0;
        }
    }
}

