/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import javax.servlet.ServletInputStream;

public class NSServletInputStream
extends ServletInputStream {
    private NSServletSession _session;
    private int _maxBytes = -1;
    private int _count = 0;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public NSServletInputStream(NSServletSession nSServletSession) {
        this._session = nSServletSession;
    }

    public NSServletInputStream(NSServletSession nSServletSession, int n) {
        this._session = nSServletSession;
        this._maxBytes = n;
    }

    public int available() throws IOException {
        if (this._maxBytes != -1 && this._count == this._maxBytes) {
            throw new IOException(_res.getProp("servlet.NSServletInputStream.msg_eofError"));
        }
        int n = this._session.available(this._maxBytes != -1 ? this._maxBytes - this._count : -1);
        if (n == -1) {
            throw new IOException(_res.getProp("servlet.NSServletInputStream.msg_eofError"));
        }
        return n;
    }

    public void close() {
        this._session.skip(this._maxBytes - this._count);
    }

    public int read() throws IOException {
        if (this._maxBytes != -1 && this._count == this._maxBytes) {
            return -1;
        }
        int n = this._session.readByte();
        if (n != -1) {
            ++this._count;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + n2 >= this._maxBytes) {
                n2 = this._maxBytes - this._count;
            }
        }
        if ((n3 = this._session.read(byArray, n, n2)) > 0) {
            this._count += n3;
        }
        return n3;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + n2 >= this._maxBytes) {
                n2 = this._maxBytes - this._count;
            }
        }
        if ((n3 = this._session.readLine(byArray, n, n2)) > 0) {
            this._count += n3;
        }
        return n3;
    }
}

