/*
 * Decompiled with CFR 0.152.
 */
package crysec.ASN1;

import crysec.ASN1.ASN1Header;
import crysec.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class ASN1Utils {
    public static final int[] rsaID = new int[]{1, 2, 840, 113549};
    public static final int[] pkcsID = new int[]{1, 2, 840, 113549, 1};
    public static final int[] attrTypeID = new int[]{2, 5, 4};
    public static final int[] oiwAlgID = new int[]{1, 3, 14, 3, 2};

    public static void outputBase128(int n, OutputStream os) throws IOException {
        int i = 28;
        while (i >= 0) {
            int b = n >> i & 0x7F;
            if (b != 0) {
                if (i != 0) {
                    b |= 0x80;
                }
                os.write(b);
                boolean bl = true;
            }
            i -= 7;
        }
    }

    public static int inputBase128(InputStream is) throws IOException {
        byte b;
        int n = 0;
        do {
            b = Utils.inputByte(is);
            n <<= 7;
            n |= b & 0x7F;
        } while ((b & 0x80) != 0);
        return n;
    }

    public static int lengthBase128(int n) {
        if (n >= 0x10000000) {
            return 5;
        }
        if (n >= 0x200000) {
            return 4;
        }
        if (n >= 16384) {
            return 3;
        }
        if (n >= 128) {
            return 2;
        }
        return 1;
    }

    public static int lengthBase256(int n) {
        if (n >= 0x1000000) {
            return 4;
        }
        if (n >= 65536) {
            return 3;
        }
        if (n >= 256) {
            return 2;
        }
        return 1;
    }

    public static String inputASN1String(ASN1Header h, InputStream is) throws IOException {
        if (h.method == 0) {
            return new String(h.readBody(is));
        }
        StringBuffer s = new StringBuffer();
        ByteArrayInputStream is2 = new ByteArrayInputStream(h.readBody(is));
        while (is2.available() > 0) {
            ASN1Header h2 = new ASN1Header();
            h2.input(is2);
            if (h2.tag != h.tag || h2.method != 0) continue;
            s.append(new String(h2.readBody(is2)));
        }
        return s.toString();
    }

    public static BigInteger inputASN1Integer(ASN1Header h, InputStream is) throws IOException {
        byte[] buf = new byte[h.bodyLength];
        Utils.inputByteArray(buf, is);
        return new BigInteger(buf);
    }

    public static void outputASN1Integer(int val, OutputStream os) throws IOException {
        ASN1Utils.outputASN1Integer(BigInteger.valueOf(val), os);
    }

    public static void outputASN1Integer(BigInteger val, OutputStream os) throws IOException {
        byte[] buf = val.toByteArray();
        os.write(buf);
    }

    public static int lengthASN1Integer(BigInteger val) {
        return val.bitLength() / 8 + 1;
    }

    public static byte[] inputASN1OctetString(ASN1Header h, InputStream is) throws IOException {
        if (h.method == 0) {
            return h.readBody(is);
        }
        byte[] buf = new byte[]{};
        ByteArrayInputStream is2 = new ByteArrayInputStream(h.readBody(is));
        while (is2.available() > 0) {
            ASN1Header h2 = new ASN1Header();
            h2.input(is2);
            if (h2.tag != h.tag || h2.method != 0) continue;
            byte[] buf2 = h2.readBody(is2);
            byte[] newbuf = new byte[buf.length + buf2.length];
            System.arraycopy(buf, 0, newbuf, 0, buf.length);
            System.arraycopy(buf2, 0, newbuf, buf.length, buf2.length);
            buf = buf2;
        }
        return buf;
    }

    public static byte[] inputASN1BitString(ASN1Header h, InputStream is) throws IOException {
        if (h.method == 0) {
            byte[] buf = h.readBody(is);
            byte[] buf2 = new byte[buf.length - 1];
            System.arraycopy(buf, 1, buf2, 0, buf2.length);
            return buf2;
        }
        byte[] buf = new byte[]{};
        ByteArrayInputStream is2 = new ByteArrayInputStream(h.readBody(is));
        while (is2.available() > 0) {
            ASN1Header h2 = new ASN1Header();
            h2.input(is2);
            if (h2.tag != h.tag || h2.method != 0) continue;
            byte[] buf2 = h2.readBody(is2);
            byte[] newbuf = new byte[buf.length + buf2.length - 1];
            System.arraycopy(buf, 1, newbuf, 0, buf.length - 1);
            System.arraycopy(buf2, 0, newbuf, buf.length - 1, buf2.length);
            buf = buf2;
        }
        return buf;
    }

    public static ASN1Header nullHeader() {
        return new ASN1Header(5, 0, 0, 0);
    }

    public static ASN1Header integerHeader(BigInteger n) {
        return new ASN1Header(2, 0, 0, ASN1Utils.lengthASN1Integer(n));
    }

    public static ASN1Header integerHeader(int n) {
        return new ASN1Header(2, 0, 0, ASN1Utils.lengthASN1Integer(BigInteger.valueOf(n)));
    }

    public static ASN1Header objectIDHeader(int[] id) {
        return new ASN1Header(6, 0, 0, ASN1Utils.lengthASN1ObjectID(id));
    }

    public static ASN1Header IA5StringHeader(String s) {
        return new ASN1Header(22, 0, 0, s.length());
    }

    public static ASN1Header octetStringHeader(byte[] b) {
        return new ASN1Header(4, 0, 0, b.length);
    }

    public static ASN1Header structHeader(int len) {
        return new ASN1Header(16, 0, 1, len);
    }

    public static ASN1Header setHeader(int len) {
        return new ASN1Header(17, 0, 1, len);
    }

    public static int[] inputASN1ObjectID(ASN1Header h, InputStream is) throws IOException {
        ByteArrayInputStream is2 = new ByteArrayInputStream(h.readBody(is));
        Vector<Integer> id = new Vector<Integer>();
        byte b = Utils.inputByte(is2);
        id.addElement(new Integer(b / 40));
        id.addElement(new Integer(b % 40));
        while (is2.available() > 0) {
            int n = ASN1Utils.inputBase128(is2);
            id.addElement(new Integer(n));
        }
        int[] idbuf = new int[id.size()];
        int i = 0;
        while (i < idbuf.length) {
            idbuf[i] = (Integer)id.elementAt(i);
            ++i;
        }
        return idbuf;
    }

    public static void outputASN1ObjectID(int[] id, OutputStream os) throws IOException {
        os.write(40 * id[0] + id[1]);
        int i = 2;
        while (i < id.length) {
            ASN1Utils.outputBase128(id[i], os);
            ++i;
        }
    }

    public static int lengthASN1ObjectID(int[] id) {
        int len = 1;
        int i = 2;
        while (i < id.length) {
            len += ASN1Utils.lengthBase128(id[i]);
            ++i;
        }
        return len;
    }

    public static Date inputASN1Date(ASN1Header h, InputStream is) throws IOException {
        String s = ASN1Utils.inputASN1String(h, is);
        int year = 1900 + ASN1Utils.parseDateInt(s, 0);
        if (year < 1970) {
            year += 100;
        }
        int month = ASN1Utils.parseDateInt(s, 2);
        int day = ASN1Utils.parseDateInt(s, 4);
        int hour = ASN1Utils.parseDateInt(s, 6);
        int minute = ASN1Utils.parseDateInt(s, 8);
        int second = 0;
        int tzInd = 10;
        if (s.charAt(10) >= '0' && s.charAt(10) <= '9') {
            second = ASN1Utils.parseDateInt(s, 10);
            tzInd = 12;
        }
        int tzOffset = 0;
        if (s.charAt(tzInd) != 'Z') {
            int hrOff = ASN1Utils.parseDateInt(s, tzInd + 1);
            int minOff = ASN1Utils.parseDateInt(s, tzInd + 3);
            tzOffset = (hrOff * 60 + minOff) * 60 * 1000;
            if (s.charAt(tzInd) == '-') {
                tzOffset = -tzOffset;
            }
        }
        TimeZone tz = (TimeZone)TimeZone.getDefault().clone();
        tz.setRawOffset(tzOffset);
        Calendar c = Calendar.getInstance(tz);
        c.set(year, month - 1, day, hour, minute, second);
        return c.getTime();
    }

    static int parseDateInt(String s, int offset) {
        return 10 * (s.charAt(offset) - 48) + (s.charAt(offset + 1) - 48);
    }

    public static boolean isPrefix(int[] a, int[] b) {
        if (a.length > b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

