/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiTable;
import com.netscape.management.nmclf.SuiTreeCellRenderer;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTree;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.border.MatteBorder;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeNode;
import crysec.SSL.SSLCertificate;
import crysec.Utils;
import crysec.X500Name;
import crysec.X509;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

class ViewCertificateDialog
extends AbstractDialog
implements SuiConstants {
    private JTabbedPane infoPane = new JTabbedPane();
    private ResourceSet _resource;
    private JSplitPane certInfoView;

    public ViewCertificateDialog(Frame parent, SSLCertificate cert, int certChain_errCode, int serverCert_errCode, ResourceSet resource) {
        super(parent, "", true, 1);
        ((Dialog)((Object)this)).setTitle(resource.getString("ViewCertificateDialog", "title"));
        this.getContentPane().add((Component)this.infoPane);
        this._resource = resource;
        this.setCertificate(cert, certChain_errCode, serverCert_errCode);
        ((Component)((Object)this)).setSize(400, 400);
        if (parent == null) {
            ModalDialogUtil.setCenteredDialog((Component)((Object)this));
        }
    }

    protected void okInvoked() {
        ((Component)((Object)this)).setVisible(false);
    }

    protected void helpInvoked() {
        Help help = new Help(this._resource);
        help.help("ViewCertificateDialog", "help");
    }

    protected void setCertificate(SSLCertificate cert, int certChain_errCode, int serverCert_errCode) {
        this.infoPane.removeAll();
        this.infoPane.add(this._resource.getString("ViewCertificateDialog", "generalPaneTitle"), (Component)this.setupGeneralInfoPane((X509)cert.certificateList.elementAt(0), certChain_errCode, serverCert_errCode));
        this.infoPane.add(this._resource.getString("ViewCertificateDialog", "detailPaneTitle"), (Component)this.getDetailPane((X509)cert.certificateList.elementAt(0)));
        this.infoPane.add(this._resource.getString("ViewCertificateDialog", "certChainTitle"), (Component)this.setupCertView(cert.certificateList));
        this.infoPane.setSelectedIndex(0);
    }

    private JPanel getDetailPane(X509 cert) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder((Border)new MatteBorder(9, 9, 9, 9, p.getBackground()));
        GridBagUtil.constrain((Container)p, (Component)this.setupDetailInfoPane(cert), (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)11, (int)1, (int)0, (int)0, (int)0, (int)0);
        return p;
    }

    private JScrollPane getCertChainView(Vector certs) {
        DefaultMutableTreeNode top;
        RemoteImage chainIcon = new RemoteImage(this._resource.getString("ViewCertificateDialog", "chainImage"));
        DefaultMutableTreeNode parent = top = new DefaultMutableTreeNode((Object)new CertNode((X509)certs.elementAt(certs.size() - 1)));
        int i = certs.size() - 2;
        while (i >= 0) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode((Object)new CertNode((X509)certs.elementAt(i)));
            parent.add((MutableTreeNode)child);
            parent = child;
            --i;
        }
        1 certChain = new 1(top);
        certChain.setCellRenderer((TreeCellRenderer)new CertTreeCellRenderer());
        int i2 = 0;
        while (i2 <= certs.size()) {
            certChain.expandRow(i2);
            ++i2;
        }
        certChain.setSelectionRow(certs.size() - 1);
        certChain.scrollRowToVisible(certs.size() - 1);
        certChain.addTreeSelectionListener(new 2());
        JPanel p = new JPanel((LayoutManager)new BorderLayout());
        p.setBorder((Border)new EmptyBorder(2, 2, 0, 0));
        p.setBackground(UIManager.getColor((Object)"window"));
        p.add((Component)((Object)certChain));
        JScrollPane _treePanel = new JScrollPane();
        _treePanel.getViewport().add((Component)p);
        _treePanel.setPreferredSize(new Dimension(125, 75));
        _treePanel.setMinimumSize(new Dimension(1, 1));
        _treePanel.setBorder((Border)new LineBorder(Color.gray, 1));
        _treePanel.setBorder((Border)new BevelBorder(1, Color.white, _treePanel.getBackground(), Color.black, Color.black));
        return _treePanel;
    }

    private JSplitPane setupCertView(Vector certs) {
        this.certInfoView = new JSplitPane(0, (Component)this.getCertChainView(certs), (Component)this.setupDetailInfoPane((X509)certs.elementAt(0)));
        this.certInfoView.setBorder((Border)new MatteBorder(9, 9, 9, 9, this.certInfoView.getBackground()));
        return this.certInfoView;
    }

    private JScrollPane setupDetailInfoPane(X509 cert) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.addElement(this._resource.getString("ViewCertificateDialog", "fieldTitle"));
        columnNames.addElement(this._resource.getString("ViewCertificateDialog", "valueTitle"));
        Vector rowData = new Vector();
        X500Name holder = (X500Name)cert.getHolder();
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "subject"), holder.getName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "issuer"), cert.getIssuer().getName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "validFrom"), cert.getNotBeforeDate().toString());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "validTo"), cert.getNotAfterDate().toString());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "email"), holder.getEmail());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "locality"), holder.getLocalityName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "org"), holder.getOrgUnitName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "orgUnit"), holder.getOrganizationName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "state"), holder.getStateName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "country"), holder.getCountryName());
        this.setRowValue(rowData, this._resource.getString("ViewCertificateDialog", "fingerprint"), this.formatHexString(Utils.toHexString(cert.getFingerprint())));
        3 _table = new 3(rowData, columnNames);
        _table.setColumnSelectionAllowed(false);
        _table.setRowSelectionAllowed(false);
        JScrollPane scrollpane = new JScrollPane();
        JTableHeader tableHeader = _table.getTableHeader();
        JViewport headerViewport = new JViewport();
        headerViewport.setLayout((LayoutManager)new BoxLayout((Container)headerViewport, 0));
        headerViewport.add((Component)tableHeader);
        scrollpane.setColumnHeader(headerViewport);
        ((Component)((Object)_table)).setBackground(scrollpane.getBackground());
        scrollpane.setPreferredSize(new Dimension(100, 200));
        scrollpane.setMinimumSize(new Dimension(1, 1));
        JViewport mainViewPort = scrollpane.getViewport();
        mainViewPort.add((Component)((Object)_table));
        tableHeader.setUpdateTableInRealTime(false);
        return scrollpane;
    }

    private JPanel setupGeneralInfoPane(X509 serverCert, int certChain_errCode, int serverCert_errCode) {
        JPanel generalInfo = new JPanel();
        generalInfo.setLayout(new GridBagLayout());
        generalInfo.setBorder((Border)new CompoundBorder((Border)new MatteBorder(9, 9, 9, 9, generalInfo.getBackground()), (Border)new BevelBorder(1, Color.white, generalInfo.getBackground(), Color.black, Color.black)));
        RemoteImage errorIcon = new RemoteImage(this._resource.getString("ViewCertificateDialog", "errorImage"));
        int y = 0;
        GridBagUtil.constrain((Container)generalInfo, (Component)this.getBoldString(this._resource.getString("ViewCertificateDialog", "generalInfo")), (int)0, (int)y, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)0, (int)9, (int)9, (int)0, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)this.getBoldString(this._resource.getString("ViewCertificateDialog", "issuedTo")), (int)0, (int)(++y), (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)0, (int)9, (int)9, (int)9, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)new JLabel(serverCert.getHolder().getName(), 2), (int)1, (int)y, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)9, (int)6, (int)9, (int)9);
        GridBagUtil.constrain((Container)generalInfo, (Component)this.getBoldString(this._resource.getString("ViewCertificateDialog", "issuedBy")), (int)0, (int)(++y), (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)0, (int)0, (int)9, (int)9, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)new JLabel(serverCert.getIssuer().getName()), (int)1, (int)y, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)6, (int)9, (int)9);
        GregorianCalendar f = new GregorianCalendar();
        f.setTime(serverCert.getNotBeforeDate());
        GregorianCalendar t = new GregorianCalendar();
        t.setTime(serverCert.getNotAfterDate());
        String i18nDate = this._resource.getString("ViewCertificateDialog", "i18nDate");
        String from = this.replace(this.replace(this.replace(i18nDate, "%Y%", Integer.toString(f.get(1))), "%M%", Integer.toString(f.get(2) + 1)), "%D%", Integer.toString(f.get(5)));
        String to = this.replace(this.replace(this.replace(i18nDate, "%Y%", Integer.toString(t.get(1))), "%M%", Integer.toString(t.get(2) + 1)), "%D%", Integer.toString(t.get(5)));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBackground(generalInfo.getBackground());
        int x = -1;
        StringTokenizer st = new StringTokenizer(this._resource.getString("ViewCertificateDialog", "i18nValidFromTo"), " ", false);
        while (st.hasMoreTokens()) {
            String token = (String)st.nextElement();
            JLabel c = null;
            c = token.equals("FROM") ? new JLabel(from) : (token.equals("TO") ? new JLabel(to) : this.getBoldString(this._resource.getString("ViewCertificateDialog", token)));
            int space = 0;
            if (token.equals("FROM") || token.equals("TO")) {
                space = 6;
            }
            GridBagUtil.constrain((Container)p, (Component)c, (int)(++x), (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)0, (int)space, (int)0, (int)space);
        }
        GridBagUtil.constrain((Container)p, (Component)Box.createHorizontalGlue(), (int)(++x), (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)p, (int)0, (int)(++y), (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)9, (int)9, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)((Object)new BorderLabel("", (Border)new LineBorder(Color.black, 1))), (int)0, (int)(++y), (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)9, (int)0, (int)9);
        GridBagUtil.constrain((Container)generalInfo, (Component)this.getMultilineLabelBoldString(this._resource.getString("ViewCertificateDialog", "errorLabel")), (int)0, (int)(++y), (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)9, (int)9, (int)0, (int)0);
        GridBagUtil.constrain((Container)generalInfo, (Component)new JLabel(this._resource.getString("ViewCertificateDialog", "invalidBecause")), (int)0, (int)(++y), (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)9, (int)9, (int)0, (int)0);
        if ((serverCert_errCode & 8) == 8) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "unknowCert"), ++y, (ImageIcon)errorIcon);
        }
        if ((serverCert_errCode & 1) == 1) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "invalidCommonName"), ++y, (ImageIcon)errorIcon);
        }
        if ((serverCert_errCode & 2) == 2) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "expired"), ++y, (ImageIcon)errorIcon);
        }
        if ((serverCert_errCode & 4) == 4) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "invalidSignature"), ++y, (ImageIcon)errorIcon);
        }
        if ((certChain_errCode & 4) == 4) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "CAinvalidSignature"), ++y, (ImageIcon)errorIcon);
        }
        if ((certChain_errCode & 4) == 4) {
            this.addErrors(generalInfo, this._resource.getString("ViewCertificateDialog", "CAexpired"), ++y, (ImageIcon)errorIcon);
        }
        GridBagUtil.constrain((Container)generalInfo, (Component)Box.createVerticalGlue(), (int)0, (int)(++y), (int)2, (int)1, (double)1.0, (double)1.0, (int)11, (int)1, (int)9, (int)0, (int)0, (int)0);
        return generalInfo;
    }

    private void addErrors(JPanel p, String errorMessage, int y, ImageIcon errorIcon) {
        GridBagUtil.constrain((Container)p, (Component)this.multiLineIconLabel(errorIcon, errorMessage, p.getBackground()), (int)0, (int)y, (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)9, (int)9, (int)0, (int)0);
    }

    private String replace(String oldStr, String val, String replacement) {
        int index;
        String output = new String(oldStr);
        while ((index = output.indexOf(val)) != -1) {
            output = String.valueOf(output.substring(0, index)) + replacement + output.substring(index + val.length());
        }
        return output;
    }

    private JLabel getBoldString(String label) {
        JLabel l = new JLabel(label, 2);
        Font oldFont = l.getFont();
        Font newFont = new Font(oldFont.getName(), oldFont.getStyle() + 1, oldFont.getSize());
        l.setFont(newFont);
        return l;
    }

    private MultilineLabel getMultilineLabelBoldString(String label) {
        MultilineLabel ml = new MultilineLabel(label);
        Font oldFont = ml.getFont();
        Font newFont = new Font(oldFont.getName(), oldFont.getStyle() + 1, oldFont.getSize());
        ml.setFont(newFont);
        return ml;
    }

    private JPanel multiLineIconLabel(ImageIcon icon, String label, Color background) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBackground(background);
        GridBagUtil.constrain((Container)p, (Component)new JLabel((Icon)icon), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)11, (int)0, (int)0, (int)0, (int)0, (int)6);
        GridBagUtil.constrain((Container)p, (Component)new MultilineLabel(label), (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)15, (int)1, (int)0, (int)0, (int)0, (int)0);
        return p;
    }

    private String formatHexString(String hexString) {
        StringBuffer sb = new StringBuffer();
        int length = hexString.length();
        int i = 0;
        while (i < length) {
            sb.append(hexString.charAt(i));
            if (i != 0 && i % 2 - 1 == 0 && i != length - 1) {
                sb.append(':');
            }
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    private void setRowValue(Vector rowData, String field, String value) {
        if (value != null && value.length() != 0) {
            Vector<String> v = new Vector<String>();
            v.addElement(field);
            v.addElement(value);
            rowData.addElement(v);
        }
    }

    class CertNode {
        X509 _cert;

        public CertNode(X509 cert) {
            ViewCertificateDialog.this = ViewCertificateDialog.this;
            this._cert = cert;
        }

        public String toString() {
            return this._cert.getHolder().getName();
        }

        public X509 getX509Cert() {
            return this._cert;
        }
    }

    class CertTreeCellRenderer
    extends SuiTreeCellRenderer {
        public CertTreeCellRenderer() {
            ViewCertificateDialog.this = ViewCertificateDialog.this;
            ((BasicTreeCellRenderer)this).closedIcon = ((BasicTreeCellRenderer)this).leafIcon = new RemoteImage(ViewCertificateDialog.this._resource.getString("ViewCertificateDialog", "certImage"));
            ((BasicTreeCellRenderer)this).openIcon = ((BasicTreeCellRenderer)this).leafIcon;
        }
    }

    private final class 1
    extends JTree {
        public void processMouseEvent(MouseEvent e) {
            int selRow = this.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 1) {
                this.setSelectionRow(selRow);
            }
        }

        /* synthetic */ 1(DefaultMutableTreeNode $0) {
            super((TreeNode)$0);
        }
    }

    private final class 2
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            ViewCertificateDialog.this.certInfoView.setBottomComponent((Component)ViewCertificateDialog.this.setupDetailInfoPane(((CertNode)nodeInfo).getX509Cert()));
            ViewCertificateDialog.this.certInfoView.validate();
            ViewCertificateDialog.this.certInfoView.repaint();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends SuiTable {
        public void processMouseEvent(MouseEvent e) {
        }

        /* synthetic */ 3(Vector $0, Vector $1) {
            super($0, $1);
        }
    }

    class BorderLabel
    extends JLabel {
        public BorderLabel(String text, Border b) {
            super(text);
            ViewCertificateDialog.this = ViewCertificateDialog.this;
            this.setBorder(b);
            this.setHorizontalAlignment(0);
        }
    }
}

