/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.keycert.CipherEntry;
import com.netscape.management.client.keycert.IEncryptionPaneListener;
import com.netscape.management.client.keycert.KeyCertTaskInfo;
import com.netscape.management.client.keycert.KeyCertUtility;
import com.netscape.management.client.keycert.KeyCertWizard;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.border.EtchedBorder;
import com.sun.java.swing.plaf.BorderUIResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class EncryptionPane
extends JPanel
implements ActionListener {
    private JCheckBox on;
    String title;
    JPanel top;
    JPanel cipherPane;
    private Vector cipherList = new Vector();
    boolean isFortezza = false;
    boolean isDomestic = false;
    ConsoleInfo _consoleInfo;
    String certdbName;
    JButton bCipherPref;
    JButton wizardButton;
    JLabel cipherTitle;
    JLabel tokenTitle;
    JLabel certTitle;
    Vector encryptionPaneListeners = new Vector();
    EncryptionPaneActionListener actionListener = new EncryptionPaneActionListener();
    KeyCertTaskInfo taskInfo;
    ResourceSet resource;
    JPanel cPane = new JPanel();

    public void actionPerformed(ActionEvent e) {
    }

    public void addEncryptionPaneListener(IEncryptionPaneListener listener) {
        this.encryptionPaneListeners.addElement(listener);
    }

    public EncryptionPane(ConsoleInfo consoleInfo) {
        this(consoleInfo, null);
    }

    public EncryptionPane(ConsoleInfo consoleInfo, JPanel addPanel) {
        this._consoleInfo = consoleInfo;
        this.certdbName = KeyCertUtility.createTokenName(consoleInfo);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new GridBagLayout());
        this.resource = new ResourceSet("com.netscape.management.client.keycert.EncryptionPaneResource");
        this.on = new JCheckBox(this.resource.getString("EncryptionPane", "enableSSL"), false);
        this.on.setActionCommand("ENABLED");
        this.on.addActionListener((ActionListener)new CipherPaneToggleListener());
        this.on.addActionListener((ActionListener)this.actionListener);
        this.top = new JPanel();
        this.top.setAlignmentX(0.0f);
        this.top.setLayout((LayoutManager)new BoxLayout((Container)this.top, 0));
        this.top.add((Component)this.on);
        mainPane.setBorder((Border)new CompoundBorder((Border)new ToggleBorder((JComponent)this.top, 1), (Border)new EmptyBorder(0, 6, 6, 0)));
        GridBagUtil.constrain((Container)mainPane, (Component)this.top, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)0, (int)0, (int)0, (int)0, (int)0);
        this.cipherPane = new JPanel();
        this.cipherPane.setLayout(new BorderLayout());
        GridBagUtil.constrain((Container)mainPane, (Component)this.cipherPane, (int)0, (int)1, (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)0);
        this.bCipherPref = JButtonFactory.create((String)this.resource.getString("EncryptionPane", "cipherPrefTitle"));
        this.wizardButton = JButtonFactory.create((String)this.resource.getString("EncryptionPane", "wizardTitle"));
        this.bCipherPref.setActionCommand(".doCipherSetting");
        this.bCipherPref.addActionListener((ActionListener)this);
        this.bCipherPref.addActionListener((ActionListener)this.actionListener);
        this.wizardButton.setActionCommand("WIZARD");
        this.wizardButton.addActionListener((ActionListener)new wizardButtonActionListener());
        this.updateEncryptionUI();
        ((Container)((Object)this)).add("North", (Component)mainPane);
        JPanel otherPane = new JPanel();
        otherPane.setLayout((LayoutManager)new BoxLayout((Container)otherPane, 1));
        if (addPanel != null) {
            otherPane.add((Component)addPanel);
        }
        otherPane.add(Box.createRigidArea((Dimension)new Dimension(0, 6)));
        ((Container)((Object)this)).add("Center", (Component)otherPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridBagLayout());
        GridBagUtil.constrain((Container)buttonPane, (Component)this.wizardButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)16, (int)0, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)buttonPane, (Component)Box.createHorizontalGlue(), (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)15, (int)1, (int)0, (int)0, (int)0, (int)0);
        ((Container)((Object)this)).add("South", (Component)buttonPane);
    }

    public Vector getCipherList() {
        return this.cipherList;
    }

    public int getCipherCount() {
        return this.cipherList.size();
    }

    public Object getCipherAt(int index) {
        return this.cipherList.elementAt(index);
    }

    private CipherEntry getCipher(String cipherName) {
        int count = this.getCipherCount();
        int i = count - 1;
        while (i >= 0) {
            Object cipher = this.getCipherAt(i);
            if (cipherName.equals(this.getCipherName(cipher))) {
                return (CipherEntry)cipher;
            }
            --i;
        }
        return null;
    }

    public String getCipherName(Object cipher) {
        return ((CipherEntry)cipher).getCipherName();
    }

    public String getToken(Object cipher) {
        return ((CipherEntry)cipher).getSelectedToken();
    }

    public void setToken(Object cipher, String token) {
        ((CipherEntry)cipher).setSelectedToken(token);
    }

    public String getCertificateName(Object cipher) {
        return ((CipherEntry)cipher).getSelectedCertName();
    }

    public void setCertificateName(Object cipher, String certificateName) {
        ((CipherEntry)cipher).setSelectedCert(certificateName);
    }

    public boolean isEnabled(Object cipher) {
        return ((CipherEntry)cipher).isEnabled();
    }

    public void setEnabled(Object cipher, boolean on) {
        ((CipherEntry)cipher).setSelected(on);
    }

    public boolean isEncryptionEnabled() {
        return this.on.isSelected();
    }

    public void setEncryption(boolean on) {
        this.setEnableAll(on);
        this.on.setSelected(on);
    }

    public String getCertificateDBName() {
        return this.certdbName;
    }

    public void setCipherSetting(boolean on, String cipherName, String token, String personality) {
        int count = this.getCipherCount();
        int i = count - 1;
        while (i >= 0) {
            Object cipher = this.getCipherAt(i);
            if (cipherName.equals(this.getCipherName(cipher))) {
                this.setEnabled(cipher, on);
                this.setToken(cipher, token);
                this.setCertificateName(cipher, personality);
            }
            --i;
        }
    }

    public boolean hasFortezza() {
        return this.isFortezza;
    }

    public boolean isSecurityDomestic() {
        return this.isDomestic;
    }

    public JPanel getPanel() {
        return this;
    }

    private JLabel leftAlignLabel(String label) {
        return new JLabel(label, 2);
    }

    private void updateCipherEntry() {
    }

    public void refresh() {
        this.updateEncryptionUI();
    }

    private void updateEncryptionUI() {
        this.cPane.removeAll();
        this.cPane.setLayout(new GridBagLayout());
        int y = 0;
        this.cipherTitle = this.leftAlignLabel(this.resource.getString("EncryptionPane", "cipherTitle"));
        this.tokenTitle = this.leftAlignLabel(this.resource.getString("EncryptionPane", "tokenTitle"));
        this.certTitle = this.leftAlignLabel(this.resource.getString("EncryptionPane", "certTitle"));
        GridBagUtil.constrain((Container)this.cPane, (Component)this.cipherTitle, (int)0, (int)y, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)3, (int)0, (int)6, (int)12);
        GridBagUtil.constrain((Container)this.cPane, (Component)this.tokenTitle, (int)1, (int)y, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)12);
        GridBagUtil.constrain((Container)this.cPane, (Component)this.certTitle, (int)2, (int)y, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)0);
        this.taskInfo = new KeyCertTaskInfo(this._consoleInfo);
        this.taskInfo.clear();
        this.taskInfo.put("sie", this.certdbName);
        try {
            this.taskInfo.exec("ListToken");
        }
        catch (Exception e) {
            SuiOptionPane.showMessageDialog((Component)UtilConsoleGlobals.getActivatedFrame(), (Object)e.getMessage());
            return;
        }
        this.cipherList = this.taskInfo.getResponse().getFamilyList();
        this.isFortezza = this.taskInfo.getResponse().isSecurityFortezza();
        this.isDomestic = this.taskInfo.getResponse().isSecurityDomestic();
        int index = this.cipherList.size() - 1;
        while (index >= 0) {
            CipherEntry cipher = (CipherEntry)this.cipherList.elementAt(index);
            cipher.getCipherCheckBox().addActionListener((ActionListener)this);
            cipher.getTokenComboBox().addActionListener((ActionListener)this);
            cipher.getCertComboBox().addActionListener((ActionListener)this);
            String name = cipher.getCipherCheckBox().getText();
            cipher.getCipherCheckBox().setActionCommand(name);
            cipher.getTokenComboBox().setActionCommand(name);
            cipher.getCertComboBox().setActionCommand(name);
            cipher.getCipherCheckBox().addActionListener((ActionListener)this.actionListener);
            cipher.getTokenComboBox().addActionListener((ActionListener)this.actionListener);
            cipher.getCertComboBox().addActionListener((ActionListener)this.actionListener);
            GridBagUtil.constrain((Container)this.cPane, (Component)cipher.getCipherCheckBox(), (int)0, (int)(++y), (int)1, (int)1, (double)0.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)6);
            GridBagUtil.constrain((Container)this.cPane, (Component)cipher.getTokenComboBox(), (int)1, (int)y, (int)1, (int)1, (double)0.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)6);
            GridBagUtil.constrain((Container)this.cPane, (Component)cipher.getCertComboBox(), (int)2, (int)y, (int)1, (int)1, (double)0.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)6, (int)6);
            --index;
        }
        GridBagUtil.constrain((Container)this.cPane, (Component)this.bCipherPref, (int)1, (int)(++y), (int)2, (int)1, (double)1.0, (double)0.0, (int)11, (int)1, (int)0, (int)0, (int)0, (int)6);
        this.setEnableAll(false);
        this.cipherPane.add("North", (Component)this.cPane);
        this.cPane.validate();
        this.cPane.repaint();
    }

    private void setEnableAll(boolean enable) {
        int count = this.getCipherCount();
        int i = 0;
        while (i < count) {
            ((CipherEntry)this.cipherList.elementAt(i)).setEnabledAll(enable);
            ++i;
        }
        this.bCipherPref.setEnabled(enable);
        this.cipherTitle.setEnabled(enable);
        this.tokenTitle.setEnabled(enable);
        this.certTitle.setEnabled(enable);
        ((Container)((Object)this)).invalidate();
        ((Component)((Object)this)).repaint();
    }

    class EncryptionPaneActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(".doCipherSetting")) {
                int i = 0;
                while (i < EncryptionPane.this.encryptionPaneListeners.size()) {
                    ((IEncryptionPaneListener)EncryptionPane.this.encryptionPaneListeners.elementAt(i)).showCipherPreferenceDialog();
                    ++i;
                }
            } else if (e.getActionCommand().equals("ENABLED")) {
                int i = 0;
                while (i < EncryptionPane.this.encryptionPaneListeners.size()) {
                    ((IEncryptionPaneListener)EncryptionPane.this.encryptionPaneListeners.elementAt(i)).sslStateChanged(EncryptionPane.this.on.isSelected());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < EncryptionPane.this.encryptionPaneListeners.size()) {
                    CipherEntry cipher = EncryptionPane.this.getCipher(e.getActionCommand());
                    ((IEncryptionPaneListener)EncryptionPane.this.encryptionPaneListeners.elementAt(i)).cipherStateChanged(EncryptionPane.this.isEnabled(cipher), EncryptionPane.this.getCipherName(cipher), EncryptionPane.this.getToken(cipher), EncryptionPane.this.getCertificateName(cipher));
                    ++i;
                }
            }
        }

        EncryptionPaneActionListener() {
            EncryptionPane.this = EncryptionPane.this;
        }
    }

    class wizardButtonActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("WIZARD")) {
                Vector oldEntry = EncryptionPane.this.getCipherList();
                KeyCertWizard wizard = new KeyCertWizard(EncryptionPane.this._consoleInfo);
                UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(3));
                EncryptionPane.this.updateEncryptionUI();
                int i = oldEntry.size() - 1;
                while (i >= 0) {
                    Object cipher = oldEntry.elementAt(i);
                    EncryptionPane.this.setCipherSetting(EncryptionPane.this.isEnabled(cipher), EncryptionPane.this.getCipherName(cipher), EncryptionPane.this.getToken(cipher), EncryptionPane.this.getCertificateName(cipher));
                    --i;
                }
                EncryptionPane.this.setEnableAll(EncryptionPane.this.isEncryptionEnabled());
                UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(0));
            }
        }

        wizardButtonActionListener() {
            EncryptionPane.this = EncryptionPane.this;
        }
    }

    class CipherPaneToggleListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ENABLED")) {
                EncryptionPane.this.setEnableAll(EncryptionPane.this.on.isSelected());
                EncryptionPane.this.actionPerformed(e);
                ((Container)((Object)EncryptionPane.this)).validate();
                ((Component)((Object)EncryptionPane.this)).repaint();
            }
        }

        CipherPaneToggleListener() {
            EncryptionPane.this = EncryptionPane.this;
        }
    }

    class ToggleBorder
    extends EtchedBorder {
        private JComponent _switchPanel;
        private int _switchAlign;

        public ToggleBorder(JComponent sp, int align) {
            EncryptionPane.this = EncryptionPane.this;
            this._switchPanel = sp;
            this._switchAlign = align;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color save = g.getColor();
            int top = y + (this._switchPanel.getHeight() >> 1);
            int new_height = height - top;
            BorderUIResource.getEtchedBorderUIResource().paintBorder(c, g, x, top, width, new_height);
        }
    }
}

