/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.keycert.CipherResourceSet;
import com.netscape.management.client.keycert.ICipherConstants;
import com.netscape.management.client.keycert.SSL2CipherPreference;
import com.netscape.management.client.keycert.SSL3CipherPreference;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;

public class CipherPreferenceDialog
extends AbstractDialog
implements ICipherConstants {
    SSL2CipherPreference ssl2CipherPref;
    SSL3CipherPreference ssl3CipherPref;
    public static final int SSL2 = 1;
    public static final int SSL3 = 2;
    private JPanel cipherPreferencePane;
    boolean modified = true;
    Help help;

    public CipherPreferenceDialog(JFrame parent, boolean isDomestic) {
        this(parent, isDomestic, false);
    }

    public CipherPreferenceDialog(JFrame parent, boolean isDomestic, boolean hasFortezza) {
        this(parent, isDomestic, hasFortezza, 3);
    }

    public CipherPreferenceDialog(JFrame parent, boolean isDomestic, boolean hasFortezza, int SSLVersion) {
        super((Frame)parent, "", true, 11);
        CipherResourceSet r = new CipherResourceSet();
        this.help = new Help((ResourceSet)r);
        this.cipherPreferencePane = new JPanel();
        this.cipherPreferencePane.setLayout((LayoutManager)new BoxLayout((Container)this.cipherPreferencePane, 1));
        if ((1 & SSLVersion) == 1) {
            this.ssl2CipherPref = new SSL2CipherPreference(isDomestic);
            this.cipherPreferencePane.add((Component)((Object)this.ssl2CipherPref));
        }
        if ((2 & SSLVersion) == 2) {
            this.ssl3CipherPref = new SSL3CipherPreference(isDomestic, hasFortezza);
            this.cipherPreferencePane.add((Component)((Object)this.ssl3CipherPref));
        }
        this.cipherPreferencePane.add(Box.createRigidArea((Dimension)new Dimension(0, 4)));
        this.getContentPane().add((Component)this.cipherPreferencePane);
        this.pack();
    }

    public void removeSSLVersion(int sslVersion) {
        switch (sslVersion) {
            case 1: {
                this.cipherPreferencePane.remove((Component)((Object)this.ssl2CipherPref));
                break;
            }
            case 2: {
                this.cipherPreferencePane.remove((Component)((Object)this.ssl3CipherPref));
                break;
            }
        }
        this.pack();
    }

    public boolean isCipherEnabled(String cipher) {
        return (this.ssl2CipherPref == null ? false : this.ssl2CipherPref.isCipherEnabled(cipher)) || (this.ssl3CipherPref == null ? false : this.ssl3CipherPref.isCipherEnabled(cipher));
    }

    public void setCipherEnabled(String cipher, boolean enable) {
        if (this.ssl2CipherPref != null) {
            this.ssl2CipherPref.setCipherEnabled(cipher, enable);
        }
        if (this.ssl3CipherPref != null) {
            this.ssl3CipherPref.setCipherEnabled(cipher, enable);
        }
    }

    public String[] getSSLPreference(int sslVersion) {
        String[] ciphers = null;
        switch (sslVersion) {
            case 1: {
                ciphers = this.ssl2CipherPref.getCipherList();
                break;
            }
            case 2: {
                ciphers = this.ssl3CipherPref.getCipherList();
                break;
            }
            default: {
                Debug.println((String)("Cipher Preference : Invalid ssl version " + sslVersion));
            }
        }
        return ciphers;
    }

    public boolean isSSLEnabled(int sslVersion) {
        boolean enable = false;
        switch (sslVersion) {
            case 1: {
                enable = this.ssl2CipherPref.isEnabled();
                break;
            }
            case 2: {
                enable = this.ssl3CipherPref.isEnabled();
                break;
            }
            default: {
                Debug.println((String)("Cipher Preference : Invalid ssl version " + sslVersion));
            }
        }
        return enable;
    }

    public void setSSLEnabled(int sslVersion, boolean enable) {
        switch (sslVersion) {
            case 1: {
                this.ssl2CipherPref.setEnabled(enable);
                break;
            }
            case 2: {
                this.ssl3CipherPref.setEnabled(enable);
                break;
            }
            default: {
                Debug.println((String)("Cipher Preference : Invalid ssl version " + sslVersion));
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void reset() {
        if (this.ssl2CipherPref != null) {
            this.ssl2CipherPref.reset();
        }
        if (this.ssl3CipherPref != null) {
            this.ssl3CipherPref.reset();
        }
    }

    public void setSaved() {
        if (this.ssl2CipherPref != null) {
            this.ssl2CipherPref.setSaved();
        }
        if (this.ssl3CipherPref != null) {
            this.ssl3CipherPref.setSaved();
        }
    }

    public void setSaved(boolean saved) {
        if (saved) {
            if (this.ssl2CipherPref != null) {
                this.ssl2CipherPref.setSaved();
            }
            if (this.ssl3CipherPref != null) {
                this.ssl3CipherPref.setSaved();
            }
        }
    }

    protected void cancelInvoked() {
        this.reset();
        this.modified = false;
        super.cancelInvoked();
    }

    protected void okInvoked() {
        this.modified = (this.ssl2CipherPref == null ? false : this.ssl2CipherPref.isModified()) || (this.ssl3CipherPref == null ? false : this.ssl3CipherPref.isModified());
        this.setSaved();
        super.okInvoked();
    }

    protected void helpInvoked() {
        this.help.help("SSL", "Preference");
    }
}

