/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.keycert.CertBasicInfo;
import com.netscape.management.client.keycert.CertInfoDialog;
import com.netscape.management.client.keycert.CertListTableModel;
import com.netscape.management.client.keycert.KeyCertTaskInfo;
import com.netscape.management.client.keycert.Response;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import com.netscape.management.nmclf.SuiTable;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class CertListTable
extends JPanel
implements MouseListener,
Runnable {
    JTable _table;
    CertListTableModel _dataModel;
    KeyCertTaskInfo _taskInfo;
    String alias;
    String _certName;
    boolean setupComplete;
    Vector certList;
    ConsoleInfo _consoleInfo;

    private String formatLineString(String val, String option, boolean newLine) {
        if (val != null) {
            return String.valueOf(val) + (newLine ? String.valueOf(option) + "\n" : option);
        }
        return "";
    }

    public void showCert() {
        int row = this._table.getSelectedRow();
        if (row == -1) {
            return;
        }
        this._taskInfo.clear();
        this._taskInfo.put("certnn", this.getRow(row).getCertName());
        this._taskInfo.put("alias", this.alias);
        Response response = null;
        try {
            response = this._taskInfo.exec("GetCertInfo");
        }
        catch (Exception e) {
            SuiOptionPane.showMessageDialog((Component)UtilConsoleGlobals.getActivatedFrame(), (Object)e.getMessage());
            return;
        }
        if (response.hasCertInfo()) {
            CertInfoDialog infoDialog = new CertInfoDialog(null, response.getCertInfo(), this._taskInfo);
            ModalDialogUtil.setDialogLocation((Component)((Object)infoDialog), (Component)((Object)this));
            infoDialog.show();
            if (CertInfoDialog.delete) {
                this.deleteRow(row);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        int row = this._table.rowAtPoint(e.getPoint());
        if (e.getClickCount() < 2) {
            return;
        }
        if (row == -1) {
            this._table.clearSelection();
        } else {
            this.showCert();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean isTableSetup() {
        return this.setupComplete;
    }

    public CertListTable(String certName, ConsoleInfo consoleInfo) {
        super(true);
        this._consoleInfo = consoleInfo;
        this._certName = certName;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setupComplete = true;
        this.run();
    }

    private void setupTable(CertListTableModel _tableModel) {
        this._table = new SuiTable((TableModel)_tableModel);
        this._table.addMouseListener(this);
        this._table.setColumnSelectionAllowed(false);
        JScrollPane scrollpane = new JScrollPane();
        JTableHeader tableHeader = this._table.getTableHeader();
        JViewport headerViewport = new JViewport();
        headerViewport.setLayout((LayoutManager)new BoxLayout((Container)headerViewport, 0));
        headerViewport.add((Component)tableHeader);
        scrollpane.setColumnHeader(headerViewport);
        JViewport mainViewPort = scrollpane.getViewport();
        mainViewPort.add((Component)this._table);
        tableHeader.setUpdateTableInRealTime(false);
        ((Container)((Object)this)).add("Center", (Component)scrollpane);
        this.setPreferredSize(new Dimension(0, 0));
    }

    public void run() {
        this._taskInfo = new KeyCertTaskInfo(this._consoleInfo);
        this._dataModel = new CertListTableModel(CertBasicInfo.getCertTitleLabels(), new Vector());
        this._taskInfo.put("alias", this._certName);
        this.alias = this._certName;
        Response response = null;
        try {
            response = this._taskInfo.exec("CertListing");
        }
        catch (Exception e) {
            SuiOptionPane.showMessageDialog((Component)UtilConsoleGlobals.getActivatedFrame(), (Object)e.getMessage());
            this.setupComplete = false;
            return;
        }
        if (response.hasCertList()) {
            this._dataModel.setRowData(response.getCertList());
        }
        this.setupTable(this._dataModel);
    }

    public CertBasicInfo getRow(int index) {
        return this._dataModel.getRow(index);
    }

    public int getRowCount() {
        return this._dataModel.getRowCount();
    }

    public void deleteRow(int rowIndex) {
        this._dataModel.deleteRow(rowIndex);
        ((Component)((Object)this)).repaint();
    }
}

