/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.keycert.AbstractCipher;
import com.netscape.management.client.keycert.IAbstractCipherSet;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AbstractCipherPreference
extends JPanel {
    CipherPrefActionListener listener = new CipherPrefActionListener();
    Vector listenerList = new Vector();
    JPanel cipherPane = new JPanel();
    boolean _ismodified = false;
    Hashtable oldValue = new Hashtable();

    public AbstractCipherPreference() {
    }

    public AbstractCipherPreference(IAbstractCipherSet cipherList) {
        this.initialize(cipherList);
    }

    protected void initialize(IAbstractCipherSet cipherList) {
        ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
        this.cipherPane.setLayout((LayoutManager)new BoxLayout((Container)this.cipherPane, 1));
        ((Container)((Object)this)).add((Component)this.cipherPane);
        Vector ciphers = cipherList.getCipherList();
        Enumeration e = ciphers.elements();
        while (e.hasMoreElements()) {
            this.addCipher((AbstractCipher)((Object)e.nextElement()));
        }
    }

    public void addActionListener(ActionListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.addElement(l);
        }
    }

    public void addCipher(AbstractCipher cipher) {
        this.oldValue.put(cipher.getSymbolicName(), cipher.isSelected() ? "1" : "0");
        this.cipherPane.add((Component)((Object)cipher));
        cipher.addActionListener(this.listener);
    }

    public void setEnableAll(boolean enabled) {
        Component[] c = this.cipherPane.getComponents();
        int i = c.length - 1;
        while (i >= 0) {
            c[i].setEnabled(enabled);
            --i;
        }
    }

    public String[] getCipherList() {
        Component[] c = this.cipherPane.getComponents();
        String[] ciphers = new String[c.length];
        int i = c.length - 1;
        while (i >= 0) {
            ciphers[i] = ((AbstractCipher)((Object)c[i])).getSymbolicName();
            --i;
        }
        return ciphers;
    }

    private AbstractCipher findCipher(String symbolicName) {
        Component[] c = this.cipherPane.getComponents();
        AbstractCipher cipher = null;
        int i = c.length - 1;
        while (i >= 0) {
            if (((AbstractCipher)((Object)c[i])).getSymbolicName().equalsIgnoreCase(symbolicName)) {
                cipher = (AbstractCipher)((Object)c[i]);
            }
            --i;
        }
        return cipher;
    }

    public void setCipherEnabled(String cipher, boolean enabled) {
        AbstractCipher c = this.findCipher(cipher);
        if (c != null) {
            c.setSelected(enabled);
        }
    }

    public boolean isCipherEnabled(String cipher) {
        AbstractCipher c = this.findCipher(cipher);
        if (c != null) {
            return c.isSelected();
        }
        return false;
    }

    public boolean isModified() {
        return this._ismodified;
    }

    public void reset() {
        Enumeration keys = this.oldValue.keys();
        while (keys.hasMoreElements()) {
            String cipherName;
            this.setCipherEnabled(cipherName, "1".equals(this.oldValue.get(cipherName = (String)keys.nextElement())));
        }
        this._ismodified = false;
    }

    public void setSaved() {
        this.oldValue.clear();
        Component[] c = this.cipherPane.getComponents();
        int i = c.length - 1;
        while (i >= 0) {
            AbstractCipher cipher = (AbstractCipher)((Object)c[i]);
            this.oldValue.put(cipher.getSymbolicName(), cipher.isSelected() ? "1" : "0");
            --i;
        }
        this._ismodified = false;
    }

    class CipherPrefActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractCipherPreference.this._ismodified = true;
            Enumeration l = AbstractCipherPreference.this.listenerList.elements();
            while (l.hasMoreElements()) {
                ((ActionListener)l.nextElement()).actionPerformed(e);
            }
        }

        CipherPrefActionListener() {
            AbstractCipherPreference.this = AbstractCipherPreference.this;
        }
    }
}

