/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.ITaskModel;
import com.netscape.management.client.ITaskModelListener;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.LDAPTaskModel;
import com.netscape.management.client.MenuData;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.TaskModelEvent;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.nmclf.SuiConstants;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class TaskPage
extends JPanel
implements IPage,
ITaskModelListener,
Cloneable,
SuiConstants {
    public static final String MENU_CONTEXT = "CONTEXT";
    public static final String STATUS_PROGRESS = "StatusItemProgress";
    protected IFramework _framework;
    protected ITaskModel _model;
    protected TaskList _taskList;
    protected String _pageTitle = "";
    protected JPopupMenu _contextMenu = new JPopupMenu();
    protected ITaskObject _selectedTask;
    protected ITaskObject _previousSelectedTask;
    protected MenuInfoAction _menuInfoAction = new MenuInfoAction();
    protected Vector _menuData = new Vector();
    protected Vector _statusItems = new Vector();
    protected Vector _statusItemPositions = new Vector();
    protected boolean _isPageSelected = false;
    public static Icon _defaultTaskIcon;
    protected ConsoleInfo _info;
    protected StatusItemProgress _statusItemProgress = new StatusItemProgress("StatusItemProgress", 0);

    public TaskPage(ITaskModel taskModel) {
        if (_defaultTaskIcon == null) {
            _defaultTaskIcon = new RemoteImage(String.valueOf(Framework._imageSource) + "task.gif");
        }
        this.setTaskModel(taskModel);
    }

    public TaskPage(ConsoleInfo info, ITaskModel taskModel) {
        this(taskModel);
        this._info = info;
    }

    public TaskPage(ConsoleInfo info) {
        this(info, LDAPTaskModel.createTaskModel(info));
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public Object clone() {
        TaskPage page = new TaskPage(this._info, this._model);
        page.setPageTitle(this.getPageTitle());
        return page;
    }

    public void setTaskModel(ITaskModel taskModel) {
        this._model = taskModel;
        this._pageTitle = Framework.i18n((String)"page", (String)"Tasks");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).removeAll();
        ((Container)((Object)this)).add(this.createTaskPanel(this.getModel()));
        ((Container)((Object)this)).validate();
    }

    protected Component createTaskPanel(ITaskModel taskModel) {
        this._taskList = new TaskList(taskModel);
        JScrollPane treePanel = new JScrollPane();
        treePanel.getViewport().add((Component)((Object)this._taskList));
        BevelBorder b1 = new BevelBorder(1, UIManager.getColor((Object)"controlHighlight"), UIManager.getColor((Object)"control"), UIManager.getColor((Object)"controlDkShadow"), UIManager.getColor((Object)"controlShadow"));
        EmptyBorder b2 = new EmptyBorder(6, 6, 6, 6);
        treePanel.setBorder((Border)new CompoundBorder((Border)b2, (Border)b1));
        return treePanel;
    }

    public ITaskModel getModel() {
        return this._model;
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setPageTitle(String title) {
        this._pageTitle = title;
    }

    public void initialize(IFramework parent) {
        this._framework = parent;
        if (this._model instanceof IMenuInfo) {
            this.addMenuItems((IMenuInfo)this._model, this._menuInfoAction);
        }
        this._model.addITaskModelListener((ITaskModelListener)this);
        this.addStatusItem((IStatusItem)this._statusItemProgress, "R");
    }

    public ITaskObject getSelection() {
        return this._selectedTask;
    }

    public ITaskObject getPreviousSelection() {
        return this._previousSelectedTask;
    }

    public void runComplete(ITaskObject ranObject) {
    }

    private boolean isEventTarget(TaskModelEvent e) {
        IPage targetPage = e.getViewInstance();
        if (targetPage == null) {
            return true;
        }
        return targetPage == this;
    }

    public void addMenuItems(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            this.addMenuItems(e.getMenuInfo(), this._menuInfoAction);
        }
    }

    public void enableMenuItem(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            MenuData.enableMenuItem(this._menuData, e.getMenuID(), true);
        }
    }

    public void disableMenuItem(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            MenuData.enableMenuItem(this._menuData, e.getMenuID(), false);
        }
    }

    protected void addMenuItem(String categoryID, IMenuItem menuItem) {
        MenuData menuData = new MenuData(categoryID, menuItem, null);
        this.populateMenuItem(menuData);
        this._menuData.addElement(menuData);
    }

    private void populateMenuItem(MenuData menuData) {
        if (this.isPageSelected()) {
            if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                this._contextMenu.add(menuData.getIMenuItem().getComponent());
            } else {
                JMenu menu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                if (menu != null) {
                    menu.add(menuData.getIMenuItem().getComponent());
                } else {
                    this._framework.addMenuItem(menuData.getCategoryID(), menuData.getIMenuItem());
                }
            }
        }
    }

    private void populateMenuItems(Vector menuDataVector) {
        Enumeration e = menuDataVector.elements();
        while (e.hasMoreElements()) {
            this.populateMenuItem((MenuData)e.nextElement());
        }
    }

    private void unpopulateMenuItems(Vector menuDataVector) {
        if (this.isPageSelected()) {
            Enumeration e = menuDataVector.elements();
            while (e.hasMoreElements()) {
                MenuData menuData = (MenuData)e.nextElement();
                if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                    this._contextMenu.remove(menuData.getIMenuItem().getComponent());
                    continue;
                }
                JMenu menu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                if (menu != null) {
                    menu.remove(menuData.getIMenuItem().getComponent());
                    continue;
                }
                this._framework.removeMenuItem(menuData.getIMenuItem());
            }
        }
    }

    protected void addMenuItems(IMenuInfo menuInfo, ActionListener menuActionListener) {
        Vector menuData = MenuData.createMenuData(menuInfo, menuActionListener);
        this.populateMenuItems(menuData);
        MenuData.addVectors(this._menuData, menuData);
    }

    public void removeMenuItems(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            Vector menuData = MenuData.createMenuDataByID(this._menuData, MenuData.createMenuData(e.getMenuInfo(), null));
            this.unpopulateMenuItems(menuData);
            MenuData.substractVectors(this._menuData, menuData);
        }
    }

    private void addStatusItem(IStatusItem item, String position) {
        this._statusItems.addElement(item);
        this._statusItemPositions.addElement(position);
    }

    private void removeStatusItem(IStatusItem item) {
        int index = this._statusItems.indexOf(item);
        this._statusItems.removeElementAt(index);
        this._statusItemPositions.removeElementAt(index);
    }

    protected void populateStatusItems() {
        if (this.isPageSelected()) {
            int i = 0;
            while (i < this._statusItems.size()) {
                IStatusItem item = (IStatusItem)this._statusItems.elementAt(i);
                String position = (String)this._statusItemPositions.elementAt(i);
                this._framework.addStatusItem(item, position);
                ++i;
            }
        }
    }

    protected void unpopulateStatusItems() {
        if (this.isPageSelected()) {
            int i = this._statusItems.size() - 1;
            while (i >= 0) {
                IStatusItem item = (IStatusItem)this._statusItems.elementAt(i);
                this._framework.removeStatusItem(item);
                --i;
            }
        }
    }

    public void addStatusItem(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            IStatusItem item = e.getStatusItem();
            String position = e.getStatusItemPosition();
            this.addStatusItem(item, position);
            this._framework.addStatusItem(item, position);
        }
    }

    public void removeStatusItem(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            this.removeStatusItem(e.getStatusItem());
            this._framework.removeStatusItem(e.getStatusItem());
        }
    }

    public void changeStatusItemState(TaskModelEvent e) {
        if (this.isEventTarget(e) && this.isPageSelected()) {
            this._framework.changeStatusItemState(e.getStatusItemID(), e.getStatusItemState());
        }
    }

    public void changeFeedbackCursor(TaskModelEvent e) {
        if (this.isEventTarget(e)) {
            if (e.getCursor().getType() == 3 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(true);
            } else if (e.getCursor().getType() == 0 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(false);
            } else {
                this._framework.setCursor(e.getCursor());
            }
        }
    }

    public boolean isPageSelected() {
        return this._isPageSelected;
    }

    public void pageSelected(IFramework parent) {
        this._isPageSelected = true;
        this.populateMenuItems(this._menuData);
        this.populateStatusItems();
    }

    public void pageUnselected(IFramework parent) {
        this.unpopulateMenuItems(this._menuData);
        this.unpopulateStatusItems();
        this._isPageSelected = false;
    }

    public void actionViewClosing(IFramework parent) throws CloseVetoException {
        this.getModel().actionViewClosing((IPage)this);
    }

    class MenuInfoAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            IMenuItem menuItem = (IMenuItem)event.getSource();
            IMenuInfo menuInfo = MenuData.findIMenuInfo(TaskPage.this._menuData, menuItem);
            menuInfo.actionMenuSelected((IPage)TaskPage.this, menuItem);
        }

        MenuInfoAction() {
            TaskPage.this = TaskPage.this;
        }
    }

    class TaskList
    extends JPanel
    implements SwingConstants,
    SuiConstants,
    Scrollable {
        LabelMouseListener _labelListener = new LabelMouseListener();
        ButtonMouseListener _buttonListener = new ButtonMouseListener();
        ITaskModel _taskModel;
        int SPACE = 6;
        VisibleTask _visibleTask;
        JSeparator _separator;

        public TaskList(ITaskModel taskModel) {
            TaskPage.this = TaskPage.this;
            this._taskModel = taskModel;
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            ((Component)((Object)this)).setBackground(UIManager.getColor((Object)"window"));
            Object root = this._taskModel.getRoot();
            int childCount = this._taskModel.getChildCount(root);
            int i = 0;
            while (i < childCount) {
                ITaskObject taskObject = (ITaskObject)this._taskModel.getChild(root, i);
                this._visibleTask = new VisibleTask(taskObject);
                ((Component)((Object)this._visibleTask)).addMouseListener(this._labelListener);
                GridBagUtil.constrain((Container)((Object)this), (Component)((Object)this._visibleTask), (int)0, (int)-1, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)this.SPACE, (int)this.SPACE, (int)this.SPACE, (int)this.SPACE);
                if (i != childCount - 1) {
                    this._separator = new JSeparator();
                    GridBagUtil.constrain((Container)((Object)this), (Component)this._separator, (int)0, (int)-1, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0);
                }
                ++i;
            }
            JPanel spacerPanel = new JPanel();
            spacerPanel.setOpaque(false);
            GridBagUtil.constrain((Container)((Object)this), (Component)spacerPanel, (int)0, (int)-1, (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height : visibleRect.width;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return this.SPACE + this._visibleTask.getHeight() + this.SPACE + 3;
            }
            return 16;
        }

        class VisibleTask
        extends JPanel {
            ITaskObject _taskObject;
            JButton button;

            public VisibleTask(ITaskObject taskObject) {
                TaskList.this = TaskList.this;
                this._taskObject = taskObject;
                ((Container)((Object)this)).setLayout(new GridBagLayout());
                this.setOpaque(false);
                Icon taskIcon = taskObject.getIcon();
                this.button = new JButton(taskIcon == null ? _defaultTaskIcon : taskIcon);
                this.button.setFocusPainted(false);
                this.button.setOpaque(true);
                this.button.setMargin(new Insets(0, 0, 0, 0));
                this.button.addMouseListener(TaskList.this._buttonListener);
                GridBagUtil.constrain((Container)((Object)this), (Component)this.button, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)0, (int)0, (int)0, (int)0);
                JLabel label = new JLabel(taskObject.getName());
                label.setOpaque(false);
                label.setHorizontalTextPosition(2);
                label.setFont(UIManager.getFont((Object)"TaskList.font"));
                label.setBorder(BorderFactory.createEmptyBorder((int)0, (int)6, (int)0, (int)0));
                GridBagUtil.constrain((Container)((Object)this), (Component)label, (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)0, (int)3, (int)0, (int)0);
            }

            public void selected() {
                this.getRootPane().setDefaultButton(this.button);
            }

            public ITaskObject getTaskObject() {
                return this._taskObject;
            }
        }

        class LabelMouseListener
        extends MouseAdapter {
            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                VisibleTask visibleTask = (VisibleTask)((Object)e.getSource());
                visibleTask.selected();
                ((TaskList)TaskList.this).TaskPage.this._previousSelectedTask = ((TaskList)TaskList.this).TaskPage.this._selectedTask;
                ((TaskList)TaskList.this).TaskPage.this._selectedTask = visibleTask.getTaskObject();
                TaskList.this._taskModel.actionObjectSelected((IPage)TaskPage.this, ((TaskList)TaskList.this).TaskPage.this._selectedTask, ((TaskList)TaskList.this).TaskPage.this._previousSelectedTask);
                if (((TaskList)TaskList.this).TaskPage.this._contextMenu != null && e.isPopupTrigger() && ((TaskList)TaskList.this).TaskPage.this._contextMenu.getComponentCount() > 0) {
                    ((TaskList)TaskList.this).TaskPage.this._contextMenu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (((TaskList)TaskList.this).TaskPage.this._contextMenu != null && e.isPopupTrigger() && ((TaskList)TaskList.this).TaskPage.this._contextMenu.getComponentCount() > 0) {
                    ((TaskList)TaskList.this).TaskPage.this._contextMenu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            LabelMouseListener() {
                TaskList.this = TaskList.this;
            }
        }

        class ButtonMouseListener
        extends MouseAdapter {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    JButton button = (JButton)e.getSource();
                    VisibleTask visibleTask = (VisibleTask)((Object)button.getParent());
                    visibleTask.selected();
                    if (!((Framework)TaskPage.this.getFramework()).isClosing()) {
                        TaskList.this._taskModel.actionObjectRun((IPage)TaskPage.this, visibleTask.getTaskObject());
                    }
                }
            }

            ButtonMouseListener() {
                TaskList.this = TaskList.this;
            }
        }

        class TaskKeyListener
        implements KeyListener {
            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                ITaskObject selection;
                if (e.getKeyCode() == 10 && (selection = TaskPage.this.getSelection()) != null) {
                    TaskList.this._taskModel.actionObjectRun((IPage)TaskPage.this, selection);
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            TaskKeyListener() {
                TaskList.this = TaskList.this;
            }
        }
    }
}

