/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IMenuItemCategory;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JPopupMenu;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

class MenuData {
    String _categoryID;
    IMenuItem _item;
    IMenuInfo _menuInfo;

    MenuData(String categoryID, IMenuItem menuItem, IMenuInfo menuInfo) {
        this.setCategoryID(categoryID);
        this.setIMenuItem(menuItem);
        this.setIMenuInfo(menuInfo);
    }

    String getCategoryID() {
        return this._categoryID;
    }

    IMenuItem getIMenuItem() {
        return this._item;
    }

    IMenuInfo getIMenuInfo() {
        return this._menuInfo;
    }

    void setCategoryID(String categoryID) {
        this._categoryID = categoryID;
    }

    void setIMenuItem(IMenuItem item) {
        this._item = item;
    }

    void setIMenuInfo(IMenuInfo menuInfo) {
        this._menuInfo = menuInfo;
    }

    public static Vector createMenuData(IMenuInfo menuInfo, ActionListener actionListener2) {
        Vector<MenuData> menuData = new Vector<MenuData>();
        String[] categoryID = menuInfo.getMenuCategoryIDs();
        if (categoryID != null) {
            int index = 0;
            while (index < categoryID.length) {
                IMenuItem[] menuItem = menuInfo.getMenuItems(categoryID[index]);
                if (menuItem != null) {
                    int menuIndex = 0;
                    while (menuIndex < menuItem.length) {
                        if (actionListener2 != null) {
                            menuItem[menuIndex].removeActionListener(actionListener2);
                            menuItem[menuIndex].addActionListener(actionListener2);
                        }
                        menuData.addElement(new MenuData(categoryID[index], menuItem[menuIndex], menuInfo));
                        ++menuIndex;
                    }
                }
                ++index;
            }
        }
        return menuData;
    }

    public static IMenuItem findIMenuItem(Vector menuDataVector, String menuID) {
        Enumeration e = menuDataVector.elements();
        while (e.hasMoreElements()) {
            MenuData menuData = (MenuData)e.nextElement();
            if (!menuID.equals(menuData.getIMenuItem().getID())) continue;
            return menuData.getIMenuItem();
        }
        return null;
    }

    public static IMenuInfo findIMenuInfo(Vector menuDataVector, IMenuItem menuItem) {
        Enumeration e = menuDataVector.elements();
        while (e.hasMoreElements()) {
            MenuData menuData = (MenuData)e.nextElement();
            if (menuItem != menuData.getIMenuItem()) continue;
            return menuData.getIMenuInfo();
        }
        return null;
    }

    public static void enableMenuItem(Vector menuDataVector, String menuID, boolean state) {
        Enumeration e = menuDataVector.elements();
        while (e.hasMoreElements()) {
            IMenuItem menuItem;
            MenuData menuData = (MenuData)e.nextElement();
            if (!menuID.equals(menuData.getIMenuItem().getID()) || !((menuItem = menuData.getIMenuItem()).getComponent() instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)menuItem.getComponent();
            button.setEnabled(state);
        }
    }

    public static void addVectors(Vector v1, Vector v2) {
        Enumeration e = v2.elements();
        while (e.hasMoreElements()) {
            v1.addElement(e.nextElement());
        }
    }

    public static Vector createMenuDataByID(Vector v1, Vector v2) {
        Vector<MenuData> v = new Vector<MenuData>();
        Enumeration e2 = v2.elements();
        block0: while (e2.hasMoreElements()) {
            MenuData menuDataToRemove = (MenuData)e2.nextElement();
            Enumeration e1 = v1.elements();
            while (e1.hasMoreElements()) {
                MenuData menuData = (MenuData)e1.nextElement();
                if (!menuData.getIMenuItem().getID().equals(menuDataToRemove.getIMenuItem().getID()) || !menuData.getCategoryID().equals(menuDataToRemove.getCategoryID())) continue;
                v.addElement(menuData);
                continue block0;
            }
        }
        return v;
    }

    public static void substractVectors(Vector v1, Vector v2) {
        Enumeration e = v2.elements();
        while (e.hasMoreElements()) {
            v1.removeElement(e.nextElement());
        }
    }

    public static JMenu getMenu(JPopupMenu popupMenu, String categoryID) {
        JMenu result = null;
        int index = 0;
        while (index < popupMenu.getComponentCount()) {
            JMenu newResult;
            Component menu = popupMenu.getComponentAtIndex(index);
            if (menu instanceof IMenuItemCategory && categoryID.equals(((IMenuItemCategory)menu).getID())) {
                result = (JMenu)((IMenuItemCategory)menu).getComponent();
                break;
            }
            if (menu instanceof JMenu && (newResult = MenuData.getMenu((JMenu)menu, categoryID)) != null) {
                result = newResult;
                break;
            }
            ++index;
        }
        return result;
    }

    public static JMenu getMenu(JMenu parent, String categoryID) {
        JMenu result = null;
        int index = 0;
        while (index < parent.getMenuComponentCount()) {
            JMenu newResult;
            Component c = parent.getMenuComponent(index);
            if (c instanceof IMenuItemCategory && categoryID.equals(((IMenuItemCategory)c).getID())) {
                result = (JMenu)((IMenuItemCategory)c).getComponent();
                break;
            }
            if (c instanceof JMenu && (newResult = MenuData.getMenu((JMenu)c, categoryID)) != null) {
                result = newResult;
                break;
            }
            ++index;
        }
        return result;
    }

    public static JMenu getMenu(JMenuBar menuBar, String categoryID) {
        JMenu result = null;
        int index = 0;
        while (index < menuBar.getMenuCount()) {
            JMenu newResult;
            JMenu menu = menuBar.getMenu(index);
            if (menu instanceof IMenuItemCategory && categoryID.equals(((IMenuItemCategory)menu).getID())) {
                result = (JMenu)((IMenuItemCategory)menu).getComponent();
                break;
            }
            if (menu instanceof JMenu && (newResult = MenuData.getMenu(menu, categoryID)) != null) {
                result = newResult;
                break;
            }
            ++index;
        }
        return result;
    }

    public static boolean removeMenuItem(JMenu parent, IMenuItem item) {
        boolean result = false;
        int index = 0;
        while (index < parent.getMenuComponentCount()) {
            Component c = parent.getMenuComponent(index);
            if (c instanceof IMenuItem && c == item) {
                parent.remove(index);
                result = true;
                break;
            }
            if (c instanceof JMenu && MenuData.removeMenuItem((JMenu)c, item)) {
                result = true;
                break;
            }
            ++index;
        }
        return result;
    }
}

