/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.config.ExtendedPluginInfoCheckBox;
import com.netscape.admin.certsrv.config.ExtendedPluginInfoComboBox;
import com.netscape.admin.certsrv.config.ExtendedPluginInfoComponent;
import com.netscape.admin.certsrv.config.ExtendedPluginInfoNumberField;
import com.netscape.admin.certsrv.config.ExtendedPluginInfoPasswordField;
import com.netscape.admin.certsrv.config.ExtendedPluginInfoTextField;
import com.sun.java.swing.JComponent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;

class ExtendedPluginInfo {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_CHOICE = 3;
    public static final int TYPE_PASSWORD = 4;
    private int mType;
    private boolean mRequired;
    private String mValue;
    private Vector mChoices;
    private String mHelpText;
    private JComponent component;

    ExtendedPluginInfo(String type, String helptext) {
        this.mHelpText = helptext;
        if (type.equals("string")) {
            this.mType = 0;
        } else if (type.equals("boolean")) {
            this.mType = 1;
        } else if (type.equals("number")) {
            this.mType = 2;
        } else if (type.equals("password")) {
            this.mType = 4;
        } else if (type.startsWith("choice")) {
            this.mType = 3;
            String choices = type.substring(type.indexOf(40) + 1, type.indexOf(41));
            StringTokenizer tokenizer = new StringTokenizer(choices, ",", false);
            this.mChoices = new Vector();
            String prefix = null;
            while (tokenizer.hasMoreElements()) {
                String c = (String)tokenizer.nextElement();
                int i = c.indexOf("\\");
                if (i != -1) {
                    if (prefix == null) {
                        prefix = c.substring(0, i);
                        continue;
                    }
                    prefix = String.valueOf(prefix) + "," + c.substring(0, i);
                    continue;
                }
                if (prefix != null) {
                    c = String.valueOf(prefix) + "," + c;
                    prefix = null;
                }
                this.mChoices.addElement(c);
            }
        } else {
            this.mType = 0;
        }
    }

    public Vector getChoices() {
        return this.mChoices;
    }

    public String getHelpText() {
        return this.mHelpText;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(String val) {
        this.mValue = val;
    }

    public int getType() {
        return this.mType;
    }

    public void setRequired(boolean b) {
        this.mRequired = b;
    }

    public boolean isRequired() {
        return this.mRequired;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getComponentStateAsString() {
        if (this.component == null) {
            return null;
        }
        return ((ExtendedPluginInfoComponent)this.component).getValueAsString();
    }

    public JComponent makeComponent(ActionListener al) {
        switch (this.getType()) {
            case 1: {
                boolean b = this.getValue().equals("true");
                this.component = new ExtendedPluginInfoCheckBox(this, b);
                ((ExtendedPluginInfoCheckBox)this.component).addActionListener(al);
                break;
            }
            case 0: {
                this.component = new ExtendedPluginInfoTextField(this, this.getValue());
                ((ExtendedPluginInfoTextField)this.component).addActionListener(al);
                break;
            }
            case 2: {
                this.component = new ExtendedPluginInfoNumberField(this, this.getValue());
                ((ExtendedPluginInfoNumberField)this.component).addActionListener(al);
                break;
            }
            case 4: {
                this.component = new ExtendedPluginInfoPasswordField(this, "");
                ((ExtendedPluginInfoPasswordField)this.component).addActionListener(al);
                break;
            }
            case 3: {
                ExtendedPluginInfoComboBox cb = new ExtendedPluginInfoComboBox(this, this.getChoices());
                cb.setSelectedItem(this.getValue());
                cb.addActionListener(al);
                this.component = cb;
                break;
            }
            default: {
                return null;
            }
        }
        return this.component;
    }
}

