/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.PasswordCellRenderer;
import com.netscape.admin.certsrv.config.CMSBaseConfigDialog;
import com.netscape.admin.certsrv.config.CMSRuleDataModel;
import com.netscape.admin.certsrv.config.PluginSelectionDialog;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.StringTokenizer;

public abstract class CMSPluginInstanceTab
extends CMSBaseUGTab {
    protected static String PANEL_NAME = null;
    protected static String RULE_NAME = null;
    protected static String RULE_STAT = null;
    protected static String RULE_IMPL = null;
    protected static String RULE_TYPE = null;
    protected AdminConnection mConnection;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected CMSRuleDataModel mDataModel;
    protected String mDestination;
    protected String mScope;
    protected JButton mRefresh;
    protected JButton mEdit;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mOrder;
    protected JButton mHelp;
    protected static String RAHELPINDEX = null;
    protected static String CAHELPINDEX = null;
    protected static String KRAHELPINDEX = null;

    public CMSPluginInstanceTab(CMSBaseResourceModel model, String dest, String panelName) {
        super(panelName, model);
        Debug.println((String)("CMSPluginInstanceTab::CMSPluginInstanceTab(<model>," + dest + "," + panelName + ")"));
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDestination = dest;
    }

    public abstract CMSBaseConfigDialog makeNewConfigDialog(NameValuePairs var1, JFrame var2, AdminConnection var3, String var4);

    public abstract PluginSelectionDialog getPluginSelectionDialog(JFrame var1, AdminConnection var2, String var3, CMSPluginInstanceTab var4);

    public void moreActionPerformed(ActionEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            Debug.println((String)"Refresh");
            this.refresh();
        }
        if (e.getSource().equals(this.mEdit)) {
            NameValuePairs response;
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            this.mModel.progressStart();
            try {
                response = this.getConfig();
            }
            catch (EAdminException ex1) {
                this.showErrorDialog(ex1.getMessage());
                this.mModel.progressStop();
                return;
            }
            this.mModel.progressStop();
            Debug.println((String)response.toString());
            CMSBaseConfigDialog dialog = this.makeNewConfigDialog(response, this.mModel.getFrame(), this.mModel.getServerInfo().getAdmin(), this.mDestination);
            dialog.setModel(this.mModel);
            dialog.setInstanceScope(this.mScope);
            dialog.showDialog(response, data.getValue(RULE_NAME));
            if (!dialog.isOK()) {
                return;
            }
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            Debug.println((String)"Add");
            PluginSelectionDialog dialog = this.getPluginSelectionDialog(this.mModel.getFrame(), this.mConnection, this.mDestination, this);
            dialog.setModel(this.mModel);
            dialog.showDialog();
            this.refresh();
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
        this.moreActionPerformed(e);
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.update();
        this.setButtons();
    }

    protected JPanel createUserButtonPanel() {
        Debug.println((String)"CMSPluginInstanceTab::createUserButtonPanel()");
        this.mEdit = this.makeJButton("EDIT");
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mEdit};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        Debug.println((String)"CMSPluginInstanceTab::createActionPanel()");
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        block2: {
            Debug.println((String)"CMSPluginInstanceTab::createListPanel()");
            try {
                this.mListPanel = new JPanel();
                GridBagLayout gb = new GridBagLayout();
                GridBagConstraints gbc = new GridBagConstraints();
                this.mListPanel.setLayout(gb);
                this.mTable = new JTable((TableModel)this.mDataModel);
                this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
                this.mScrollPane.setHorizontalScrollBarPolicy(31);
                this.mScrollPane.setVerticalScrollBarPolicy(22);
                this.mTable.setAutoscrolls(true);
                this.mTable.sizeColumnsToFit(true);
                this.mTable.getSelectionModel().setSelectionMode(0);
                this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
                this.mScrollPane.setBackground(Color.white);
                this.mTable.addMouseListener((MouseListener)((Object)this));
                this.setLabelCellRenderer(this.mTable, 0);
                CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
                gbc.anchor = 11;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.insets = CMSBasePanel.EMPTY_INSETS;
                gbc.fill = 1;
                gb.setConstraints((Component)this.mScrollPane, gbc);
                this.mListPanel.add((Component)this.mScrollPane);
                JPanel buttonPanel = this.createUserButtonPanel();
                CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
                gbc.anchor = 11;
                gbc.gridwidth = 0;
                gbc.gridheight = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
                gbc.insets = CMSBasePanel.EMPTY_INSETS;
                gb.setConstraints((Component)buttonPanel, gbc);
                this.mListPanel.add((Component)buttonPanel);
                this.refresh();
                Debug.println((String)"returning from CMSPluginInstanceTab::createListPanel()");
            }
            catch (Exception e3) {
                Debug.println((String)"e3: caught exception:");
                if (!Debug.isEnabled()) break block2;
                e3.printStackTrace();
            }
        }
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        Debug.println((String)("Table.getColumnModel = " + table.getColumnModel()));
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    protected void setLabelCellEditor(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new PasswordCellRenderer());
        table.getColumnModel().getColumn(index).setCellEditor((TableCellEditor)new DefaultCellEditor((JTextField)new JPasswordField()));
    }

    protected void setButtons() {
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() <= 0) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        this.mEdit.setEnabled(true);
    }

    private void update() {
        NameValuePairs response;
        try {
            Debug.println((String)"CMSPluginInstanceTab:update() ---- 1 --- ");
            Debug.println((String)("mConnection = " + this.mConnection));
            response = this.mConnection.search(this.mDestination, this.mScope, new NameValuePairs());
        }
        catch (EAdminException e) {
            if (Debug.isEnabled()) {
                e.printStackTrace();
            }
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String plugin = "";
            String visibility = null;
            String enabled = null;
            String entry = ((String)e.nextElement()).trim();
            String value = response.getValue(entry);
            StringTokenizer st = new StringTokenizer(value, ";");
            if (st.hasMoreElements()) {
                plugin = st.nextToken();
                if (st.hasMoreElements()) {
                    visibility = st.nextToken();
                    if (st.hasMoreElements()) {
                        enabled = st.nextToken();
                    }
                }
            }
            if (visibility == null || !visibility.equals("visible")) continue;
            NameValuePairs data = new NameValuePairs();
            data.add(RULE_NAME, entry);
            data.add(RULE_IMPL, plugin);
            if (enabled != null) {
                data.add(RULE_STAT, enabled);
            }
            this.mDataModel.processData((Object)data);
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mTable.invalidate();
        this.mTable.validate();
        this.mTable.repaint(1L);
        this.mModel.progressStop();
    }

    private void delete() {
        this.mModel.progressStart();
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        try {
            this.mConnection.delete(this.mDestination, this.mScope, data.getValue(RULE_NAME));
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }

    private NameValuePairs getConfig() throws EAdminException {
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        NameValuePairs response = this.mConnection.read(this.mDestination, this.mScope, data.getValue(RULE_NAME), new NameValuePairs());
        return response;
    }
}

