/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.config.ACLImplDataModel;
import com.netscape.admin.certsrv.config.EvaluatorRegisterDialog;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.admin.certsrv.ug.CMSUGTabPanel;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class ACLImplTab
extends CMSBaseUGTab {
    private static String PANEL_NAME = "ACLIMPL";
    private CMSBaseResourceModel mModel;
    private AdminConnection mConnection;
    private JTable mTable;
    private JScrollPane mScrollPane;
    protected ACLImplDataModel mDataModel;
    protected EvaluatorRegisterDialog mEditor;
    protected JButton mRefresh;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mHelp;
    private static final String HELPINDEX = "configuration-acl-evaluators-help";

    public ACLImplTab(CMSUGTabPanel parent) {
        super(PANEL_NAME, parent.getResourceModel());
        this.mModel = parent.getResourceModel();
        this.mDataModel = new ACLImplDataModel();
        this.mConnection = this.mModel.getServerInfo().getAdmin();
        this.mHelpToken = HELPINDEX;
    }

    protected JPanel createListPanel() {
        JPanel mainPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mainPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane.setBackground(Color.white);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mainPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        mainPanel.add((Component)buttonPanel);
        this.refresh();
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    public void refresh() {
        this.mModel.progressStart();
        this.mDataModel.removeAllRows();
        this.update();
        this.mTable.invalidate();
        this.mTable.validate();
        this.mScrollPane.invalidate();
        this.mScrollPane.validate();
        this.mScrollPane.repaint(1L);
        this.mModel.progressStop();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            this.refresh();
        } else if (e.getSource().equals(this.mAdd)) {
            if (this.mEditor == null) {
                this.mEditor = new EvaluatorRegisterDialog(this.mModel.getFrame(), this.mConnection);
            }
            this.mEditor.showDialog("acl", "impl");
            this.refresh();
        } else if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        } else if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    private void delete() {
        int row = this.mTable.getSelectedRow();
        try {
            this.mConnection.delete("acl", "impl", ((JLabel)this.mDataModel.getValueAt(row, 0)).getText());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            return;
        }
        this.refresh();
    }

    private void update() {
        NameValuePairs response;
        try {
            response = this.mConnection.search("acl", "impl", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            return;
        }
        Debug.println((String)response.toString());
        int i = 0;
        String[] vals = new String[response.size()];
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            vals[i++] = entry;
        }
        CMSAdminUtil.bubbleSort((String[])vals);
        i = 0;
        while (i < vals.length) {
            String name = vals[i];
            Vector<Object> v = new Vector<Object>();
            v.addElement(new JLabel(name, (Icon)CMSAdminUtil.getImage((String)"aclplugin.gif"), 2));
            v.addElement(response.getValue(name));
            this.mDataModel.addRow(v);
            ++i;
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
    }
}

