/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.EncryptedValue;
import org.mozilla.jss.util.Assert;

public class EncryptedKey
implements ASN1Value {
    public static final Type ENCRYPTED_VALUE = Type.ENCRYPTED_VALUE;
    public static final Type ENVELOPED_DATA = Type.ENVELOPED_DATA;
    private Type type;
    private EncryptedValue encryptedValue;
    private ANY envelopedData;
    private Tag tag;
    private static final Template templateInstance = new Template();

    private EncryptedKey() {
    }

    public EncryptedKey(ANY aNY) {
        this.type = ENVELOPED_DATA;
        this.envelopedData = aNY;
        this.tag = new Tag(0L);
    }

    public EncryptedKey(EncryptedValue encryptedValue) {
        this.type = ENCRYPTED_VALUE;
        this.encryptedValue = encryptedValue;
        this.tag = SEQUENCE.TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Assert.assert(this.getTag().equals(tag));
        if (this.type == ENCRYPTED_VALUE) {
            Assert.assert(this.encryptedValue != null);
            this.encryptedValue.encode(tag, outputStream);
        } else {
            Assert.assert(this.type == ENVELOPED_DATA);
            Assert.assert(this.envelopedData != null);
            this.envelopedData.encode(tag, outputStream);
        }
    }

    public EncryptedValue getEncryptedValue() {
        return this.encryptedValue;
    }

    public ANY getEnvelopedData() {
        return this.envelopedData;
    }

    public Tag getTag() {
        return this.tag;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public Type getType() {
        return this.type;
    }

    public static class Type {
        static final Type ENCRYPTED_VALUE = new Type();
        static final Type ENVELOPED_DATA = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(EncryptedValue.getTemplate());
            this.choicet.addElement(new Tag(0L), ANY.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            try {
                CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
                if (cHOICE.getTag().equals(SEQUENCE.TAG)) {
                    return new EncryptedKey((EncryptedValue)cHOICE.getValue());
                }
                Assert.assert(cHOICE.getTag().equals(new Tag(0L)));
                return new EncryptedKey((ANY)cHOICE.getValue());
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "EncryptedKey");
            }
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            Assert.notReached("EncryptedKey, being a CHOICE, cannot be implicitly tagged");
            return this.decode(inputStream);
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }
    }
}

