/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class DigestInfo
implements ASN1Value {
    private AlgorithmIdentifier digestAlgorithm;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private DigestInfo() {
    }

    public DigestInfo(AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING) {
        if (algorithmIdentifier == null || oCTET_STRING == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.digestAlgorithm = algorithmIdentifier;
        this.sequence.addElement(algorithmIdentifier);
        this.digest = oCTET_STRING;
        this.sequence.addElement(oCTET_STRING);
    }

    private static boolean byteArraysAreSame(byte[] byArray, byte[] byArray2) {
        Assert.assert(byArray != null && byArray2 != null);
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DigestInfo)) {
            return false;
        }
        DigestInfo digestInfo = (DigestInfo)object;
        return DigestInfo.byteArraysAreSame(digestInfo.digest.toByteArray(), this.digest.toByteArray());
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new DigestInfo((AlgorithmIdentifier)sEQUENCE.elementAt(0), (OCTET_STRING)sEQUENCE.elementAt(1));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

