/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmmf.CertifiedKeyPair;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;
import org.mozilla.jss.util.Assert;

public class CertResponse
implements ASN1Value {
    private INTEGER certReqId;
    private PKIStatusInfo status;
    private CertifiedKeyPair certifiedKeyPair;
    public static final Tag TAG = SEQUENCE.TAG;

    private CertResponse() {
    }

    public CertResponse(INTEGER iNTEGER, PKIStatusInfo pKIStatusInfo) {
        this.certReqId = iNTEGER;
        this.status = pKIStatusInfo;
    }

    public CertResponse(INTEGER iNTEGER, PKIStatusInfo pKIStatusInfo, CertifiedKeyPair certifiedKeyPair) {
        this(iNTEGER, pKIStatusInfo);
        this.certifiedKeyPair = certifiedKeyPair;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.certReqId);
        sEQUENCE.addElement(this.status);
        if (this.certifiedKeyPair != null) {
            sEQUENCE.addElement(this.certifiedKeyPair);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public INTEGER getCertReqId() {
        return this.certReqId;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        Assert.assert(this.certifiedKeyPair != null);
        return this.certifiedKeyPair;
    }

    public PKIStatusInfo getPKIStatusInfo() {
        return this.status;
    }

    public Tag getTag() {
        return TAG;
    }

    public boolean hasCertifiedKeyPair() {
        return this.certifiedKeyPair != null;
    }
}

