/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class EXPLICIT
implements ASN1Value {
    public static final Form FORM = Form.CONSTRUCTED;
    private ASN1Value content;
    private Tag tag;

    private EXPLICIT() {
    }

    public EXPLICIT(Tag tag, ASN1Value aSN1Value) {
        Assert.assert(tag != null && aSN1Value != null);
        this.content = aSN1Value;
        this.tag = tag;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.tag, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.content.encode(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, byArray.length);
        aSN1Header.encode(outputStream);
        outputStream.write(byArray);
    }

    public ASN1Value getContent() {
        return this.content;
    }

    public Tag getTag() {
        return this.tag;
    }

    public static Template getTemplate(Tag tag, ASN1Template aSN1Template) {
        return new Template(tag, aSN1Template);
    }

    public static class Template
    implements ASN1Template {
        private ASN1Template content;
        private Tag tag;

        private Template() {
        }

        public Template(Tag tag, ASN1Template aSN1Template) {
            this.content = aSN1Template;
            this.tag = tag;
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.tag, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, Form.CONSTRUCTED);
                ASN1Value aSN1Value = this.content.decode(inputStream);
                EXPLICIT eXPLICIT = new EXPLICIT(this.tag, aSN1Value);
                if (aSN1Header.getContentLength() == -1L && !(aSN1Header = new ASN1Header(inputStream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                return eXPLICIT;
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "EXPLICIT");
            }
        }

        public boolean tagMatch(Tag tag) {
            return this.tag.equals(tag);
        }
    }
}

