/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspMangler;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.tomcat.logging.Logger;

public class JspServlet
extends HttpServlet {
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected JasperLoader loader;
    protected Options options;
    protected ClassLoader parentClassLoader;
    protected String serverInfo;
    protected boolean loadPrecompiledJsps = false;
    private long reloadInterval = 0L;
    static boolean firstTime = true;
    static boolean jdk12 = false;

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            jdk12 = true;
        }
        catch (Exception exception) {}
    }

    private void createJasperLoader() throws JasperException {
        Object object;
        if (jdk12) {
            try {
                object = Class.forName("org.apache.jasper.servlet.JasperLoader12");
                this.loader = (JasperLoader)((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(exception);
            }
        }
        if (this.loader == null) {
            this.loader = new JasperLoader();
        }
        if (this.loader != null) {
            this.loader.setParentClassLoader(this.parentClassLoader);
            this.loader.setOptions(this.options);
            object = this.context.getAttribute("org.apache.tomcat.protection_domain");
            this.loader.setProtectionDomain(object);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        this.unloadJsps();
        this.loader = null;
    }

    private JspServletWrapper getWrapper(String string) {
        JspServletWrapper jspServletWrapper = (JspServletWrapper)this.jsps.get(string);
        if (jspServletWrapper != null) {
            jspServletWrapper.incrementRefCount();
        }
        return jspServletWrapper;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        this.reloadInterval = (Integer)this.context.getAttribute("com.iplanet.server.http.servlet.reload-interval") * 1000;
        this.options = new EmbededServletOptions(servletConfig, this.context);
        this.parentClassLoader = (ClassLoader)this.context.getAttribute("com.iplanet.server.http.servlet.classloader");
        if (this.parentClassLoader == null) {
            this.parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        if (this.loader == null) {
            this.createJasperLoader();
        }
        if (firstTime) {
            firstTime = false;
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
        if ((string = servletConfig.getInitParameter("use-precompiled")) != null && string.equalsIgnoreCase("true")) {
            this.loadPrecompiledJsps = true;
            Constants.message("jsp.message.precompiled_jsps", 3);
        }
    }

    boolean preCompile(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        boolean bl = false;
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null && (string2.startsWith("jsp_precompile") || string2.indexOf("&jsp_precompile") != -1) && (string = httpServletRequest.getParameter("jsp_precompile")) != null) {
            if (string.equals("") || string.equals("true") || string.equals("\"true\"")) {
                bl = true;
            } else if (string.equals("false") || string.equals("\"false\"")) {
                bl = false;
            } else {
                throw new ServletException("Can't have request parameter jsp_precomile set to " + string);
            }
        }
        return bl;
    }

    private void releaseWrapper(JspServletWrapper jspServletWrapper) {
        if (jspServletWrapper != null) {
            jspServletWrapper.decrementRefCount();
        }
    }

    private synchronized void reloadJsps() throws JasperException {
        this.unloadJsps();
        this.createJasperLoader();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            String string2 = string == null ? httpServletRequest.getServletPath() : string;
            boolean bl = this.preCompile(httpServletRequest);
            Logger logger = Constants.jasperLog;
            if (logger != null && logger.matchVerbosityLevel(3)) {
                logger.log("JspEngine --> " + string2);
                logger.log("\t     ServletPath: " + httpServletRequest.getServletPath());
                logger.log("\t        PathInfo: " + httpServletRequest.getPathInfo());
                logger.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(string2));
                logger.log("\t      RequestURI: " + httpServletRequest.getRequestURI());
                logger.log("\t     QueryString: " + httpServletRequest.getQueryString());
            }
            this.serviceJspFile(httpServletRequest, httpServletResponse, string2, null, bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private void serviceJspFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable, boolean bl) throws ServletException, IOException {
        JspServletWrapper jspServletWrapper;
        block30: {
            Object object;
            String string2;
            boolean bl2 = throwable != null;
            String string3 = (String)this.context.getAttribute("com.iplanet.server.http.servlet.classpath");
            if (string3 == null || string3.equals("")) {
                string2 = "according to the init parameter";
                string3 = this.options.getClassPath();
            } else {
                string2 = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{string2, string3 == null ? "" : string3}, 3);
            JspEngineContext jspEngineContext = new JspEngineContext(this.loader, string3, this.context, string, bl2, this.options, httpServletRequest, httpServletResponse);
            jspServletWrapper = this.getWrapper(string);
            boolean bl3 = false;
            if (jspServletWrapper == null) {
                JspServlet jspServlet = this;
                synchronized (jspServlet) {
                    jspServletWrapper = this.getWrapper(string);
                    if (jspServletWrapper == null) {
                        object = jspEngineContext.getRealPath(jspEngineContext.getJspFile());
                        if (this.loadPrecompiledJsps || object != null) {
                            jspServletWrapper = new JspServletWrapper(string, (String)object, bl2);
                            jspServletWrapper.incrementRefCount();
                            this.jsps.put(string, jspServletWrapper);
                        } else {
                            try {
                                httpServletResponse.sendError(404);
                            }
                            catch (IllegalStateException illegalStateException) {}
                            Constants.message("jsp.error.file.not.found", new Object[]{jspEngineContext.getJspFile()}, 1);
                            bl3 = true;
                        }
                    }
                }
            }
            if (bl3) {
                return;
            }
            try {
                object = jspEngineContext.createCompiler();
                if (!jspServletWrapper.servletLoaded()) {
                    JspServletWrapper jspServletWrapper2 = jspServletWrapper;
                    synchronized (jspServletWrapper2) {
                        if (!jspServletWrapper.servletLoaded()) {
                            try {
                                jspServletWrapper.loadJSP(jspEngineContext, (Compiler)object);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                try {
                                    httpServletResponse.sendError(404);
                                }
                                catch (IllegalStateException illegalStateException) {}
                                Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{fileNotFoundException.getMessage()}), fileNotFoundException, 1);
                                bl3 = true;
                            }
                        }
                    }
                }
                if (!this.loadPrecompiledJsps && jspServletWrapper.isOutDated((Compiler)object, this.reloadInterval)) {
                    boolean bl4 = false;
                    if (jspServletWrapper.isValid()) {
                        JspServletWrapper jspServletWrapper3 = jspServletWrapper;
                        synchronized (jspServletWrapper3) {
                            if (jspServletWrapper.isValid()) {
                                jspServletWrapper.tryDestroy();
                                bl4 = true;
                            }
                        }
                    }
                    if (bl4) {
                        this.reloadJsps();
                    }
                }
                if (bl || bl3) break block30;
                jspServletWrapper.service(httpServletRequest, httpServletResponse);
            }
            catch (Throwable throwable2) {
                Object var13_20 = null;
                this.releaseWrapper(jspServletWrapper);
                jspServletWrapper = null;
                throw throwable2;
            }
        }
        Object var13_19 = null;
        this.releaseWrapper(jspServletWrapper);
        jspServletWrapper = null;
    }

    private void unloadJsps() {
        Enumeration enumeration = this.jsps.elements();
        while (enumeration.hasMoreElements()) {
            ((JspServletWrapper)enumeration.nextElement()).tryDestroy();
        }
        this.jsps.clear();
    }

    class JspServletWrapper {
        Servlet theServlet = null;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;
        int refCount = 0;
        boolean markedForDestroy = false;
        volatile long lastCheckedTime = 0L;
        File jspFile;

        JspServletWrapper(String string, String string2, boolean bl) {
            this.jspUri = string;
            this.isErrorPage = bl;
            if (!JspServlet.this.loadPrecompiledJsps) {
                this.jspFile = new File(string2);
            }
        }

        private synchronized void decrementRefCount() {
            --this.refCount;
            if (this.refCount == 0 && this.markedForDestroy) {
                this.destroy();
            }
        }

        private void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
                this.servletClass = null;
                this.theServlet = null;
            }
        }

        private synchronized void incrementRefCount() {
            ++this.refCount;
        }

        boolean isOutDated(Compiler compiler, long l) {
            boolean bl = false;
            if (!JspServlet.this.loadPrecompiledJsps) {
                if (l > 0L) {
                    long l2 = System.currentTimeMillis();
                    if (l2 > l + this.lastCheckedTime) {
                        long l3 = this.jspFile.lastModified();
                        if (l3 == 0L) {
                            compiler.removeGeneratedFiles();
                            bl = true;
                        } else if (l3 > this.lastCheckedTime) {
                            bl = true;
                        } else {
                            this.lastCheckedTime = System.currentTimeMillis();
                        }
                    }
                } else {
                    bl = compiler.isOutDated();
                }
            }
            return bl;
        }

        private boolean isValid() {
            return this.markedForDestroy ^ true;
        }

        private void loadAndInit(JspCompilationContext jspCompilationContext) throws JasperException, ServletException {
            JspMangler jspMangler = new JspMangler(jspCompilationContext.getJspFile(), jspCompilationContext.getOutputDir());
            String string = String.valueOf(jspMangler.getPackageName()) + "." + jspMangler.getClassName();
            try {
                this.servletClass = JspServlet.this.loader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Constants.message("jsp.warning.load_failure", new Object[]{string}, 2);
                throw new JasperException(Constants.getString("jsp.error.unable.load"), classNotFoundException);
            }
            Constants.message("jsp.debug.load_success", new Object[]{string}, 4);
            try {
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(exception);
            }
            this.theServlet.init(JspServlet.this.config);
            if (this.theServlet instanceof HttpJspBase) {
                HttpJspBase httpJspBase = (HttpJspBase)this.theServlet;
                httpJspBase.setClassLoader(JspServlet.this.parentClassLoader);
            }
        }

        private void loadJSP(JspCompilationContext jspCompilationContext, Compiler compiler) throws JasperException, FileNotFoundException, ServletException {
            if (JspServlet.this.loadPrecompiledJsps) {
                if (!this.servletLoaded()) {
                    try {
                        this.loadAndInit(jspCompilationContext);
                        return;
                    }
                    catch (JasperException jasperException) {}
                } else {
                    Constants.message("jsp.debug.precompiled.no_reload", 4);
                    return;
                }
            }
            try {
                compiler.compile();
                this.lastCheckedTime = System.currentTimeMillis();
                this.loadAndInit(jspCompilationContext);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (JasperException jasperException) {
                throw jasperException;
            }
            catch (Exception exception) {
                throw new JasperException(Constants.getString("jsp.error.unable.compile"), exception);
            }
        }

        private void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            if (this.theServlet instanceof SingleThreadModel) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
            } else {
                this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }

        private boolean servletLoaded() {
            return this.theServlet != null;
        }

        private void tryDestroy() {
            if (this.refCount == 0) {
                this.destroy();
            }
            this.markedForDestroy = true;
        }
    }
}

