/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    Document tld;
    Hashtable jarEntries;
    JspCompilationContext ctxt;

    public TagLibraryInfoImpl(JspCompilationContext jspCompilationContext, String string, String string2) throws IOException, JasperException {
        super(string, string2);
        Document document;
        Object object;
        this.ctxt = jspCompilationContext;
        InputStream inputStream = null;
        URL uRL = null;
        boolean bl = false;
        this.uri = string2;
        InputStream inputStream2 = this.getResourceAsStream(WEBAPP_INF);
        if (inputStream2 != null && (object = (document = JspUtil.parseXMLDoc(inputStream2, "/org/apache/jasper/resources/web.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN")).getElementsByTagName("taglib")).getLength() != 0) {
            int n = 0;
            while (n < object.getLength()) {
                String string3;
                String string4 = null;
                boolean bl2 = false;
                Element element = (Element)object.item(n);
                NodeList nodeList = element.getElementsByTagName("taglib-uri");
                Element element2 = (Element)nodeList.item(0);
                Text text = (Text)element2.getFirstChild();
                if (text != null && (string3 = text.getData()) != null && (string3 = string3.trim()).equals(string2)) {
                    bl2 = true;
                    NodeList nodeList2 = element.getElementsByTagName("taglib-location");
                    Element element3 = (Element)nodeList2.item(0);
                    Text text2 = (Text)element3.getFirstChild();
                    if (text2 != null && (string4 = text2.getData()) != null) {
                        string4 = string4.trim();
                    }
                }
                if (bl2 && string4 != null) {
                    this.uri = string4;
                    if (!this.uri.startsWith("/") && this.isRelativeURI(this.uri)) {
                        this.uri = "/WEB-INF/" + this.uri;
                    }
                }
                ++n;
            }
        }
        if (!this.uri.startsWith("/") && this.isRelativeURI(this.uri)) {
            this.uri = jspCompilationContext.resolveRelativeUri(this.uri);
        }
        if (!this.uri.endsWith("jar")) {
            inputStream = this.getResourceAsStream(this.uri);
            if (inputStream == null) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{this.uri}));
            }
            this.parseTLD(inputStream);
        }
        if (this.uri.endsWith("jar")) {
            if (!this.isRelativeURI(this.uri)) {
                uRL = new URL(this.uri);
                inputStream = uRL.openStream();
            } else {
                bl = true;
                inputStream = this.getResourceAsStream(this.uri);
            }
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            this.jarEntries = new Hashtable();
            this.ctxt = jspCompilationContext;
            boolean bl3 = false;
            while ((object = zipInputStream.getNextEntry()) != null) {
                ByteArrayOutputStream byteArrayOutputStream;
                if (((ZipEntry)object).getName().equals(TLD)) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    while (zipInputStream.available() != 0) {
                        int n = ((InflaterInputStream)zipInputStream).read();
                        if (n == -1) break;
                        byteArrayOutputStream.write(n);
                    }
                    byteArrayOutputStream.close();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    bl3 = true;
                    this.parseTLD(byteArrayInputStream);
                } else {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    while (zipInputStream.available() != 0) {
                        int n = ((InflaterInputStream)zipInputStream).read();
                        if (n == -1) break;
                        byteArrayOutputStream.write(n);
                    }
                    byteArrayOutputStream.close();
                    this.jarEntries.put(((ZipEntry)object).getName(), byteArrayOutputStream.toByteArray());
                }
                zipInputStream.closeEntry();
            }
            if (!bl3) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
        }
    }

    static void copy(InputStream inputStream, String string) throws IOException, FileNotFoundException {
        int n;
        byte[] byArray = new byte[1024];
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
    }

    TagAttributeInfo createAttribute(Element element) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Text text;
                Element element2 = (Element)node;
                String string3 = element2.getTagName();
                if (string3.equals("name")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string = text.getData().trim();
                    }
                } else if (string3.equals("required")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        bl = Boolean.valueOf(text.getData().trim());
                        if (text.getData().equalsIgnoreCase("yes")) {
                            bl = true;
                        }
                    }
                } else if (string3.equals("rtexprvalue")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        bl2 = Boolean.valueOf(text.getData().trim());
                        if (text.getData().equalsIgnoreCase("yes")) {
                            bl2 = true;
                        }
                    }
                } else if (string3.equals("type")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string2 = text.getData().trim();
                    }
                } else {
                    Constants.message("jsp.warning.unknown.element.in.attribute", new Object[]{element2.getTagName()}, 2);
                }
            }
            ++n;
        }
        return new TagAttributeInfo(string, bl, string2, bl2);
    }

    private TagInfo createTagInfo(Element element) throws JasperException {
        Object object;
        Element element2;
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "JSP";
        String string5 = null;
        Vector<TagAttributeInfo> vector = new Vector<TagAttributeInfo>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object2 = nodeList.item(n);
            if (object2 instanceof Element) {
                Text text;
                element2 = (Element)object2;
                object = element2.getTagName();
                if (((String)object).equals("name")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string = text.getData().trim();
                    }
                } else if (((String)object).equals("tagclass")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string2 = text.getData().trim();
                    }
                } else if (((String)object).equals("teiclass")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string3 = text.getData().trim();
                    }
                } else if (((String)object).equals("bodycontent")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string4 = text.getData().trim();
                    }
                } else if (((String)object).equals("info")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        string5 = text.getData().trim();
                    }
                } else if (((String)object).equals("attribute")) {
                    vector.addElement(this.createAttribute(element2));
                } else {
                    Constants.message("jsp.warning.unknown.element.in.tag", new Object[]{element2.getTagName()}, 2);
                }
            }
            ++n;
        }
        object2 = new TagAttributeInfo[vector.size()];
        vector.copyInto((Object[])object2);
        element2 = null;
        if (string3 != null && !string3.equals("")) {
            try {
                object = this.ctxt.getClassLoader().loadClass(string3);
                element2 = (TagExtraInfo)((Class)object).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{string3, classNotFoundException.getMessage()}, 2);
            }
            catch (IllegalAccessException illegalAccessException) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{string3, illegalAccessException.getMessage()}, 2);
            }
            catch (InstantiationException instantiationException) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{string3, instantiationException.getMessage()}, 2);
            }
        }
        object = new TagInfo(string, string2, string4, string5, (TagLibraryInfo)this, (TagExtraInfo)element2, object2);
        return object;
    }

    private InputStream getResourceAsStream(String string) throws FileNotFoundException {
        if (string.indexOf(":") > 0) {
            return this.ctxt.getResourceAsStream(string);
        }
        String string2 = this.ctxt.getRealPath(string);
        return string2 == null ? null : new FileInputStream(string2);
    }

    private boolean isRelativeURI(String string) {
        return string.indexOf(58) == -1;
    }

    private void parseTLD(InputStream inputStream) throws JasperException {
        this.tld = JspUtil.parseXMLDoc(inputStream, "/org/apache/jasper/resources/web-jsptaglib_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        Vector<TagInfo> vector = new Vector<TagInfo>();
        NodeList nodeList = this.tld.getElementsByTagName("taglib");
        if (nodeList.getLength() != 1) {
            throw new JasperException(Constants.getString("jsp.error.more.than.one.taglib"));
        }
        Element element = (Element)nodeList.item(0);
        nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Text text;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("tlibversion")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        this.tlibversion = text.getData().trim();
                    }
                } else if (string.equals("jspversion")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        this.jspversion = text.getData().trim();
                    }
                } else if (string.equals("shortname")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        this.shortname = text.getData().trim();
                    }
                } else if (string.equals("uri")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        this.urn = text.getData().trim();
                    }
                } else if (string.equals("info")) {
                    text = (Text)element2.getFirstChild();
                    if (text != null) {
                        this.info = text.getData().trim();
                    }
                } else if (string.equals("tag")) {
                    vector.addElement(this.createTagInfo(element2));
                } else {
                    Constants.message("jsp.warning.unknown.element.in.TLD", new Object[]{element2.getTagName()}, 2);
                }
            }
            ++n;
        }
        this.tags = new TagInfo[vector.size()];
        vector.copyInto(this.tags);
    }

    private final void print(String string, String string2, PrintWriter printWriter) {
        if (string2 != null) {
            printWriter.print(String.valueOf(string) + " = {\n\t");
            printWriter.print(string2);
            printWriter.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.print("tlibversion", this.tlibversion, printWriter);
        this.print("jspversion", this.jspversion, printWriter);
        this.print("shortname", this.shortname, printWriter);
        this.print("urn", this.urn, printWriter);
        this.print("info", this.info, printWriter);
        this.print("uri", this.uri, printWriter);
        int n = 0;
        while (n < this.tags.length) {
            printWriter.println(this.tags[n].toString());
            ++n;
        }
        return stringWriter.toString();
    }
}

