/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Stack;
import org.apache.jasper.compiler.JspReader;

public final class Mark {
    int cursor;
    int line;
    int col;
    int fileid;
    String fileName;
    String baseDir;
    char[] stream = null;
    Stack includeStack = null;
    String encoding = null;
    private JspReader reader;

    Mark(JspReader jspReader, char[] cArray, int n, String string, String string2, String string3) {
        this.reader = jspReader;
        this.stream = cArray;
        this.col = 0;
        this.line = 0;
        this.cursor = 0;
        this.fileid = n;
        this.fileName = string;
        this.baseDir = string2;
        this.encoding = string3;
        this.includeStack = new Stack();
    }

    Mark(Mark mark) {
        this.reader = mark.reader;
        this.stream = mark.stream;
        this.fileid = mark.fileid;
        this.fileName = mark.fileName;
        this.cursor = mark.cursor;
        this.line = mark.line;
        this.col = mark.col;
        this.baseDir = mark.baseDir;
        this.encoding = mark.encoding;
        this.includeStack = new Stack();
        int n = 0;
        while (n < mark.includeStack.size()) {
            this.includeStack.addElement(mark.includeStack.elementAt(n));
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Mark) {
            Mark mark = (Mark)object;
            return this.reader == mark.reader && this.fileid == mark.fileid && this.cursor == mark.cursor && this.line == mark.line && this.col == mark.col;
        }
        return false;
    }

    public String getFile() {
        return this.fileName;
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState includeState = (IncludeState)this.includeStack.pop();
        this.cursor = includeState.cursor;
        this.line = includeState.line;
        this.col = includeState.col;
        this.fileid = includeState.fileid;
        this.fileName = includeState.fileName;
        this.baseDir = includeState.baseDir;
        this.stream = includeState.stream;
        return true;
    }

    public void pushStream(char[] cArray, int n, String string, String string2, String string3) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileid, this.fileName, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.line = 0;
        this.col = 0;
        this.fileid = n;
        this.fileName = string;
        this.baseDir = string2;
        this.encoding = string3;
        this.stream = cArray;
    }

    public String toShortString() {
        return "(" + this.line + "," + this.col + ")";
    }

    public String toString() {
        return String.valueOf(this.getFile()) + "(" + this.line + "," + this.col + ")";
    }

    class IncludeState {
        int cursor;
        int line;
        int col;
        int fileid;
        String fileName;
        String baseDir;
        String encoding;
        char[] stream = null;

        IncludeState(int n, int n2, int n3, int n4, String string, String string2, String string3, char[] cArray) {
            this.cursor = n;
            this.line = n2;
            this.col = n3;
            this.fileid = n4;
            this.fileName = string;
            this.baseDir = string2;
            this.encoding = string3;
            this.stream = cArray;
        }
    }
}

