/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jasper.compiler.JavaCompiler;

public class JikesJavaCompiler
implements JavaCompiler {
    static final int OUTPUT_BUFFER_SIZE = 1024;
    static final int BUFFER_SIZE = 512;
    String encoding;
    String classpath;
    String compilerPath = "jikes";
    String outdir;
    OutputStream out;
    boolean classDebugInfo = false;

    public boolean compile(String string) {
        boolean bl;
        int n = -1;
        String[] stringArray = this.classDebugInfo ? new String[]{this.compilerPath, "-g", "-classpath", this.classpath, "-d", this.outdir, "-nowarn", string} : new String[]{this.compilerPath, "-classpath", this.classpath, "-d", this.outdir, "-nowarn", string};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
            StreamPumper streamPumper = new StreamPumper(bufferedInputStream, byteArrayOutputStream);
            streamPumper.start();
            process.waitFor();
            n = process.exitValue();
            streamPumper.join();
            bufferedInputStream.close();
            process.destroy();
            byteArrayOutputStream.close();
            byteArrayOutputStream.writeTo(this.out);
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        boolean bl2 = bl = n == 0;
        if (byteArrayOutputStream.size() > 0) {
            bl = false;
        }
        return bl;
    }

    public void setClassDebugInfo(boolean bl) {
        this.classDebugInfo = bl;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setCompilerPath(String string) {
        this.compilerPath = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMsgOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setOutputDir(String string) {
        this.outdir = string;
    }

    class StreamPumper
    extends Thread {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private boolean stopSignal = false;
        private int SLEEP_TIME = 5;
        private OutputStream out;

        public StreamPumper(BufferedInputStream bufferedInputStream, OutputStream outputStream) {
            this.stream = bufferedInputStream;
            this.out = outputStream;
        }

        public void pumpStream() throws IOException {
            byte[] byArray = new byte[512];
            if (!this.endOfStream) {
                int n = this.stream.read(byArray, 0, 512);
                if (n > 0) {
                    this.out.write(byArray, 0, n);
                } else if (n == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    Thread.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {}
        }
    }
}

