/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.ArrowIcon;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ISpinListener;
import com.netscape.management.client.util.SpinEvent;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class SpinControl
extends JPanel
implements SuiConstants,
ActionListener {
    JComponent parent;
    Vector spinListeners = new Vector();
    JButton upButton;
    JButton downButton;

    public SpinControl(JComponent jComponent) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.upButton = new SpinUpButton();
        this.upButton.addActionListener(this);
        this.downButton = new SpinDownButton();
        this.downButton.addActionListener(this);
        this.downButton.setMargin(new Insets(1, 4, 1, 4));
        GridBagUtil.constrain(this, this.upButton, 0, 0, 1, 1, 0.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(this, this.downButton, 0, 1, 1, 1, 0.0, 0.0, 18, 2, 0, 0, 0, 0);
    }

    public void setToolTipText(String string) {
        this.upButton.setToolTipText(string);
        this.downButton.setToolTipText(string);
    }

    public void addSpinListener(ISpinListener iSpinListener) {
        this.spinListeners.addElement(iSpinListener);
    }

    public void removeSpinListener(ISpinListener iSpinListener) {
        this.spinListeners.removeElement(iSpinListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = actionEvent.getSource() instanceof SpinUpButton;
        Enumeration enumeration = this.spinListeners.elements();
        while (enumeration.hasMoreElements()) {
            ISpinListener iSpinListener = (ISpinListener)enumeration.nextElement();
            if (bl) {
                iSpinListener.actionUp(new SpinEvent(this));
                continue;
            }
            iSpinListener.actionDown(new SpinEvent(this));
        }
    }

    class SpinDownButton
    extends SpinButton {
        public SpinDownButton() {
            super(5);
        }
    }

    class SpinUpButton
    extends SpinButton {
        public SpinUpButton() {
            super(1);
        }
    }

    class SpinButton
    extends JButton {
        public SpinButton(int n) {
            super(new ArrowIcon(n));
            this.setMargin(new Insets(1, 4, 1, 4));
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

