/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class JSS3SocketFactory
implements Serializable,
LDAPSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736902L;
    private static boolean initialized = false;

    public JSS3SocketFactory() throws LDAPException {
        if (!initialized) {
            JSS3SocketFactory.initialize(".");
        }
    }

    public static void initialize(String string) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSS3SocketFactory is already initialized", 80);
        }
        try {
            initialized = true;
            CryptoManager.initialize((String)string);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSS3SocketFactory: " + exception.getMessage(), 80);
        }
    }

    public static void initialize(String string, String string2, String string3, String string4) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSS3SocketFactory is already initialized", 80);
        }
        try {
            initialized = true;
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string, string2, string3, string4);
            CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSS3SocketFactory: " + exception.getMessage(), 80);
        }
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(InetAddress.getByName(string), n, null, 0, true, (SSLCertificateApprovalCallback)this, null);
            sSLSocket.forceHandshake();
        }
        catch (Exception exception) {
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + exception.getMessage(), 91);
        }
        return sSLSocket;
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        return true;
    }
}

