/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertInstallWizard;
import com.netscape.management.client.security.CertRequestWizard;
import com.netscape.management.client.security.CertificateDetailDialog;
import com.netscape.management.client.security.CertificateDialog;
import com.netscape.management.client.security.CertificateListPane;
import com.netscape.management.client.security.KeyCertUtility;
import com.netscape.management.client.security.ListTableModel;
import com.netscape.management.client.util.Debug;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

class ServerCertificatePane
extends CertificateListPane {
    Table serverCertTable;
    ListTableModel tableModel;
    Vector certs;
    String _sie;
    String _tokenName;
    ConsoleInfo _consoleInfo;
    CertificateDialog _certDialog;
    Frame parent;

    public void setTokenName(String string) {
        this._tokenName = string;
    }

    public ServerCertificatePane(Vector vector, ConsoleInfo consoleInfo, String string, String string2, CertificateDialog certificateDialog) {
        this._certDialog = certificateDialog;
        this.certs = vector;
        this._sie = string;
        this._tokenName = string2;
        this._consoleInfo = consoleInfo;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(this.resource.getString("ServerCertificatePane", "nameLabel"));
        vector2.addElement(this.resource.getString("ServerCertificatePane", "issuedToLabel"));
        vector2.addElement(this.resource.getString("ServerCertificatePane", "issuedByLabel"));
        vector2.addElement(this.resource.getString("ServerCertificatePane", "expiredByLabel"));
        this.tableModel = new ListTableModel(vector2, null);
        this.setCertData(vector);
        this.serverCertTable = new Table((TableModel)this.tableModel, true);
        this.serverCertTable.getSelectionModel().setSelectionMode(0);
        this.setContent(this.serverCertTable, this.resource.getString("ServerCertificatePane", "tableTitle"), CertificateListPane.REQUEST | CertificateListPane.RENEW | CertificateListPane.INSTALL);
        this.serverCertTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ServerCertificatePane.this.serverCertTable.getSelectedRow();
                if (n != -1) {
                    ServerCertificatePane.this.detail.setEnabled(true);
                    ServerCertificatePane.this.renew.setEnabled(true);
                    ServerCertificatePane.this.delete.setEnabled(true);
                }
            }
        });
        this.detail.setEnabled(false);
        this.renew.setEnabled(false);
        this.delete.setEnabled(false);
    }

    public void setParentFrame(Frame frame) {
        Debug.println(6, "ServerCertificatePane.setParent: parent = " + frame);
        this.parent = frame;
    }

    public Frame getParentFrame() {
        return this.parent;
    }

    public void setCertData(Vector vector) {
        Vector vector2 = new Vector();
        int n = vector.size() - 1;
        while (n >= 0) {
            Vector vector3 = new Vector();
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            vector3.addElement(hashtable.get("NICKNAME"));
            vector3.addElement(((Hashtable)hashtable.get("SUBJECT")).get("CN"));
            vector3.addElement(((Hashtable)hashtable.get("ISSUER")).get("CN"));
            vector3.addElement(hashtable.get("AFTERDATE"));
            vector2.addElement(vector3);
            --n;
        }
        this.tableModel.setRowData(vector2);
        if (this.serverCertTable != null) {
            this.serverCertTable.setModel(this.tableModel);
        }
        this.paintAll(this.getGraphics());
    }

    public void detailInvoked() {
        String string = this.getSelectedCertNickname(this.serverCertTable, this.resource.getString("ServerCertificatePane", "nameLabel"));
        if (string.length() != 0) {
            CertificateDetailDialog certificateDetailDialog = new CertificateDetailDialog(null, this._consoleInfo, this._sie, string);
        }
    }

    public void requestInvoked() {
        CertRequestWizard certRequestWizard = new CertRequestWizard(this.getParentFrame(), this._consoleInfo, this._sie, this._tokenName);
        certRequestWizard.setVisible(true);
    }

    public void renewInvoked() {
        CertRequestWizard certRequestWizard = new CertRequestWizard(this.getParentFrame(), this._consoleInfo, this._sie, this._tokenName);
        certRequestWizard.setVisible(true);
    }

    public void installInvoked() {
        CertInstallWizard certInstallWizard = new CertInstallWizard(this.getParentFrame(), this._consoleInfo, this._sie, this._tokenName, CertInstallWizard.SERVER);
        certInstallWizard.setVisible(true);
        this._certDialog.refresh();
    }

    public void deleteInvoked() {
        String string = this.getSelectedCertNickname(this.serverCertTable, this.resource.getString("ServerCertificatePane", "nameLabel"));
        if (string.length() != 0 && this.confirmDeleteDialog(string) && KeyCertUtility.deleteCert(this, this._consoleInfo, this._sie, string)) {
            this.tableModel.deleteRow(string);
            this.serverCertTable.clearSelection();
            this.serverCertTable.repaint();
        }
    }

    public void helpInvoked() {
        this.help.contextHelp("ServerCertificatePane", "help");
    }
}

