/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.preferences.IPreferencesTab;
import com.netscape.management.client.util.ResourceSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesDialog
extends GenericDialog {
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.preferences.preferences");
    private JFrame parentFrame = null;
    private Vector tabsVector = new Vector();
    private JTabbedPane tabbedPane = null;
    private ChangeListener tabChangeListener = null;

    static String i18n(String string) {
        return resource.getString("dialog", string);
    }

    public PreferencesDialog(JFrame jFrame, IPreferencesTab[] iPreferencesTabArray) {
        super(jFrame, PreferencesDialog.i18n("title"), 11, 0);
        this.parentFrame = jFrame;
        this.tabbedPane = this.createDialogPanel(iPreferencesTabArray);
        this.getContentPane().add(this.tabbedPane);
        this.setMinimumSize(this.getPreferredSize());
    }

    private JTabbedPane createDialogPanel(IPreferencesTab[] iPreferencesTabArray) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        int n = 0;
        while (n < iPreferencesTabArray.length) {
            iPreferencesTabArray[n].initialize(this.parentFrame);
            jTabbedPane.addTab(iPreferencesTabArray[n].getTitle(), iPreferencesTabArray[n].getComponent());
            this.tabsVector.addElement(iPreferencesTabArray[n]);
            ++n;
        }
        this.tabChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                IPreferencesTab iPreferencesTab = (IPreferencesTab)PreferencesDialog.this.tabsVector.elementAt(n);
                iPreferencesTab.tabSelected();
            }
        };
        jTabbedPane.addChangeListener(this.tabChangeListener);
        iPreferencesTabArray[0].tabSelected();
        return jTabbedPane;
    }

    protected void okInvoked() {
        Enumeration enumeration = this.tabsVector.elements();
        while (enumeration.hasMoreElements()) {
            IPreferencesTab iPreferencesTab = (IPreferencesTab)enumeration.nextElement();
            iPreferencesTab.okInvoked();
        }
        this.tabbedPane.removeChangeListener(this.tabChangeListener);
        super.okInvoked();
    }

    protected void cancelInvoked() {
        Enumeration enumeration = this.tabsVector.elements();
        while (enumeration.hasMoreElements()) {
            IPreferencesTab iPreferencesTab = (IPreferencesTab)enumeration.nextElement();
            iPreferencesTab.cancelInvoked();
        }
        this.tabbedPane.removeChangeListener(this.tabChangeListener);
        super.cancelInvoked();
    }

    protected void helpInvoked() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0) {
            ((IPreferencesTab)this.tabsVector.elementAt(n)).helpInvoked();
        }
    }
}

