/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Preferences
extends Properties {
    private boolean _isLoaded = false;
    private boolean _isDirty = false;

    public String toString() {
        if (!this._isLoaded) {
            this.load();
        }
        return super.toString();
    }

    public String getString(String string) {
        if (!this._isLoaded) {
            this.load();
        }
        return (String)super.get(string);
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public int getInt(String string) throws NumberFormatException {
        String string2 = this.getString(string);
        try {
            Integer n = Integer.valueOf(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(string + "=" + string2);
        }
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string);
        if (string2 != null) {
            try {
                Integer n2 = Integer.valueOf(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.getString(string);
        if (string2 != null) {
            Boolean bl3 = Boolean.valueOf(string2);
            bl2 = bl3;
        }
        return bl2;
    }

    public void set(String string, String string2) {
        ((Hashtable)this).put(string, string2);
        this._isDirty = true;
    }

    public void set(String string, int n) {
        ((Hashtable)this).put(string, String.valueOf(n));
        this._isDirty = true;
    }

    public void set(String string, boolean bl) {
        ((Hashtable)this).put(string, String.valueOf(bl));
        this._isDirty = true;
    }

    public Enumeration getNames() {
        if (!this._isLoaded) {
            this.load();
        }
        return this.propertyNames();
    }

    public synchronized void load() {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            try {
                this.load(inputStream);
                this._isLoaded = true;
            }
            catch (IOException iOException) {
                Debug.println("Cannot load preferences: " + iOException);
            }
        }
    }

    public synchronized void save() {
        if (!this._isDirty) {
            return;
        }
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            this.save(outputStream, "");
            try {
                outputStream.flush();
                this._isDirty = false;
            }
            catch (IOException iOException) {
                Debug.println("Cannot save preferences: " + iOException);
            }
        }
    }

    public void clear() {
        super.clear();
        this._isDirty = true;
    }

    public abstract void delete();

    public boolean isEmpty() {
        if (!this._isLoaded) {
            this.load();
        }
        return super.isEmpty();
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    protected abstract InputStream getInputStream();

    protected abstract OutputStream getOutputStream();
}

