/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.preferences.IPreferencesTab;
import com.netscape.management.client.preferences.PreferencesDialog;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractPreferencesTab
implements IPreferencesTab,
UIConstants {
    private static ImageIcon warningIcon = new RemoteImage("com/netscape/management/client/images/warn16.gif");
    private String title = "TODO: setTitle";
    private JComponent tabComponent = null;
    private JComponent restartComponent = null;
    private Vector changeListeners = null;
    private boolean isCancelEnabled = true;
    private boolean isRestartRequired = true;
    private JFrame parentFrame = null;
    protected static int DEFAULT_WIDTH = 350;
    protected static int DEFAULT_HEIGHT = 280;

    public void initialize(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.tabComponent = null;
    }

    protected JFrame getFrame() {
        return this.parentFrame;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public JComponent getComponent() {
        if (this.tabComponent == null) {
            this.tabComponent = this.createTabComponent();
        }
        return this.tabComponent;
    }

    private JComponent createTabComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.restartComponent = new JLabel(PreferencesDialog.i18n("restart"), warningIcon, 2);
        this.restartComponent.setMinimumSize(this.restartComponent.getPreferredSize());
        this.restartComponent.setVisible(this.isRestartRequired);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.restartComponent, gridBagConstraints);
        jPanel.add(this.restartComponent);
        int n = DEFAULT_WIDTH + 18;
        int n2 = DEFAULT_HEIGHT + 18;
        jPanel.setPreferredSize(new Dimension(n, n2));
        return jPanel;
    }

    public void setComponent(JComponent jComponent) {
        if (this.tabComponent == null) {
            this.tabComponent = this.createTabComponent();
        }
        GridBagLayout gridBagLayout = (GridBagLayout)this.tabComponent.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.tabComponent.add(jComponent);
    }

    public boolean isRestartRequired() {
        return this.isRestartRequired;
    }

    public void setRestartRequired(boolean bl) {
        this.isRestartRequired = bl;
        if (this.restartComponent != null) {
            this.restartComponent.setVisible(this.isRestartRequired);
        }
    }

    public void tabSelected() {
    }

    public abstract void helpInvoked();

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        this.changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.removeElement(changeListener);
        }
    }

    public boolean isCancelEnabled() {
        return this.isCancelEnabled;
    }

    public void setCancelEnabled(boolean bl) {
        this.isCancelEnabled = bl;
        this.fireStateChanged();
    }

    public void fireStateChanged() {
        if (this.changeListeners != null) {
            Enumeration enumeration = this.changeListeners.elements();
            while (enumeration.hasMoreElements()) {
                ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

