/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.legacy;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.legacy.ContentHandler;
import com.netscape.management.client.legacy.LegacyUrlDlg;
import com.netscape.management.client.legacy.ListElement;
import com.netscape.management.client.legacy.ServerSelectionDlg;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JDialog;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LegacyServer {
    private ConsoleInfo _ldapInf = null;
    private String _LDAPusername;
    private String _LDAPpassword;
    private String _hostname;
    private String _port;
    private String _baseDN;
    private String _orgUnit;
    private String _adminUrlStr;
    private String _serverVersion;
    private Vector sList;
    private static final String PLUGINNAME = "com.netscape.management.client.legacy.plugin.LegacyPlugin";
    private static final String PLUGIN_REG_DN_1 = "cn=4.0,cn=Netscape Admin Server, cn=Global Configuration";
    private static final String ROOT_DN = "o=NetscapeRoot";
    private String ISIE_ROOT_DN = null;
    private int _error = 0;
    private boolean secure;
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.legacy.default");
    LDAPConnection ldc;

    public LegacyServer(ConsoleInfo consoleInfo) {
        Object object;
        this._ldapInf = consoleInfo;
        URL uRL = null;
        this._LDAPusername = new String(consoleInfo.getAuthenticationDN());
        this._LDAPpassword = new String(consoleInfo.getAuthenticationPassword());
        this._baseDN = new String(consoleInfo.getBaseDN());
        this.ldc = consoleInfo.getLDAPConnection();
        ContentHandler contentHandler = null;
        Vector vector = this.getNetscapeGroups(this._ldapInf);
        LegacyUrlDlg legacyUrlDlg = new LegacyUrlDlg(this._ldapInf.getFrame(), vector);
        while (true) {
            this._error = 0;
            legacyUrlDlg.show();
            ModalDialogUtil.sleep();
            if (legacyUrlDlg.isCancel()) {
                this._error = 1;
                Debug.println("User requested Cancel operation.");
                break;
            }
            object = legacyUrlDlg.getAdminURL();
            int n = ((String)object).indexOf("://", 1);
            n = n == -1 ? 1 : (n += 3);
            if (((String)object).indexOf("/", n) < 0) {
                object = (String)object + "/";
            }
            try {
                uRL = new URL((String)object + "admin-serv/bin/index?load");
            }
            catch (MalformedURLException malformedURLException) {
                SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "invalidURL"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                legacyUrlDlg.setAdminURL("");
                continue;
            }
            this._adminUrlStr = object;
            if (!this.isCompleteHostName((String)object)) {
                SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "incompleteHost"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                legacyUrlDlg.setAdminURL("");
                continue;
            }
            Debug.println("About to launch Content Handler.");
            Debug.println(uRL.toString());
            contentHandler = new ContentHandler(uRL, legacyUrlDlg.getUsername(), legacyUrlDlg.getPassword());
            this._error = contentHandler.getContent();
            if (this._error == -1) {
                SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "internalErr"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                break;
            }
            if (this._error == -4) {
                SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "unknownHost"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                continue;
            }
            if (this._error == -5) {
                SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)(this._resource.getString("error", "serverDown1") + " " + (String)object + " " + this._resource.getString("error", "serverDown2")), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                continue;
            }
            this._error = contentHandler.getStatus();
            switch (this._error) {
                case -6: {
                    SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "badPassword"), (String)this._resource.getString("error", "title"), (int)0);
                    ModalDialogUtil.sleep();
                    legacyUrlDlg.setPasswordField("");
                    break;
                }
                case -3: {
                    SuiOptionPane.showMessageDialog((Component)legacyUrlDlg, (Object)this._resource.getString("error", "notAdmin"), (String)this._resource.getString("error", "title"), (int)0);
                    ModalDialogUtil.sleep();
                }
            }
            if (this._error == 0) break;
        }
        if (this._error == 0) {
            this._serverVersion = contentHandler.getServerVersion();
            this.setHostnPortName(legacyUrlDlg.getAdminURL());
            this._orgUnit = legacyUrlDlg.getOrgUnit();
            this.ISIE_ROOT_DN = "ou=" + legacyUrlDlg.getOrgUnit() + "," + ROOT_DN;
            this.printServerList(contentHandler.getServerList());
            if (contentHandler.getServerList().size() == 0) {
                this.sList = contentHandler.getServerList();
                return;
            }
            object = new ServerSelectionDlg(this._ldapInf.getFrame(), contentHandler.getServerList());
            ((Component)object).setLocation(new Point(370, 470));
            ((AbstractDialog)object).show();
            ModalDialogUtil.sleep();
            if (((ServerSelectionDlg)object).isCancel()) {
                this._error = 1;
                return;
            }
            this.sList = ((ServerSelectionDlg)object).getServerList();
            this.printServerList(this.sList);
            ModalDialogUtil.dispose((JDialog)object);
        }
        ModalDialogUtil.dispose(legacyUrlDlg);
    }

    private boolean isCompleteHostName(String string) {
        int n = string.indexOf("://", 1);
        n = n == -1 ? 1 : (n += 3);
        int n2 = string.indexOf(".", n);
        Debug.print("DotPos = ");
        Debug.println(n2);
        if (n2 < 0) {
            return false;
        }
        int n3 = string.indexOf(":", n);
        return n3 != -1 && n3 >= n2;
    }

    private void setHostnPortName(String string) {
        this.secure = string.startsWith("https://", 0);
        int n = string.indexOf("://", 1);
        n = n < 0 ? 0 : (n += 3);
        Debug.println(n);
        Debug.println(string);
        int n2 = string.indexOf(":", n) + 1;
        Debug.print("StartPort = ");
        Debug.println(n2);
        this._hostname = new String(string.substring(n, n2 - 1));
        Debug.println(this._hostname);
        Debug.println(string.indexOf("/", n2));
        if (string.indexOf("/", n2) < 0) {
            string = string + "/";
        }
        this._port = new String(string.substring(n2, string.indexOf("/", n2)));
        Debug.println(this._port);
    }

    private String reverseBackslashes(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                stringBuffer.setCharAt(n, '/');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getNickname(String string) {
        if (string.equals("Administration")) {
            return "admin";
        }
        if (string.equals("Enterprise")) {
            return "https";
        }
        if (string.equals("FastTrack")) {
            return "httpd";
        }
        if (string.equals("Mail")) {
            return "mail";
        }
        if (string.equals("News")) {
            return "news";
        }
        if (string.equals("Proxy")) {
            return "proxy";
        }
        if (string.equals("Media")) {
            return "lmspd";
        }
        if (string.equals("Directory")) {
            return "slapd";
        }
        if (string.equals("Certificate")) {
            return "cms";
        }
        if (string.equals("Compass")) {
            return "compass";
        }
        if (string.equals("Catalog")) {
            return "catalog";
        }
        if (string.equals("Rds")) {
            return "rds";
        }
        if (string.equals("Calendar")) {
            return "calendar";
        }
        return new String("ERROR");
    }

    private Vector getNetscapeGroups(ConsoleInfo consoleInfo) {
        Vector<String> vector = new Vector<String>();
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchConstraints lDAPSearchConstraints = this.ldc.getSearchConstraints();
        String string = "(objectclass=nsAdminDomain)";
        try {
            lDAPSearchResults = this.ldc.search(ROOT_DN, 1, string, null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println("LDAPException: 14..return code:" + n);
            this.error(this._resource.getString("error", "title"), this._resource.getString("error", "ldapException") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
            this._error = -7;
        }
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPAttribute lDAPAttribute;
            try {
                lDAPAttribute = lDAPSearchResults.next().getAttribute("nsadmindomainname");
            }
            catch (Exception exception) {
                continue;
            }
            Enumeration enumeration = lDAPAttribute.getStringValues();
            try {
                vector.addElement((String)enumeration.nextElement());
            }
            catch (NoSuchElementException noSuchElementException) {
                Debug.println("Error: No value for attribute 'ou' set in ldapentry.");
                break;
            }
            if (!enumeration.hasMoreElements()) continue;
            Debug.println("Warning: Multivalued attribute for ou. Only one value used");
        }
        return vector;
    }

    private String getGroupACI(String string, String string2) {
        String string3 = new String("(targetattr=*)" + string + "(version 3.0;acl \"Enable delegated access\"; allow(read,search,compare) groupdn=\"ldap:///" + string2 + "\";)");
        Debug.println(string3);
        return string3;
    }

    private void addUniqueMember(String string, String string2) {
        block2: {
            int n = 0;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            LDAPAttribute lDAPAttribute = new LDAPAttribute("uniquemember", string);
            lDAPModificationSet.add(0, lDAPAttribute);
            try {
                this.ldc.modify(string2, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: 51..return code:" + n);
                this._error = -7;
                if (n != 50) break block2;
                SuiOptionPane.showMessageDialog((Component)this._ldapInf.getFrame(), (Object)this._resource.getString("error", "writeError"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
            }
        }
    }

    private int ldapAdd(LDAPEntry lDAPEntry) {
        int n;
        block2: {
            n = 0;
            try {
                this.ldc.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: 1..return code:" + n);
                this._error = -7;
                if (n != 50) break block2;
                SuiOptionPane.showMessageDialog((Component)this._ldapInf.getFrame(), (Object)this._resource.getString("error", "writeError"), (String)this._resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
            }
        }
        return n;
    }

    public int registerInDir() {
        if (this._error != 0) {
            if (this._error != 1) {
                this.error(this._resource.getString("error", "title"), this._resource.getString("error", "initFailed"));
            }
            return -1;
        }
        String string = this.createISIE("Netscape Administration Server", "admin");
        if (string == null) {
            return -1;
        }
        this.createSIE("serv", "admin", string);
        if (this.sList.size() == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.sList.size()) {
            if (((ListElement)this.sList.elementAt((int)n)).sInstList.size() != 0) {
                String string2;
                String string3 = new String(((ListElement)this.sList.elementAt(n)).getType());
                String string4 = new String("Netscape " + string3 + " Server");
                string = this.createISIE(string4, string2 = new String(this.getNickname(string3)));
                if (string == null) {
                    return -1;
                }
                int n2 = 0;
                while (n2 < ((ListElement)this.sList.elementAt((int)n)).sInstList.size()) {
                    this.createSIE((String)((ListElement)this.sList.elementAt((int)n)).sInstList.elementAt(n2), string2, string);
                    ++n2;
                }
            }
            ++n;
        }
        if (this._error == 0) {
            SuiOptionPane.showMessageDialog((Component)UtilConsoleGlobals.getActivatedFrame(), (Object)this._resource.getString("legacy", "success"), (String)this._resource.getString("legacy", "title"), (int)1);
            ModalDialogUtil.sleep();
        }
        return 0;
    }

    private void error(String string, String string2) {
        SuiOptionPane.showMessageDialog((Component)UtilConsoleGlobals.getActivatedFrame(), (Object)string2, (String)string, (int)0);
        ModalDialogUtil.sleep();
    }

    private String createISIE(String string, String string2) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        Object object;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        String string5 = null;
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchConstraints lDAPSearchConstraints = this.ldc.getSearchConstraints();
        string3 = "(&(objectclass=nsHost)(cn=" + this._hostname + "))";
        try {
            lDAPSearchResults = this.ldc.search(this.ISIE_ROOT_DN, 2, string3, null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n2 = lDAPException.getLDAPResultCode();
            this.error(this._resource.getString("error", "title"), this._resource.getString("error", "hostSearchEX1") + this._hostname + this._resource.getString("error", "hostSearchEX2") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
            this._error = -7;
            return null;
        }
        String string6 = new String("cn=" + this._hostname + "," + this.ISIE_ROOT_DN);
        if (!lDAPSearchResults.hasMoreElements()) {
            object = new LDAPAttributeSet();
            object.add(new LDAPAttribute("objectclass", "top"));
            object.add(new LDAPAttribute("objectclass", "nsHost"));
            object.add(new LDAPAttribute("objectclass", "groupofuniquenames"));
            object.add(new LDAPAttribute("cn", this._hostname));
            object.add(new LDAPAttribute("serverHostName", this._hostname));
            object.add(new LDAPAttribute("nsOsVersion", "unknown"));
            object.add(new LDAPAttribute("nsHardwarePlatform", "unknown"));
            if (!LDAPUtil.isVersion4(this.ldc)) {
                object.add(new LDAPAttribute("aci", this.getGroupACI("(targetfilter=(nsHardwarePlatform=*))", string6)));
            }
            LDAPEntry lDAPEntry = new LDAPEntry(string6, object);
            this.ldapAdd(lDAPEntry);
        }
        string3 = "(&(objectclass=nsLegacyAdminGroup)(adminUrl=" + this._adminUrlStr + "))";
        Debug.println(string3);
        lDAPSearchResults = null;
        try {
            lDAPSearchResults = this.ldc.search(string6, 1, string3, null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n3 = lDAPException.getLDAPResultCode();
            this.error(this._resource.getString("error", "title"), this._resource.getString("error", "serverGpSearcEX1") + this._adminUrlStr + this._resource.getString("error", "serverGpSearcEX2") + this._hostname + this._resource.getString("error", "serverGpSearcEX3") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
            this._error = -7;
        }
        if (!lDAPSearchResults.hasMoreElements()) {
            Debug.println("Couldnot find an entry for filter = " + string3);
            bl = true;
            n = 1;
            while (true) {
                string4 = new String("Server Group " + this._serverVersion + " (" + String.valueOf(n) + ")");
                string3 = new String("&(objectclass=nsLegacyAdminGroup)(cn=" + string4 + ")");
                try {
                    lDAPSearchResults = this.ldc.search(string6, 1, string3, null, false, lDAPSearchConstraints);
                }
                catch (LDAPException lDAPException) {
                    int n4 = lDAPException.getLDAPResultCode();
                    this.error(this._resource.getString("error", "title"), this._resource.getString("error", "ldapException") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
                    this._error = -7;
                }
                if (!lDAPSearchResults.hasMoreElements()) break;
                ++n;
            }
            string5 = new String("cn=" + string4 + "," + string6);
            Debug.println(string5);
            object = new LDAPAttributeSet();
            object.add(new LDAPAttribute("objectclass", "top"));
            object.add(new LDAPAttribute("objectclass", "groupofuniquenames"));
            object.add(new LDAPAttribute("objectclass", "nsLegacyAdminGroup"));
            object.add(new LDAPAttribute("cn", string4));
            object.add(new LDAPAttribute("nsAdminGroupName", string4));
            object.add(new LDAPAttribute("adminUrl", this._adminUrlStr));
            if (!LDAPUtil.isVersion4(this.ldc)) {
                object.add(new LDAPAttribute("aci", this.getGroupACI("(targetfilter=(adminUrl=*))", string5)));
            }
            lDAPAttribute = new LDAPEntry(string5, object);
            this.ldapAdd((LDAPEntry)lDAPAttribute);
            this.addUniqueMember(string5, string6);
        } else {
            object = null;
            try {
                lDAPAttribute = lDAPSearchResults.next().getAttribute("cn");
                enumeration = lDAPAttribute.getStringValues();
                object = (String)enumeration.nextElement();
            }
            catch (LDAPException lDAPException) {
                int n5 = lDAPException.getLDAPResultCode();
                this.error(this._resource.getString("error", "title"), this._resource.getString("error", "ldapException") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
                this._error = -7;
            }
            string5 = new String("cn=" + (String)object + "," + string6);
            Debug.println(string5);
            if (lDAPSearchResults.hasMoreElements()) {
                Debug.println("ERROR : Search for Admin Group with specified adminURL yielded more than one entry.");
            }
        }
        object = new String("cn=" + string + "," + string5);
        Debug.println(string5);
        if (!bl) {
            string3 = "(&(objectclass=nsLegacyApplication)(cn=" + string + "))";
            Debug.println("myFilter = " + string3);
            Debug.println("AdminGroupDN = " + string5);
            try {
                lDAPSearchResults = this.ldc.search(string5, 1, string3, null, false, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                int n6 = lDAPException.getLDAPResultCode();
                this.error(this._resource.getString("error", "title"), this._resource.getString("error", "ldapException") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
                this._error = -7;
            }
            if (lDAPSearchResults.hasMoreElements()) {
                bl2 = false;
            }
        }
        if (bl2) {
            lDAPAttribute = new LDAPAttributeSet();
            lDAPAttribute.add(new LDAPAttribute("cn", string));
            lDAPAttribute.add(new LDAPAttribute("objectclass", "top"));
            lDAPAttribute.add(new LDAPAttribute("objectclass", "groupofuniquenames"));
            lDAPAttribute.add(new LDAPAttribute("objectclass", "nsLegacyApplication"));
            lDAPAttribute.add(new LDAPAttribute("nsProductName", string));
            lDAPAttribute.add(new LDAPAttribute("nsNickName", string2));
            if (!LDAPUtil.isVersion4(this.ldc)) {
                lDAPAttribute.add(new LDAPAttribute("aci", this.getGroupACI("nsNickName", (String)object)));
            }
            enumeration = new LDAPEntry((String)object, (LDAPAttributeSet)lDAPAttribute);
            this.ldapAdd((LDAPEntry)enumeration);
            this.addUniqueMember((String)object, string5);
        }
        return object;
    }

    private void createSIE(String string, String string2, String string3) {
        String string4 = null;
        String string5 = new String("");
        boolean bl = false;
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchConstraints lDAPSearchConstraints = this.ldc.getSearchConstraints();
        string4 = "(&(objectclass=nsLegacyServer)(nsServerID=" + string2 + "-" + string + "))";
        try {
            lDAPSearchResults = this.ldc.search(string3, 1, string4, null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            this.error(this._resource.getString("error", "title"), this._resource.getString("error", "ldapException") + lDAPException.errorCodeToString() + this._resource.getString("error", "ldapEXredo"));
            this._error = -7;
        }
        if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
            this.error(this._resource.getString("error", "title"), string2 + "-" + string + " : " + this._resource.getString("error", "SIEentryExists"));
            this._error = -7;
            return;
        }
        String string6 = new String(string2 + "-" + string);
        String string7 = new String("cn=" + string6 + "," + string3);
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("cn", string6));
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "top"));
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsLegacyServer"));
        if (string2.equals("admin")) {
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsLegacyAdminServer"));
        }
        lDAPAttributeSet.add(new LDAPAttribute("nsServerID", string2 + "-" + string));
        lDAPAttributeSet.add(new LDAPAttribute("serverProductName", string6));
        lDAPAttributeSet.add(new LDAPAttribute("serverHostName", this._hostname));
        lDAPAttributeSet.add(new LDAPAttribute("URL", (this.secure ? "https://" : "http://") + this._hostname + ":" + this._port + "/" + string2 + "-" + string + "/bin/index"));
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "groupofuniquenames"));
        lDAPAttributeSet.add(new LDAPAttribute("aci", this.getGroupACI("", string7)));
        lDAPAttributeSet.add(new LDAPAttribute("aci", "(targetattr=uniquemember)(targetfilter=(objectclass=nsLegacyServer))(version 3.0; acl \"Enable access delegation\"; allow (write) groupdn=\"ldap:///" + string7 + "\";)"));
        LDAPEntry lDAPEntry = new LDAPEntry(string7, lDAPAttributeSet);
        Debug.println("Adding sieDN = " + string7);
        this.ldapAdd(lDAPEntry);
        this.addUniqueMember(string7, string3);
        this.addUniqueMember(string7, string7);
    }

    private void printServerList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Debug.print(((ListElement)vector.elementAt(n)).getType() + ": ");
            int n2 = 0;
            while (n2 < ((ListElement)vector.elementAt((int)n)).sInstList.size()) {
                Debug.print((String)((ListElement)vector.elementAt((int)n)).sInstList.elementAt(n2) + "  ");
                ++n2;
            }
            Debug.println("");
            ++n;
        }
    }
}

