/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.IWizardPageValidator;
import com.netscape.management.client.components.IWizardSequenceManager;
import com.netscape.management.client.components.Wizard;
import com.netscape.management.client.components.WizardPage;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WizardNavigator
extends JPanel
implements ActionListener,
ChangeListener {
    JButton m_back;
    JButton m_next;
    JButton m_help;
    JButton m_cancel;
    IWizardSequenceManager m_sequenceManager;
    Wizard m_wizardDialog;
    int index = 1;
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.components.Wizard");

    public WizardNavigator(Wizard wizard, IWizardSequenceManager iWizardSequenceManager) {
        this.m_wizardDialog = wizard;
        this.m_sequenceManager = iWizardSequenceManager;
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(9, 9, 9, 9));
        this.m_back = JButtonFactory.create(this._resource.getString(null, "BackButtonLabel"));
        this.m_back.addActionListener(this);
        this.m_back.setActionCommand("BACK");
        this.add(this.m_back);
        this.m_next = JButtonFactory.create(this._resource.getString(null, "NextButtonLabel"));
        this.m_next.addActionListener(this);
        this.m_next.setActionCommand("NEXT");
        this.m_cancel = JButtonFactory.createCancelButton(this);
        this.m_help = JButtonFactory.createHelpButton(this);
        JButtonFactory.resizeGroup(this.m_help, this.m_cancel, this.m_next, this.m_back);
        int n = 0;
        GridBagUtil.constrain(this, Box.createHorizontalGlue(), ++n, 0, 1, 1, 1.0, 0.0, 17, 1, 0, 0, 0, 0);
        GridBagUtil.constrain(this, this.m_back, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(this, this.m_next, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 12);
        GridBagUtil.constrain(this, this.m_cancel, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(this, this.m_help, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 12, 0, 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_back) {
            if (this.m_wizardDialog.getPage(this.m_sequenceManager.getCurrent()).backInvoked()) {
                --this.index;
                this.setPanel(this.m_sequenceManager.getPrevious(this.m_sequenceManager.getCurrent()));
            }
        } else if (object == this.m_next) {
            if (this.m_wizardDialog.getPage(this.m_sequenceManager.getCurrent()).nextInvoked()) {
                ++this.index;
                if (this.m_next.getText().equals(this._resource.getString(null, "FinishButtonLabel"))) {
                    this.getTopLevelAncestor().setVisible(false);
                } else {
                    this.setPanel(this.m_sequenceManager.getNext(this.m_sequenceManager.getCurrent()));
                }
            }
        } else if (object == this.m_cancel) {
            if (JOptionPane.showConfirmDialog(this.m_wizardDialog, this._resource.getString(null, "sure"), this._resource.getString(null, "cancelConfirmTitle"), 0) == 0) {
                this.getTopLevelAncestor().setVisible(false);
            }
        } else if (object == this.m_help) {
            this.m_wizardDialog.getPage(this.m_sequenceManager.getCurrent()).helpInvoked();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkValidation(this.m_sequenceManager.getCurrent());
    }

    public void checkValidation(String string) {
        if (this.m_wizardDialog.getPage(string) instanceof IWizardPageValidator) {
            WizardPage wizardPage = this.m_wizardDialog.getPage(string);
            this.m_next.setEnabled(wizardPage.canMoveForward());
            this.m_back.setEnabled(wizardPage.canMoveBackward());
            this.m_cancel.setEnabled(wizardPage.canCancel());
            this.paintAll(this.getGraphics());
        }
    }

    public void setPanel(String string) {
        this.m_wizardDialog.setPanel(string, this.index);
        this.checkValidation(string);
        this.m_back.setVisible(!this.m_sequenceManager.getFirst().equals(string));
        this.m_back.setEnabled(!this.m_sequenceManager.getFirst().equals(string));
        WizardPage wizardPage = null;
        if (this.m_sequenceManager.getPrevious(string) != null && this.m_sequenceManager.getPrevious(string).length() > 0 && (wizardPage = this.m_wizardDialog.getPage(this.m_sequenceManager.getPrevious(string))).getExtraButtonComponent() != null) {
            this.remove(wizardPage.getExtraButtonComponent());
        }
        if (this.m_sequenceManager.getNext(string) != null && this.m_sequenceManager.getNext(string).length() > 0 && (wizardPage = this.m_wizardDialog.getPage(this.m_sequenceManager.getNext(string))).getExtraButtonComponent() != null) {
            this.remove(wizardPage.getExtraButtonComponent());
        }
        if ((wizardPage = this.m_wizardDialog.getPage(string)) != null && (wizardPage.getMaxSteps() == this.index || wizardPage.getMaxSteps() <= 0 && this.m_sequenceManager.isLast(string))) {
            this.m_next.setText(this._resource.getString(null, "FinishButtonLabel"));
        } else {
            this.m_next.setText(this._resource.getString(null, "NextButtonLabel"));
        }
        if (wizardPage.getExtraButtonComponent() != null) {
            GridBagUtil.constrain(this, wizardPage.getExtraButtonComponent(), 0, 0, 1, 1, 0.0, 0.0, 17, 2, 0, 0, 0, 0);
        }
        wizardPage.pageShown();
        this.m_help.setVisible(wizardPage.isHelpButtonVisible());
        this.paintAll(this.getGraphics());
    }
}

