/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.comm;

import com.netscape.management.client.comm.HttpChannel;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.security.PromptForTrustDialog;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public class HttpsChannel
extends HttpChannel
implements SSLCertificateApprovalCallback,
SSLClientCertificateSelectionCallback,
PasswordCallback {
    protected SSLSocket socket = null;
    static CryptoManager cryptoManager;
    static GetPasswordDialog getPasswordDialog;
    static SelectCertDialog selectCertDialog;
    static CertificateFactory cf;
    static ResourceSet resource;
    static final int MAX_PASSWORD_PROMPT = 10;
    int nthPrompt = 0;
    private static PromptForTrustDialog promptForTrustDialog;

    private static String i18n(String string) {
        return resource.getString("HttpsChannel", string);
    }

    private static String i18n(String string, String string2) {
        return resource.getString("HttpsChannel", string, string2);
    }

    protected HttpsChannel(Object object, String string, HttpManager httpManager) {
        super(object, string, httpManager);
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        Object object;
        boolean bl = true;
        boolean bl2 = true;
        if (!UtilConsoleGlobals.isServerAuthEnabled()) {
            return bl2;
        }
        Enumeration enumeration = validityStatus.getReasons();
        bl = enumeration.hasMoreElements();
        Debug.println("This certificate is " + (bl ? "not " : "") + "a trusted server Certificate");
        java.security.cert.X509Certificate x509Certificate2 = null;
        try {
            object = new ByteArrayInputStream(x509Certificate.getEncoded());
            while (((ByteArrayInputStream)object).available() > 0) {
                x509Certificate2 = (java.security.cert.X509Certificate)cf.generateCertificate((InputStream)object);
                Debug.println(x509Certificate2.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (promptForTrustDialog == null) {
            promptForTrustDialog = new PromptForTrustDialog(null, x509Certificate2, validityStatus);
        } else {
            promptForTrustDialog.setCertificateInfo(x509Certificate2, validityStatus);
        }
        if (bl) {
            block10: {
                promptForTrustDialog.setVisible(true);
                bl2 = promptForTrustDialog.isCertAccepted();
                if (bl2 && !promptForTrustDialog.isAcceptedForOneSession()) {
                    try {
                        Debug.println("install cert");
                        object = x509Certificate.getNickname();
                        Debug.println("nickname: " + (String)object);
                        Debug.println("dn:       " + x509Certificate.getSubjectDN().toString());
                        InternalCertificate internalCertificate = cryptoManager.importCertToPerm(x509Certificate, (String)(object == null ? x509Certificate.getSubjectDN().toString() : object));
                        internalCertificate.setSSLTrust(3);
                    }
                    catch (Exception exception) {
                        if (!Debug.getTrace()) break block10;
                        exception.printStackTrace();
                    }
                }
            }
            Debug.println("ACCEPTED:" + bl2);
        }
        return bl2;
    }

    public String select(Vector vector) {
        if (selectCertDialog == null) {
            selectCertDialog = new SelectCertDialog();
        }
        Debug.println("HttpsChannel::select(...) - SELECT CERTIFICATE");
        selectCertDialog.setCertList(vector);
        ((Component)selectCertDialog).setVisible(true);
        return selectCertDialog.isCancel() ? "" : selectCertDialog.getSelectedCert();
    }

    public Password getPasswordFirstAttempt(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        ++this.nthPrompt;
        if (getPasswordDialog == null) {
            getPasswordDialog = new GetPasswordDialog();
        }
        Debug.println("HttpsChannel::getPasswordFirstAttempt(...) - PROMPT FOR PASSWORD");
        getPasswordDialog.setPasswordInfo(passwordCallbackInfo, false);
        getPasswordDialog.setVisible(true);
        return getPasswordDialog.getPassword();
    }

    public Password getPasswordAgain(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        ++this.nthPrompt;
        Debug.println("HttpsChannel::getPasswordAgainAttempt(...) - PROMPT FOR PASSWORD");
        getPasswordDialog.setPasswordInfo(passwordCallbackInfo, true);
        getPasswordDialog.setVisible(true);
        if (this.nthPrompt > 10) {
            throw new PasswordCallback.GiveUpException();
        }
        return getPasswordDialog.getPassword();
    }

    public void open() throws IOException {
        cryptoManager.setPasswordCallback((PasswordCallback)this);
        try {
            this.nthPrompt = 0;
            Debug.println("CREATE JSS SSLSocket");
            this.socket = new SSLSocket(InetAddress.getByName(this.getHost()), this.getPort(), null, 0, true, (SSLCertificateApprovalCallback)this, (SSLClientCertificateSelectionCallback)this);
            this.socket.setNeedClientAuth(true);
            this.socket.forceHandshake();
            ((HttpChannel)this).socket = this.socket;
        }
        catch (IOException iOException) {
            Debug.println("Unable to create ssl socket");
            if (Debug.getTrace()) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        this.bos = new BufferedOutputStream(this.socket.getOutputStream(), HttpChannel.defaultBufferLength);
        this.bis = new BufferedInputStream(this.socket.getInputStream(), HttpChannel.defaultBufferLength);
        Debug.println(this.name + " open> Ready");
        this.thread = new Thread((Runnable)this, this.tid.toString());
        this.thread.start();
    }

    public void close() throws IOException {
        this.dead = true;
        Debug.println(this.name + " close i/o stream");
        this.bos.close();
        this.bis.close();
        Debug.println(this.name + " close socket");
        this.socket.close();
        this.socket = null;
        Debug.println(this.name + " close> Closed");
        this.thread.stop();
    }

    static {
        getPasswordDialog = null;
        selectCertDialog = null;
        try {
            resource = new ResourceSet("com.netscape.management.client.comm.HttpsChannel");
            UtilConsoleGlobals.initJSS();
            cf = UtilConsoleGlobals.getX509CertificateFactory();
            cryptoManager = CryptoManager.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        promptForTrustDialog = null;
    }

    class SelectCertDialog
    extends AbstractDialog {
        JComboBox certList = new JComboBox();

        public SelectCertDialog() {
            super(null, HttpsChannel.i18n("selectCertDialogTitle"), true, 3);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.constrain(container, new JLabel(HttpsChannel.i18n("selectCertLabel")), 0, n, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
            GridBagUtil.constrain(container, this.certList, 0, ++n, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
            this.pack();
        }

        public void setCertList(Vector vector) {
            this.certList.removeAllItems();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.certList.insertItemAt(enumeration.nextElement(), 0);
            }
            try {
                this.certList.setSelectedIndex(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getSelectedCert() {
            return this.certList.getSelectedItem().toString();
        }
    }

    class GetPasswordDialog
    extends AbstractDialog {
        MultilineLabel enterPwdLabel = new MultilineLabel();
        SingleBytePasswordField pwd;

        public GetPasswordDialog() {
            super(null, HttpsChannel.i18n("getPwdDialogTitle"), true, 3);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.constrain(container, this.enterPwdLabel, 0, n, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
            this.pwd = new SingleBytePasswordField();
            GridBagUtil.constrain(container, (Component)((Object)this.pwd), 0, ++n, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
            this.pack();
        }

        public void setVisible(boolean bl) {
            this.pack();
            ((JComponent)((Object)this.pwd)).grabFocus();
            super.setVisible(bl);
        }

        public void setPasswordInfo(PasswordCallbackInfo passwordCallbackInfo, boolean bl) {
            if (bl) {
                this.enterPwdLabel.setText(HttpsChannel.i18n("enterPwdAgainLabel", passwordCallbackInfo.getName()));
            } else {
                this.enterPwdLabel.setText(HttpsChannel.i18n("enterPwdLabel", passwordCallbackInfo.getName()));
            }
            Debug.println(passwordCallbackInfo.getName());
        }

        public Password getPassword() {
            Password password = new Password(((JPasswordField)((Object)this.pwd)).getText().toCharArray());
            return password;
        }
    }
}

