/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.comm;

import com.netscape.management.client.comm.AsyncByteArrayInputStream;
import com.netscape.management.client.comm.ClientThread;
import com.netscape.management.client.comm.CommChannel;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommClient2;
import com.netscape.management.client.comm.CommManager;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpException;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.VersionInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.IProgressListener;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.URLByteEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpChannel
implements Runnable,
CommChannel {
    protected static final String HTTP_GET = "GET";
    protected static final String HTTP_POST = "POST";
    protected static final String http_prot = "HTTP/1.0";
    protected static final String newline = "\r\n";
    protected static final int defaultExpectedLineLength = 128;
    protected static int defaultBufferLength = 512;
    protected Thread thread = null;
    protected URL tid = null;
    protected HttpManager manager = null;
    protected String language = null;
    protected String name = null;
    protected boolean sendUTF8 = false;
    protected String _adminVersion;
    protected Socket socket = null;
    protected BufferedOutputStream bos = null;
    protected BufferedInputStream bis = null;
    protected boolean dead = false;
    protected boolean busy = false;
    private static final byte[] cipherset = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    protected HttpChannel(Object object, String string, HttpManager httpManager) {
        this.tid = (URL)object;
        this.manager = httpManager;
        this.language = CommManager.getLanguage();
        this.name = this.tid.toString() + "[" + string + "]";
        this.sendUTF8 = CommManager.getSendUTF8();
    }

    public void open() throws IOException {
        Method method = Permissions.getEnablePrivilegeMethod();
        if (method != null) {
            Object[] objectArray = new Object[]{"UniversalConnect"};
            try {
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                System.err.println("HttpChannel:open():unable to grant UniversalConnect:" + exception);
            }
        }
        this.socket = new Socket(this.getHost(), this.getPort());
        this.bos = new BufferedOutputStream(this.socket.getOutputStream(), defaultBufferLength);
        this.bis = new BufferedInputStream(this.socket.getInputStream(), defaultBufferLength);
        Debug.println(this.name + " open> Ready");
        this.thread = new Thread((Runnable)this, this.tid.toString());
        this.thread.start();
    }

    public void close() throws IOException {
        this.dead = true;
        if (this.bos != null) {
            this.bos.close();
            this.bos = null;
        }
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
            Debug.println(this.name + " close> Closed");
        }
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public boolean ready() {
        return this.thread != null && !this.dead && !this.busy;
    }

    public Object targetID() {
        return this.tid;
    }

    public String toString() {
        return this.name;
    }

    protected static void setBufferSize(int n) {
        defaultBufferLength = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        while (true) {
            Object var9_9;
            block17: {
                block16: {
                    if (this.dead) {
                        return;
                    }
                    CommRecord commRecord = null;
                    this.busy = false;
                    try {
                        commRecord = this.manager.next(this);
                    }
                    catch (IOException iOException) {
                        Debug.println(this.name + " error> " + iOException);
                        this.kill();
                    }
                    if (commRecord == null) {
                        this.kill();
                    }
                    commRecord.setChannel(this);
                    this.busy = true;
                    Debug.println(this.name + " accept> " + commRecord.getTarget());
                    if (commRecord.getStatus().equals("Error")) {
                        Debug.println(this.name + "error> CommRecord Status: " + "Error");
                        continue;
                    }
                    CommClient commClient = commRecord.getClient();
                    try {
                        try {
                            if (bl) {
                                if (!this.isConnected()) {
                                    Debug.println(this.name + " test> connection is lost -- open new channel");
                                    this.retry(commRecord);
                                    this.kill();
                                    var9_9 = null;
                                    break block16;
                                }
                                Debug.println(this.name + " test> connection is still there");
                            }
                            bl = true;
                            this.invoke(commRecord);
                            break block17;
                        }
                        catch (HttpException httpException) {
                            Debug.println(this.name + " error> " + httpException);
                            commRecord.setStatus("Error");
                            commClient.errorHandler(httpException, commRecord);
                            this.kill();
                            var9_9 = null;
                            if (!Debug.httpTraceEnabled()) continue;
                            Debug.println("http", "Done!");
                            continue;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            Debug.println(this.name + " error> " + interruptedIOException);
                            commRecord.setStatus("Error");
                            commClient.errorHandler(interruptedIOException, commRecord);
                            this.kill();
                            var9_9 = null;
                            if (!Debug.httpTraceEnabled()) continue;
                            Debug.println("http", "Done!");
                            continue;
                        }
                        catch (EOFException eOFException) {
                            Debug.println(this.name + " error> " + eOFException);
                            commRecord.setStatus("Error");
                            commClient.errorHandler(eOFException, commRecord);
                            this.kill();
                            var9_9 = null;
                            if (!Debug.httpTraceEnabled()) continue;
                            Debug.println("http", "Done!");
                            continue;
                        }
                        catch (IOException iOException) {
                            Debug.println(this.name + " error> " + iOException);
                            this.retry(commRecord);
                            this.kill();
                            var9_9 = null;
                            if (!Debug.httpTraceEnabled()) continue;
                            Debug.println("http", "Done!");
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        if (Debug.httpTraceEnabled()) {
                            Debug.println("http", "Done!");
                        }
                        throw throwable;
                    }
                }
                if (!Debug.httpTraceEnabled()) return;
                Debug.println("http", "Done!");
                return;
            }
            var9_9 = null;
            if (!Debug.httpTraceEnabled()) continue;
            Debug.println("http", "Done!");
        }
    }

    private void retry(CommRecord commRecord) {
        try {
            this.manager.retry(commRecord);
        }
        catch (IOException iOException) {
            Debug.println(this.name + " error> " + iOException);
        }
    }

    private void kill() {
        try {
            this.manager.closeChannel(this);
        }
        catch (IOException iOException) {
            Debug.println(this.name + " error> " + iOException);
        }
    }

    private void invoke(CommRecord commRecord) throws IOException, HttpException {
        int n;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        String string = ((URL)commRecord.getTarget()).getFile();
        InputStream inputStream = commRecord.getData();
        if (!this.sendUTF8) {
            this.writeLine((inputStream == null ? HTTP_GET : HTTP_POST) + " " + string + " " + http_prot);
        } else {
            this.write((inputStream == null ? HTTP_GET : HTTP_POST) + " ");
            this.write(string.getBytes("UTF8"));
            this.writeLine(" HTTP/1.0");
        }
        this.writeLine("Host: " + this.getHost() + ":" + this.getPort());
        this.writeLine("Connection: Keep-Alive");
        try {
            object = VersionInfo.getVersionNumber();
            this.writeLine("User-Agent: Netscape-Console/" + (String)object);
        }
        catch (Exception exception) {
            this.writeLine("User-Agent: Netscape-Console/");
        }
        this.writeLine("Accept-Language: " + this.language);
        object = commRecord.getClient();
        Object object2 = commRecord.getAuthObj();
        String[] stringArray = (String[])commRecord.getChannelArg();
        if (object2 != null) {
            String string2 = object.username(object2, commRecord);
            String string3 = object.password(object2, commRecord);
            string2 = string2 != null ? string2 : "";
            String string4 = string3 = string3 != null ? string3 : "";
            if (!this.sendUTF8) {
                this.writeLine("Authorization: Basic " + HttpChannel.uuencode(string2 + ":" + string3));
            } else {
                this.write("Authorization: Basic ");
                this.write(HttpChannel.uuencode((string2 + ":" + string3).getBytes("UTF8")));
                this.writeLine("");
            }
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.writeLine(stringArray[n2]);
                ++n2;
            }
        }
        if (inputStream != null) {
            int n3 = commRecord.getDataLength();
            this.writeLine("Content-Length:" + n3);
            this.writeLine("Content-Type: application/x-www-form-urlencoded");
            this.writeLine("Content-Transfer-Encoding: 7bit");
            this.writeLine("");
            this.write(inputStream, n3);
        } else {
            this.writeLine("");
        }
        commRecord.setStatus("Sent");
        this.socket.setSoTimeout(this.manager.getResponseTimeout());
        String string5 = this.readLine();
        int n4 = string5.indexOf(32);
        int n5 = Integer.parseInt(string5.substring(n4 + 1, n4 + 1 + 3));
        String string6 = string5.substring(0, n4);
        switch (n5) {
            case 200: 
            case 301: 
            case 302: {
                break;
            }
            case 401: {
                if (object2 == null) break;
                throw new HttpException((URL)commRecord.getTarget(), string5, n5);
            }
            default: {
                throw new HttpException((URL)commRecord.getTarget(), string5, n5);
            }
        }
        int n6 = -1;
        object2 = null;
        while (true) {
            if ((string5 = this.readLine()).regionMatches(true, 0, "Content-length", 0, 14)) {
                n6 = Integer.parseInt(string5.substring(string5.indexOf(58) + 2));
                continue;
            }
            if (string5.regionMatches(true, 0, "WWW-authenticate", 0, 16)) {
                n = string5.indexOf(61);
                if (n == -1) {
                    throw new HttpException((URL)commRecord.getTarget(), string5, -1);
                }
                object2 = string5.substring(n + 1);
                bl = true;
                continue;
            }
            if (string5.regionMatches(true, 0, "Admin-Server:", 0, 13)) {
                n = string5.indexOf(47);
                if (n == -1) {
                    Debug.println("HttpChannel.invoke: no version in " + string5);
                    continue;
                }
                this._adminVersion = string5.substring(n + 1);
                Debug.println("HttpChannel.invoke: admin version = " + this._adminVersion);
                continue;
            }
            if (string5.regionMatches(true, 0, "Server:", 0, 7) && this._adminVersion == null) {
                n = string5.indexOf(47);
                if (n == -1) {
                    Debug.println("HttpChannel.invoke: no version in " + string5);
                    continue;
                }
                this._adminVersion = string5.substring(n + 1);
                Debug.println("HttpChannel.invoke: admin version = " + this._adminVersion);
                continue;
            }
            if (string5.regionMatches(true, 0, "Location:", 0, 9) && (n5 == 301 || n5 == 302)) {
                commRecord.setTarget(new URL(string5.substring(string5.indexOf(58) + 2)));
                bl = true;
                continue;
            }
            if (string5.trim().length() == 0) break;
        }
        n = commRecord.getAsyncResponseMode() ? 1 : 0;
        if (n6 == -1) {
            AsyncByteArrayInputStream asyncByteArrayInputStream = new AsyncByteArrayInputStream();
            if (!bl && n != 0) {
                new ClientThread(commRecord, asyncByteArrayInputStream).start();
            }
            Debug.println(this.name + " recv> Reading unknown length bytes...");
            try {
                int n7;
                while ((n7 = this.bis.read()) != -1) {
                    asyncByteArrayInputStream.write(n7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            asyncByteArrayInputStream.setEOF();
            commRecord.setStatus("Complete");
            Debug.println(this.name + " recv> " + asyncByteArrayInputStream.size() + " bytes read");
            if (!bl && n == 0) {
                new ClientThread(commRecord, asyncByteArrayInputStream).start();
            }
            bl2 = true;
        } else if (n6 >= 0) {
            Object object3;
            IProgressListener iProgressListener = null;
            if (commRecord.getClient() instanceof CommClient2) {
                object3 = commRecord;
                iProgressListener = new IProgressListener((CommRecord)object3){
                    private final /* synthetic */ CommRecord val$fcr;
                    {
                        this.val$fcr = commRecord;
                    }

                    public void progressUpdate(String string, int n, int n2) {
                        ((CommClient2)this.val$fcr.getClient()).progressUpdate(this.val$fcr.target.toString(), n, n2);
                    }
                };
            }
            object3 = new AsyncByteArrayInputStream(n6 > 0 ? n6 : 1, iProgressListener);
            if (!bl && n != 0) {
                new ClientThread(commRecord, (InputStream)object3).start();
            }
            Debug.println(this.name + " recv> Reading " + n6 + " bytes...");
            if (n6 > 0) {
                ((AsyncByteArrayInputStream)object3).write(this.bis, n6);
            }
            ((AsyncByteArrayInputStream)object3).setEOF();
            commRecord.setStatus("Complete");
            Debug.println(this.name + " recv> " + ((AsyncByteArrayInputStream)object3).available() + " bytes read");
            if (!bl && n == 0) {
                new ClientThread(commRecord, (InputStream)object3).start();
            }
            if (string6.compareTo(http_prot) < 0) {
                bl2 = true;
            }
        }
        if (object2 != null) {
            commRecord.setAuthObj(object2);
        }
        if (bl) {
            this.retry(commRecord);
        }
        if (bl2) {
            this.kill();
        }
    }

    private void write(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println(this.name + " send> " + string + " \\");
    }

    private void write(byte[] byArray) throws IOException {
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println(this.name + " send> " + new String(byArray) + " \\");
    }

    private void writeLine(String string) throws IOException {
        byte[] byArray = (string + newline).getBytes();
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println(this.name + " send> " + string);
    }

    private void write(InputStream inputStream, int n) throws IOException {
        Debug.println(this.name + " send> Writing " + n + " bytes...");
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println(this.name + " send> " + n + " bytes written");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readLine() throws IOException {
        var2_1 = HttpChannel.defaultBufferLength;
        var3_2 = new byte[var2_1];
        var4_3 = 0;
        var5_4 = false;
        try {
            while (true) lbl-1000:
            // 6 sources

            {
                if (var5_4) {
                    var6_9 = new String(var3_2, 0, var4_3);
                    Debug.println(this.name + " recv> " + var6_9);
                    return var6_9;
                }
                var1_5 = this.bis.read();
                switch (var1_5) {
                    default: {
                        try {
                            if (this.bis.available() == 0) {
                                ** break;
                            }
                        }
                        catch (Exception var6_6) {
                            // empty catch block
                        }
                        if (var4_3 == var2_1) {
                            var6_7 = new byte[var2_1 + HttpChannel.defaultBufferLength];
                            System.arraycopy(var3_2, 0, var6_7, 0, var2_1);
                            var2_1 += HttpChannel.defaultBufferLength;
                            var3_2 = var6_7;
                        }
                        var3_2[var4_3++] = (byte)var1_5;
                        ** break;
                    }
                    case 10: {
                        var5_4 = true;
                        ** break;
                    }
                    case -1: {
                        throw new EOFException("Connection lost");
                    }
                    case 13: 
                }
                var5_4 = true;
                var6_8 = this.bis.read();
                if (var6_8 == 10) continue;
                System.err.println("HttpChannel:readLine():carriage return not followed by newline in stream.");
            }
        }
        catch (InterruptedIOException var6_10) {
            Debug.println(this.name + " recv> interrupted");
            throw new InterruptedIOException("HTTP response timeout");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnected() throws IOException {
        boolean bl;
        int n = this.socket.getSoTimeout();
        try {
            try {
                this.socket.setSoTimeout(100);
                int n2 = this.bis.read();
                if (n2 != -1) {
                    Debug.println(0, "Unexpected data received 0x" + Integer.toHexString(n2));
                    throw new IOException();
                }
                bl = false;
                Object var6_4 = null;
            }
            catch (InterruptedIOException interruptedIOException) {
                Object var6_5 = null;
                this.socket.setSoTimeout(n);
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.socket.setSoTimeout(n);
            throw throwable;
        }
        this.socket.setSoTimeout(n);
        return bl;
    }

    public static ByteArrayInputStream encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(HttpChannel._encode(new String(byArray)).getBytes());
    }

    public static ByteArrayInputStream encode(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string = string + string2 + "=" + URLByteEncoder.encodeUTF8(string3) + (enumeration.hasMoreElements() ? "&" : "");
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public static String _encode(String string) {
        return URLEncoder.encode(string);
    }

    public static String uuencode(String string) {
        return new String(HttpChannel.uuencode(string.getBytes()));
    }

    public static byte[] uuencode(byte[] byArray) {
        int n;
        int n2 = (n = byArray.length) % 3;
        byte[] byArray2 = new byte[n + (n2 == 0 ? 0 : 3 - n2)];
        byte[] byArray3 = new byte[byArray2.length * 4 / 3];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length) {
            byte by = byArray2[n3++];
            byte by2 = byArray2[n3++];
            byte by3 = byArray2[n3++];
            byArray3[n4++] = cipherset[by >> 2 & 0x3F];
            byArray3[n4++] = cipherset[(by & 3) << 4 | (by2 & 0xF0) >> 4];
            byArray3[n4++] = cipherset[(by2 & 0xF) << 2 | (by3 & 0xC0) >> 6];
            byArray3[n4++] = cipherset[by3 & 0x3F];
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                int n5 = --n4;
                byArray3[--n4] = 61;
                byArray3[n5] = 61;
                break;
            }
            case 2: {
                byArray3[--n4] = 61;
            }
        }
        return byArray3;
    }

    protected String getHost() {
        return this.tid.getHost();
    }

    protected int getPort() {
        return this.tid.getPort();
    }

    protected String getProtocol() {
        return this.tid.getProtocol();
    }

    public String getAdminVersion() {
        return this._adminVersion;
    }
}

