/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acl;

import com.netscape.management.client.acl.ACL;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.util.Debug;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileACL
extends ACL {
    protected Hashtable auth = new Hashtable();

    protected Reader openACLReader(Object object) throws IOException {
        return new FileReader((File)object);
    }

    protected Writer openACLWriter(Object object) throws IOException {
        return new FileWriter((File)object);
    }

    protected void parse(StreamTokenizer streamTokenizer) throws Exception {
        streamTokenizer.quoteChar(34);
        this.parseHeader(streamTokenizer);
        this.parseAuthenticateBlock(streamTokenizer);
        try {
            while (true) {
                this.appendRule(streamTokenizer);
            }
        }
        catch (EOFException eOFException) {
            if (!eOFException.getMessage().equals("Clean EOF")) {
                throw eOFException;
            }
            return;
        }
    }

    protected void write(Writer writer) throws Exception {
        this.writeHeader(writer);
        this.writeAuthenticateBlock(writer);
        int n = 0;
        while (n < this.rules.size()) {
            ((Rule)this.rules.elementAt(n)).writeRule(writer);
            ++n;
        }
    }

    public Hashtable getAuthAttributes() {
        return this.auth;
    }

    protected void parseAuthenticateBlock(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        String string = null;
        String string2 = null;
        boolean bl = true;
        Debug.println("FileACL.parseAuthenticationBlock: Parsing ACL Authenticate Block.");
        block8: while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case -3: {
                    if (bl) continue block8;
                    string = streamTokenizer.sval;
                    break;
                }
                case 123: {
                    if (!bl) {
                        throw new IOException("Unrecognized token in ACL authentication header");
                    }
                    bl = false;
                    break;
                }
                case 125: {
                    if (bl) {
                        throw new IOException("Unrecognized token in ACL authentication header");
                    }
                    bl = true;
                    break;
                }
                case 40: 
                case 41: 
                case 44: 
                case 61: {
                    break;
                }
                case 59: {
                    if (bl) {
                        return;
                    }
                    if (string == null || string2 == null) {
                        throw new IOException("Unrecognized token in ACL authentication header");
                    }
                    Debug.println("FileACL.parseAuthenticationBlock:" + string + " = " + string2);
                    this.auth.put(string, string2);
                    string = null;
                    string2 = null;
                    break;
                }
                case 34: {
                    string2 = streamTokenizer.sval;
                    break;
                }
                default: {
                    throw new IOException("Unrecognized token in ACL authentication header");
                }
            }
        }
        throw new EOFException("Unexpected EOF while parsing ACL authentication header");
    }

    protected void writeHeader(Writer writer) throws IOException {
        writer.write("version " + this.version + ";\n");
        writer.write("acl \"" + this.resource + "\";\n");
    }

    protected void writeAuthenticateBlock(Writer writer) throws IOException {
        writer.write("authenticate (user,group) {\n");
        Enumeration enumeration = this.auth.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.auth.get(string);
            writer.write("\t" + string + " = \"" + string2 + "\";\n");
        }
        writer.write("};\n");
    }

    public String toString() {
        String string = "-----------------------------------------------\nACL Header:     " + this.resource + '\n' + "ACL Auth Block: " + this.auth + '\n' + '\n';
        int n = 0;
        while (n < this.rules.size()) {
            string = string + "Rule: " + n + '\n';
            string = string + this.rules.elementAt(n).toString();
            string = string + '\n';
            ++n;
        }
        string = string + "-----------------------------------------------\n";
        return string;
    }
}

