/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.UGTab;
import com.netscape.management.client.ace.UGTable;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.DirBrowserDialog;
import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;

class UGChooserDialog
extends GenericDialog {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private JFrame parentFrame;
    private LDAPConnection aciLdc;
    private LDAPConnection ugLdc;
    private UGTable searchTable;
    private UGTable selectedTable;
    private JLabel searchFromLabel;
    private JButton addButton;
    private JButton removeButton;
    private JButton searchButton;
    private JButton changeButton;
    private JTextField searchField;
    private int AREA_USER = 1;
    private int AREA_ADMIN = 2;
    private int AREA_SPECIAL = 3;
    private int selectedArea = this.AREA_USER;
    private String ugDN;
    private String filterAttribute = "uid";

    public UGChooserDialog(JFrame jFrame, LDAPConnection lDAPConnection, LDAPConnection lDAPConnection2, String string) {
        super(jFrame);
        this.parentFrame = jFrame;
        this.aciLdc = lDAPConnection;
        this.ugLdc = lDAPConnection2;
        this.ugDN = string;
        this.setTitle(UGChooserDialog.i18n("title"));
        this.getContentPane().add(this.createContentPanel());
    }

    private static String i18n(String string) {
        return i18n.getString("ugChooser", string);
    }

    private JComponent createContentPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JComponent jComponent = this.createCriteriaPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        jComponent = this.createSearchFromPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jComponent = this.createSearchPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jComponent = this.createSelectedPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ButtonFactory.resizeButtons(this.searchButton, this.changeButton);
        return jPanel;
    }

    private JComponent createSearchFromPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(UGChooserDialog.i18n("searchFrom"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.searchFromLabel = new JLabel(this.ugDN);
        gridBagLayout.setConstraints(this.searchFromLabel, gridBagConstraints);
        jPanel.add(this.searchFromLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.changeButton = ButtonFactory.createButton(UGChooserDialog.i18n("change"), new ChangeSearchFromListener(), null);
        this.changeButton.setToolTipText(UGChooserDialog.i18n("change_tt"));
        gridBagLayout.setConstraints(this.changeButton, gridBagConstraints);
        jPanel.add(this.changeButton);
        return jPanel;
    }

    private JComponent createCriteriaPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(UGChooserDialog.i18n("searchFor"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.searchField = new JTextField();
        jLabel.setLabelFor(this.searchField);
        this.setFocusComponent(this.searchField);
        gridBagLayout.setConstraints(this.searchField, gridBagConstraints);
        jPanel.add(this.searchField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jLabel = new JLabel(UGChooserDialog.i18n("searchArea"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jLabel.setLabelFor(jComboBox);
        jComboBox.addItem(UGChooserDialog.i18n("ugArea"));
        jComboBox.addItem(UGChooserDialog.i18n("adminArea"));
        jComboBox.addItem(UGChooserDialog.i18n("specialArea"));
        jComboBox.addItemListener(new SearchAreaListener());
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        jPanel.add(jComboBox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.searchButton = ButtonFactory.createButton(UGChooserDialog.i18n("search"), new SearchListener(), null);
        this.searchButton.setToolTipText(UGChooserDialog.i18n("search_tt"));
        this.setDefaultButton(this.searchButton);
        gridBagLayout.setConstraints(this.searchButton, gridBagConstraints);
        jPanel.add(this.searchButton);
        return jPanel;
    }

    private JComponent createSearchPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(UGChooserDialog.i18n("searchResults"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.searchTable = new UGTable();
        jLabel.setLabelFor(this.searchTable);
        this.searchTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
        this.searchTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                UGChooserDialog.this.selectedTable.getSelectionModel().clearSelection();
            }
        });
        ListSelectionModel listSelectionModel = this.searchTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    UGChooserDialog.this.addButton.setEnabled(!UGChooserDialog.this.searchTable.getSelectionModel().isSelectionEmpty());
                }
            }
        });
        this.searchTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = ((TableModel)tableModelEvent.getSource()).getRowCount();
                UGChooserDialog.this.addButton.setEnabled(n > 0);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.searchTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JComponent createSelectedPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(UGChooserDialog.i18n("selected"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.addButton = ButtonFactory.createButton(UGChooserDialog.i18n("add"), new AddListener(), null);
        this.addButton.setToolTipText(UGChooserDialog.i18n("add_tt"));
        this.addButton.setHorizontalTextPosition(2);
        this.addButton.setIcon(ButtonFactory.DOWN_ICON);
        ButtonFactory.resizeButton(this.addButton);
        this.addButton.setEnabled(false);
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.removeButton = ButtonFactory.createPredefinedButton("REMOVE", new RemoveListener());
        this.removeButton.setToolTipText(UGChooserDialog.i18n("remove_tt"));
        this.removeButton.setIcon(ButtonFactory.UP_ICON);
        this.removeButton.setHorizontalTextPosition(2);
        this.removeButton.setHorizontalAlignment(0);
        this.removeButton.setMargin(new Insets(0, 15, 0, 12));
        ButtonFactory.resizeButton(this.removeButton);
        this.removeButton.setEnabled(false);
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        jPanel.add(this.removeButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.selectedTable = new UGTable();
        jLabel.setLabelFor(this.selectedTable);
        this.selectedTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
        this.selectedTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                UGChooserDialog.this.searchTable.getSelectionModel().clearSelection();
            }
        });
        ListSelectionModel listSelectionModel = this.selectedTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    UGChooserDialog.this.removeButton.setEnabled(!UGChooserDialog.this.selectedTable.getSelectionModel().isSelectionEmpty());
                }
            }
        });
        this.selectedTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = ((TableModel)tableModelEvent.getSource()).getRowCount();
                UGChooserDialog.this.setOKButtonEnabled(n > 0);
                UGChooserDialog.this.removeButton.setEnabled(n > 0);
            }
        });
        this.setOKButtonEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.selectedTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public int getResultCount() {
        return this.selectedTable.getRowCount();
    }

    public LDAPEntry getResult(int n) {
        return this.selectedTable.getRow(n);
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-ugchooser");
    }

    class SearchAreaListener
    implements ItemListener {
        SearchAreaListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ListSelectionModel listSelectionModel = UGChooserDialog.this.searchTable.getSelectionModel();
                listSelectionModel.clearSelection();
                Object object = itemEvent.getItem();
                if (object.equals(UGChooserDialog.i18n("ugArea"))) {
                    UGChooserDialog.this.selectedArea = UGChooserDialog.this.AREA_USER;
                    UGChooserDialog.this.searchTable.deleteAllRows();
                    UGChooserDialog.this.searchTable.setUserDN(UGChooserDialog.this.ugDN);
                    UGChooserDialog.this.searchField.setBackground(UIManager.getColor("TextField.background"));
                    UGChooserDialog.this.searchField.setEnabled(true);
                    UGChooserDialog.this.searchButton.setEnabled(true);
                    UGChooserDialog.this.changeButton.setEnabled(true);
                    UGChooserDialog.this.searchFromLabel.setText(UGChooserDialog.this.ugDN);
                    UGChooserDialog.this.searchFromLabel.revalidate();
                } else if (object.equals(UGChooserDialog.i18n("adminArea"))) {
                    UGChooserDialog.this.selectedArea = UGChooserDialog.this.AREA_ADMIN;
                    UGChooserDialog.this.searchTable.deleteAllRows();
                    UGChooserDialog.this.searchTable.setUserDN(UGTab.ADMIN_BASE_DN);
                    UGChooserDialog.this.searchField.setBackground(UIManager.getColor("TextField.background"));
                    UGChooserDialog.this.searchField.setEnabled(true);
                    UGChooserDialog.this.searchButton.setEnabled(true);
                    UGChooserDialog.this.changeButton.setEnabled(false);
                    UGChooserDialog.this.searchFromLabel.setText(UGTab.ADMIN_BASE_DN);
                    UGChooserDialog.this.searchFromLabel.revalidate();
                } else {
                    UGChooserDialog.this.selectedArea = UGChooserDialog.this.AREA_SPECIAL;
                    UGChooserDialog.this.searchField.setBackground(UIManager.getColor("control"));
                    UGChooserDialog.this.searchField.setEnabled(false);
                    UGChooserDialog.this.searchButton.setEnabled(false);
                    UGChooserDialog.this.changeButton.setEnabled(false);
                    UGChooserDialog.this.searchFromLabel.setText("");
                    UGChooserDialog.this.searchFromLabel.revalidate();
                    UGChooserDialog.this.searchTable.deleteAllRows();
                    UGChooserDialog.this.searchTable.addRow(new LDAPEntry(UGTab.BIND_AUTHENTICATED, new LDAPAttributeSet()));
                    UGChooserDialog.this.searchTable.addRow(new LDAPEntry(UGTab.BIND_ANYONE, new LDAPAttributeSet()));
                    UGChooserDialog.this.searchTable.addRow(new LDAPEntry(UGTab.BIND_SELF, new LDAPAttributeSet()));
                }
            }
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = UGChooserDialog.this.selectedTable.getSelectedRow() - 1;
            int[] nArray = UGChooserDialog.this.selectedTable.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                UGChooserDialog.this.selectedTable.deleteRows(nArray);
            }
            ListSelectionModel listSelectionModel = UGChooserDialog.this.selectedTable.getSelectionModel();
            int n2 = UGChooserDialog.this.selectedTable.getRowCount();
            if (n2 > 0) {
                if (n < 0) {
                    n = 0;
                }
                if (n >= n2) {
                    n = n2;
                }
                listSelectionModel.setSelectionInterval(n, n);
            } else {
                listSelectionModel.clearSelection();
            }
        }
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Vector vector = UGChooserDialog.this.searchTable.getSelectedEntries();
            int n = UGChooserDialog.this.selectedTable.getRowCount();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!(object instanceof LDAPEntry)) continue;
                UGChooserDialog.this.selectedTable.addRow((LDAPEntry)object);
            }
            object = UGChooserDialog.this.selectedTable.getSelectionModel();
            object.setSelectionInterval(n, UGChooserDialog.this.selectedTable.getRowCount() - 1);
            UGChooserDialog.this.selectedTable.grabFocus();
        }
    }

    class SearchListener
    implements ActionListener {
        SearchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = UGChooserDialog.this.searchField.getText();
            if (string2 == null || string2.equals("") || string2.equals("*")) {
                string = "(|(objectclass=person)(objectclass=groupofuniquenames))";
            } else {
                if (string2.indexOf(42) == -1) {
                    string2 = "*" + string2 + "*";
                }
                if (UGChooserDialog.this.filterAttribute.equals("cn")) {
                    string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + ")))";
                } else if (UGChooserDialog.this.filterAttribute.equals("uid")) {
                    String string3 = UGChooserDialog.this.searchField.getText();
                    string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + "))(&(objectclass=person)(uid=" + string3 + ")))";
                } else {
                    string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + "))(&(objectclass=person)(" + UGChooserDialog.this.filterAttribute + "=" + string2 + ")))";
                }
            }
            Debug.println("Search: " + string);
            UGChooserDialog.this.addButton.setEnabled(false);
            if (UGChooserDialog.this.selectedArea == UGChooserDialog.this.AREA_USER) {
                UGChooserDialog.this.searchTable.doSearch(UGChooserDialog.this.ugLdc, UGChooserDialog.this.ugDN, string);
            } else {
                UGChooserDialog.this.searchTable.doSearch(UGChooserDialog.this.aciLdc, UGTab.ADMIN_BASE_DN, string);
            }
        }
    }

    class ChangeSearchFromListener
    implements ActionListener {
        ChangeSearchFromListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DirBrowserDialog dirBrowserDialog = new DirBrowserDialog(UGChooserDialog.this.parentFrame, null);
            DirModel dirModel = new DirModel(UGChooserDialog.this.aciLdc);
            dirModel.setShowsPrivateSuffixes(false);
            dirModel.setAllowsLeafNodes(false);
            dirModel.setReferralsEnabled(false);
            dirModel.initialize(null);
            dirBrowserDialog.setDirModel(dirModel);
            dirBrowserDialog.show();
            String string = dirBrowserDialog.getSelectedDN();
            if (string == null || string.length() == 0) {
                return;
            }
            UGChooserDialog.this.searchFromLabel.setText(string);
            UGChooserDialog.this.searchFromLabel.revalidate();
            UGChooserDialog.this.ugDN = string;
        }
    }
}

