/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.components.TimeDayPanel;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import netscape.ldap.LDAPConnection;

class TimeTab
implements IACITab,
UIConstants {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static String KEYWORD_TIMEOFDAY = "timeofday";
    private static String KEYWORD_DAYOFWEEK = "dayofweek";
    private static String KEYWORD_OR = "or";
    private static String KEYWORD_AND = "and";
    private static String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static int TAB_POSITION = 4;
    private JPanel p = new JPanel();
    private boolean isInitialized = false;
    private TimeDayPanel timeDayPanel;

    TimeTab() {
    }

    private static String i18n(String string) {
        return i18n.getString("time", string);
    }

    public void initialize(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnection lDAPConnection2, String string2) {
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        this.timeDayPanel.selectNone();
        int n = 0;
        while (n < aCIAttributeArray.length) {
            ACIAttribute aCIAttribute = aCIAttributeArray[n];
            if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_DAYOFWEEK)) {
                Object object2;
                String string2;
                vector.addElement(aCIAttribute);
                if (n > 0 && ((string2 = ((ACIAttribute)(object2 = aCIAttributeArray[n - 1])).getOperator()).equalsIgnoreCase(KEYWORD_OR) || string2.equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object2);
                }
                bl = true;
                object2 = aCIAttribute.getValue();
                if (object2 == null) break;
                object2 = ((String)object2).toLowerCase();
                int n2 = 0;
                while (n2 < DAYS.length) {
                    object = DAYS[n2].toLowerCase();
                    if (((String)object2).indexOf((String)object) != -1) {
                        this.timeDayPanel.addDaySelection(n2, n2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (!bl) {
            this.timeDayPanel.setDaySelection(0, 6);
        }
        int n3 = 0;
        int n4 = 23;
        int n5 = 0;
        while (n5 < aCIAttributeArray.length) {
            object = aCIAttributeArray[n5];
            if (((ACIAttribute)object).getName().equalsIgnoreCase(KEYWORD_TIMEOFDAY)) {
                Object object3;
                String string3;
                vector.addElement(object);
                if (n5 > 0 && ((string3 = ((ACIAttribute)(object3 = aCIAttributeArray[n5 - 1])).getOperator()).equalsIgnoreCase(KEYWORD_OR) || string3.equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object3);
                }
                if (((String)(object3 = ((ACIAttribute)object).getValue())).length() == 4) {
                    object3 = ((String)object3).substring(0, 2);
                } else {
                    if (((String)object3).length() != 3) break;
                    object3 = ((String)object3).substring(0, 1);
                }
                int n6 = -1;
                try {
                    n6 = Integer.parseInt((String)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.println("TimeTab: " + numberFormatException);
                }
                if (n6 < 0 || n6 > 23) break;
                String string4 = ((ACIAttribute)object).getOperator();
                if (!string4.equals("=") && !string4.equals("!=")) {
                    if (string4.equals(">")) {
                        n3 = n6 + 1;
                    } else if (string4.equals("<")) {
                        n4 = n6 - 1;
                    } else if (string4.equals(">=")) {
                        n3 = n6;
                    } else if (string4.equals("<=")) {
                        n4 = n6;
                    }
                }
            }
            ++n5;
        }
        this.timeDayPanel.setHourSelection(n3, n4);
        return ACIAttribute.toArray(vector);
    }

    public JComponent getComponent() {
        this.timeDayPanel = new TimeDayPanel();
        this.timeDayPanel.getAccessibleContext().setAccessibleDescription(TimeTab.i18n("info"));
        this.p.setPreferredSize(new Dimension(490, 270));
        return this.p;
    }

    public int getPreferredPosition() {
        return TAB_POSITION;
    }

    public String getTitle() {
        return TimeTab.i18n("title");
    }

    public void tabSelected() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.p.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel();
        jLabel.setText(TimeTab.i18n("info"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.p.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.timeDayPanel, gridBagConstraints);
        this.p.add(this.timeDayPanel);
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-time");
    }

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        CharSequence charSequence;
        int[] nArray = this.timeDayPanel.getDaySelection();
        int[] nArray2 = this.timeDayPanel.getHourSelection();
        if (nArray.length < 7) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(" and \n(" + KEYWORD_DAYOFWEEK + " = \"");
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    ((StringBuffer)charSequence).append(",");
                }
                ((StringBuffer)charSequence).append(DAYS[nArray[n]]);
                ++n;
            }
            ((StringBuffer)charSequence).append("\")");
            if (stringBuffer.toString().endsWith("\n;)")) {
                int n2 = stringBuffer.length() - 3;
                stringBuffer.insert(n2, (Object)charSequence);
            }
        }
        if (nArray2.length < 24) {
            charSequence = "";
            String string = "";
            if (nArray2.length > 0) {
                charSequence = String.valueOf(nArray2[0]) + "00";
                string = String.valueOf(nArray2[nArray2.length - 1] + 1) + "00";
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(" and \n(");
            stringBuffer2.append(KEYWORD_TIMEOFDAY + " >= ");
            stringBuffer2.append("\"" + (String)charSequence + "\"");
            stringBuffer2.append(" and ");
            stringBuffer2.append(KEYWORD_TIMEOFDAY + " < ");
            stringBuffer2.append("\"" + string + "\"");
            stringBuffer2.append(")");
            if (stringBuffer.toString().endsWith("\n;)")) {
                int n = stringBuffer.length() - 3;
                stringBuffer.insert(n, (Object)stringBuffer2);
            }
        }
        return stringBuffer;
    }

    public ACIAttribute[] getSupportedAttributes() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < DAYS.length) {
            stringBuffer.append(DAYS[n]);
            if (n < DAYS.length - 1) {
                stringBuffer.append("|");
            }
            ++n;
        }
        return new ACIAttribute[]{new ACIAttribute(KEYWORD_TIMEOFDAY, "=|!=|>|>=|<|<=", "\"####\""), new ACIAttribute(KEYWORD_DAYOFWEEK, "=", "\"" + stringBuffer.toString() + "\"")};
    }
}

