/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class UIPermissions {
    private int NAME = 0;
    private int DESCRIPTION = 1;
    private Hashtable h = new Hashtable();
    private String basePermissionDN = null;
    private String permissionDN = null;
    private Vector changeListeners = null;
    private LDAPConnection ldc = null;
    private String ENTRY_PREFIX = "cn";

    public UIPermissions() {
        this(null);
    }

    public UIPermissions(String string) {
        ConsoleInfo consoleInfo = Console.getConsoleInfo();
        if (consoleInfo != null) {
            this.ldc = consoleInfo.getLDAPConnection();
        }
        if (string != null) {
            this.setPermissionBaseDN(string);
        }
    }

    public void addPermission(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        vector.insertElementAt(string2, this.NAME);
        vector.insertElementAt(string3, this.DESCRIPTION);
        this.h.put(string, vector);
    }

    public void removePermission(String string) {
        this.h.remove(string);
    }

    public boolean hasPermission(String string) {
        boolean bl = false;
        Debug.print("UIPermissions: " + string + " ");
        if (string != null && this.permissionDN != null && this.ldc != null && this.ldc.isConnected()) {
            try {
                LDAPEntry lDAPEntry = this.ldc.read(this.ENTRY_PREFIX + "=" + string + "," + this.permissionDN);
                if (lDAPEntry != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                switch (lDAPException.getLDAPResultCode()) {
                    case 32: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
        }
        Debug.println(bl ? "yes" : "no");
        return bl;
    }

    public String getPermissionBaseDN() {
        return this.basePermissionDN;
    }

    public void setPermissionBaseDN(String string) {
        this.basePermissionDN = string;
        this.permissionDN = this.createEntry("UI", string);
    }

    public Enumeration getPermissionIDs() {
        return this.h.keys();
    }

    public String getName(String string) {
        String string2 = null;
        Vector vector = (Vector)this.h.get(string);
        if (vector != null) {
            string2 = (String)vector.elementAt(this.NAME);
        }
        return string2;
    }

    public String getDescription(String string) {
        String string2 = null;
        Vector vector = (Vector)this.h.get(string);
        if (vector != null) {
            string2 = (String)vector.elementAt(this.DESCRIPTION);
        }
        return string2;
    }

    public void permissionChanged(String string) {
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(new ChangeEvent(string));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    private String createEntry(String string, String string2) {
        String string3 = this.ENTRY_PREFIX + "=" + string + "," + string2;
        try {
            this.ldc.search(string3, 2, "(objectclass=*)", null, false);
        }
        catch (LDAPException lDAPException) {
            switch (lDAPException.getLDAPResultCode()) {
                case 32: {
                    try {
                        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                        lDAPAttributeSet.add(new LDAPAttribute(this.ENTRY_PREFIX, string));
                        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "top"));
                        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsAdminConsoleUser"));
                        this.ldc.add(new LDAPEntry(string3, lDAPAttributeSet));
                    }
                    catch (LDAPException lDAPException2) {
                        Debug.println("Cannot create: " + string3);
                    }
                    break;
                }
            }
        }
        return string3;
    }

    public String getPermissionDN(String string) {
        return this.createEntry(string, this.permissionDN);
    }
}

