/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.comm.AsyncByteArrayInputStream;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.HttpException;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.comm.Response;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.CompatibilityPersistance;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GetJarCommClient;
import com.netscape.management.client.util.IProgressListener;
import com.netscape.management.client.util.KingpinClassLoader;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SwingPackageNameConverter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalJarClassLoader
extends KingpinClassLoader {
    protected static final String MANIFEST_FILE_NAME = "classes.env";
    protected static final int JAR_FILE_INCLUDE_LIMIT = 100;
    private boolean isPre50Jar;
    private static String console42Jar = "console42.jar";
    protected Vector jarNames = new Vector();
    protected Vector jarFiles = new Vector();
    static String[] classpath = LocalJarClassLoader.getClassPath();
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private static final String debugTag = "ClassLoader: ";
    static String patchFilePrefix = "patch-";
    static String patchDir = "./patch/";
    static Hashtable patchTable = LocalJarClassLoader.getPatchList();
    static Hashtable compatibilityTable = new Hashtable();

    public LocalJarClassLoader(String string) throws Exception {
        super(string);
        this.loadClassEnvironment(string);
        if (Debug.isEnabled()) {
            String string2 = this.loaderID + ":{";
            int n = 0;
            while (n < this.jarNames.size()) {
                string2 = string2 + (String)this.jarNames.elementAt(n) + " ";
                ++n;
            }
            string2 = string2 + "}";
            Debug.println((int)0, (String)("ClassLoader: new LocalJarClassLoader " + string2));
        }
    }

    protected void loadClassEnvironment(String string) throws Exception {
        String string2;
        block14: {
            string2 = Locale.getDefault().getLanguage();
            this.include(string);
            try {
                this.include(string, string2);
            }
            catch (Exception exception) {
                if (!Debug.isEnabled()) break block14;
                Debug.println((int)5, (String)("ClassLoader: No language file for " + string + " found on local disk, lang=" + string2));
            }
        }
        PropertyResourceBundle propertyResourceBundle = this.getManifest(string);
        if (propertyResourceBundle == null) {
            this.isPre50Jar = true;
            this.includeConsole42Jar(string2);
            return;
        }
        String string3 = propertyResourceBundle.getString("mcc-version");
        if (string3 == null) {
            this.isPre50Jar = true;
            if (Debug.isEnabled()) {
                Debug.println((int)2, (String)"ClassLoader: Bad manifest, no mcc-version directive");
            }
        } else {
            this.isPre50Jar = string3.startsWith("4");
        }
        if (Debug.isEnabled()) {
            Debug.println((int)5, (String)("ClassLoader: isPre50Jar=" + this.isPre50Jar));
        }
        if (this.isPre50Jar) {
            this.includeConsole42Jar(string2);
        }
        String[] stringArray = this.getManifestJarList(propertyResourceBundle);
        int n = 0;
        while (n < stringArray.length) {
            block15: {
                String string4;
                String string5 = stringArray[n];
                if (Debug.isEnabled()) {
                    Debug.println((int)2, (String)("ClassLoader: include jar " + string5));
                }
                if ((string4 = LocalJarClassLoader.checkForNewerVersion(string5)) != null) {
                    if (Debug.isEnabled()) {
                        Debug.println((int)5, (String)("ClassLoader: Using " + string4 + " instead of " + string5 + " and it's language file"));
                    }
                    string5 = string4;
                }
                this.include(string5);
                try {
                    this.include(string5, string2);
                }
                catch (Exception exception) {
                    if (!Debug.isEnabled()) break block15;
                    Debug.println((int)5, (String)("ClassLoader: No language file for " + string5 + " found on local disk, lang=" + string2));
                }
            }
            ++n;
        }
    }

    private void includeConsole42Jar(String string) throws Exception {
        String string2 = patchDir + "/" + console42Jar;
        if (!new File(string2).exists()) {
            return;
        }
        if (Debug.isEnabled()) {
            Debug.println((int)2, (String)("ClassLoader: include jar " + console42Jar));
        }
        this.jarNames.addElement(console42Jar);
        this.jarFiles.addElement(new ZipFile(string2));
        String string3 = LocalJarClassLoader.addL10Nsuffix(console42Jar, "en");
        string2 = patchDir + "/" + string3;
        if (!new File(string2).exists()) {
            return;
        }
        if (Debug.isEnabled()) {
            Debug.println((int)2, (String)("ClassLoader: include jar " + string3));
        }
        this.jarNames.addElement(string3);
        this.jarFiles.addElement(new ZipFile(string2));
    }

    protected String[] getManifestJarList(PropertyResourceBundle propertyResourceBundle) {
        Object object;
        String[] stringArray = new String[100];
        int n = 0;
        while (n < 100) {
            try {
                object = propertyResourceBundle.getString("include-jar" + n);
            }
            catch (MissingResourceException missingResourceException) {
                break;
            }
            stringArray[n++] = object;
        }
        if (Debug.isEnabled()) {
            Debug.println((int)9, (String)("ClassLoader: manifest: " + n + " entries found"));
        }
        object = new String[n];
        --n;
        while (n >= 0) {
            object[n] = stringArray[n];
            if (Debug.isEnabled()) {
                Debug.println((int)9, (String)("ClassLoader: manifest contents: " + object[n]));
            }
            --n;
        }
        return object;
    }

    protected PropertyResourceBundle getManifest(String string) {
        PropertyResourceBundle propertyResourceBundle = null;
        InputStream inputStream = this.getResourceAsStream(MANIFEST_FILE_NAME);
        if (inputStream == null) {
            if (Debug.isEnabled()) {
                Debug.println((int)5, (String)("ClassLoader: no manifest found for " + string));
            }
            return null;
        }
        try {
            propertyResourceBundle = new PropertyResourceBundle(inputStream);
        }
        catch (IOException iOException) {
            Debug.println((int)0, (String)("ClassLoader: error loading manifest for " + string + ": " + iOException.getMessage()));
            return null;
        }
        if (Debug.isEnabled()) {
            Debug.println((int)5, (String)("ClassLoader: manifest loaded for " + string));
        }
        return propertyResourceBundle;
    }

    protected static String addL10Nsuffix(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        return string3 + "_" + string2 + string4;
    }

    protected static String addL10Nsuffix(String string) {
        return LocalJarClassLoader.addL10Nsuffix(string, Locale.getDefault().getLanguage());
    }

    private static String[] getClassPath() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private static boolean isInClassPath(String string) {
        if (classpath == null) {
            return false;
        }
        int n = string.lastIndexOf(File.separator);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        int n2 = 0;
        while (n2 < classpath.length) {
            File file;
            if (classpath[n2].endsWith(string2) && (file = new File(classpath[n2])).exists()) {
                try {
                    String string3 = file.getCanonicalPath();
                    String string4 = new File(string).getCanonicalPath();
                    if (string3.equals(string4)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
            ++n2;
        }
        return false;
    }

    protected void include(String string) throws Exception {
        String string2 = LocalJarClassLoader.locateJarFile(string);
        if (string2 == null) {
            throw new FileNotFoundException("File not found: " + string);
        }
        if (LocalJarClassLoader.isInClassPath(string2)) {
            if (Debug.isEnabled()) {
                Debug.println((int)5, (String)("ClassLoader: Use the system class loader for " + string));
            }
            return;
        }
        if (patchTable.get(string) != null) {
            if (Debug.isEnabled()) {
                Debug.println((int)5, (String)("Apply patch for " + string));
            }
            this.jarNames.addElement(patchFilePrefix + string);
            this.jarFiles.addElement(new ZipFile(patchDir + patchFilePrefix + string));
        }
        this.jarNames.addElement(string);
        this.jarFiles.addElement(new ZipFile(string2));
    }

    protected void include(String string, String string2) throws Exception {
        try {
            this.include(LocalJarClassLoader.addL10Nsuffix(string, string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string2.equals("en")) {
                throw fileNotFoundException;
            }
            if (Debug.isEnabled()) {
                Debug.println((int)5, (String)(debugTag + fileNotFoundException.getMessage()));
                Debug.println((int)5, (String)("ClassLoader: Attempting to revert to " + LocalJarClassLoader.addL10Nsuffix(string, "en")));
            }
            this.include(LocalJarClassLoader.addL10Nsuffix(string, "en"));
        }
    }

    protected int getJarFileIndex(String string) {
        int n = 0;
        while (n < this.jarNames.size()) {
            String string2 = (String)this.jarNames.elementAt(n);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected static String locateJarFile(String string) {
        String string2 = "jars" + File.separator + string;
        if (!new File(string2).exists() && !new File(string2 = string).exists()) {
            return null;
        }
        return string2;
    }

    protected byte[] loadData(String string) throws Exception {
        int n = 0;
        while (n < this.jarFiles.size()) {
            ZipFile zipFile = (ZipFile)this.jarFiles.elementAt(n);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                if (this.isPre50Jar && string.endsWith(".class")) {
                    try {
                        if (Debug.isEnabled()) {
                            Debug.println((int)6, (String)("ClassLoader: converting " + string + " ..."));
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                        SwingPackageNameConverter.convert((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
                        byteArrayOutputStream.close();
                        if (Debug.isEnabled()) {
                            Debug.println((int)6, (String)"ClassLoader: ---- Done");
                        }
                        return byteArrayOutputStream.toByteArray();
                    }
                    catch (Exception exception) {
                        Debug.println((int)0, (String)("ClassLoader: Conversion Exception " + exception));
                        if (Debug.isEnabled()) {
                            exception.printStackTrace(System.out);
                        }
                        throw exception;
                    }
                }
                int n2 = (int)zipEntry.getSize();
                int n3 = 0;
                byte[] byArray = new byte[n2];
                while (n3 < n2) {
                    int n4 = bufferedInputStream.read(byArray, n3, n2 - n3);
                    n3 += n4;
                }
                if (Debug.isEnabled()) {
                    Debug.println((int)8, (String)(debugTag + string + " found in " + this.jarNames.elementAt(n)));
                }
                return byArray;
            }
            if (Debug.isEnabled()) {
                Debug.println((int)9, (String)(debugTag + string + "  NOT in " + this.jarNames.elementAt(n)));
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    public static String[] getLocalJarList() {
        File file = new File("jars");
        if (!file.exists() || !file.isDirectory()) {
            Debug.println((int)0, (String)"ClassLoader: getLocalJarList():Unable to read ./jars directory");
            return null;
        }
        return file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    static Hashtable getPatchList() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Object object = new Object();
        File file = new File(patchDir);
        if (!file.exists() || !file.isDirectory()) {
            Debug.println((int)0, (String)("ClassLoader: getLocalJarList():Unable to read " + patchDir + " directory"));
            return hashtable;
        }
        String[] stringArray = file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        int n = patchFilePrefix.length();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2].substring(n);
            hashtable.put(string, object);
            ++n2;
        }
        return hashtable;
    }

    /*
     * Unable to fully structure code
     */
    public static void getJarFile(ConsoleInfo var0, String var1_1, String var2_2, IProgressListener var3_3) throws Exception {
        block7: {
            var4_4 = new Vector<E>();
            try {
                LocalJarClassLoader.getJarFileFamily(var0, var1_1, var2_2, var3_3, var4_4);
                break block7;
            }
            catch (Exception var5_5) {
                var6_6 = 0;
                ** while (var6_6 < var4_4.size())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var7_7 = (String)var4_4.elementAt(var6_6);
                    var8_9 = new File("jars/" + var7_7);
                    var9_10 = var8_9.delete();
                    if (var9_10) {
                        Debug.println((int)1, (String)("ClassLoader:  Cleanup: removed " + var8_9));
                    } else {
                        Debug.println((int)0, (String)("ClassLoader:  Cleanup: failed, no exception on " + var8_9));
                    }
                }
                catch (Exception var7_8) {
                    Debug.println((int)0, (String)("ClassLoader:  Cleanup: failed " + var7_8));
                }
                ++var6_6;
                continue;
            }
lbl21:
            // 1 sources

            throw var5_5;
        }
    }

    protected static void getJarFileFamily(ConsoleInfo consoleInfo, String string, String string2, IProgressListener iProgressListener, Vector vector) throws Exception {
        HttpManager httpManager = null;
        String string3 = null;
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (!(LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string3 = string + "java/jars/", string2, iProgressListener, vector) || LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string3 = string + "java/", string2, iProgressListener, vector) || LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string3 = string, string2, iProgressListener, vector))) {
            Debug.println((int)0, (String)("ClassLoader: getJarFile():Unable to download " + string2));
            throw new FileNotFoundException(MessageFormat.format(_resource.getString("error", "FileNotFound"), string2, string));
        }
        if (!LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string3, LocalJarClassLoader.addL10Nsuffix(string2), iProgressListener, vector) && !LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string3, LocalJarClassLoader.addL10Nsuffix(string2, "en"), iProgressListener, vector)) {
            Debug.println((int)0, (String)("ClassLoader: getJarFile():Unable to download " + string3 + LocalJarClassLoader.addL10Nsuffix(string2, "en")));
        }
        Vector vector2 = LocalJarClassLoader.processManifest(string2);
        int n = 0;
        while (n < vector2.size()) {
            String string4 = (String)vector2.elementAt(n);
            String string5 = LocalJarClassLoader.checkForNewerVersion(string4);
            if (string5 != null) {
                if (Debug.isEnabled()) {
                    Debug.println((int)5, (String)("ClassLoader: Do not need to load " + string4 + " using backward compatible " + string5));
                }
            } else if (LocalJarClassLoader.locateJarFile(string4) == null) {
                if (Debug.isEnabled()) {
                    Debug.println((int)5, (String)("ClassLoader:  Download include jar " + string4));
                }
                String string6 = "java/jars/";
                if (!LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string + "java/jars/", string4, iProgressListener, vector)) {
                    string6 = "java/";
                    if (!LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string + "java/", string4, iProgressListener, vector)) {
                        string6 = "";
                        if (!LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string + "", string4, iProgressListener, vector)) {
                            Debug.println((int)0, (String)("ClassLoader:  Can not download include jar " + string4));
                            throw new FileNotFoundException(MessageFormat.format(_resource.getString("error", "FileNotFound"), string4, string));
                        }
                    }
                }
                if (!LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string + string6, LocalJarClassLoader.addL10Nsuffix(string4), iProgressListener, vector)) {
                    String string7;
                    if (Debug.isEnabled()) {
                        Debug.println((int)5, (String)("ClassLoader:  Can not load " + LocalJarClassLoader.addL10Nsuffix(string4)));
                    }
                    if (!(string7 = Locale.getDefault().getLanguage()).equals("en") && !LocalJarClassLoader.loadJarFile(consoleInfo, httpManager, string + string6, LocalJarClassLoader.addL10Nsuffix(string4, "en"), iProgressListener, vector) && Debug.isEnabled()) {
                        Debug.println((int)5, (String)("ClassLoader: Can not load " + LocalJarClassLoader.addL10Nsuffix(string4, "en")));
                    }
                }
            } else if (Debug.isEnabled()) {
                Debug.println((int)9, (String)("ClassLoader: do not need to load include jar " + string4));
            }
            ++n;
        }
    }

    public static String checkForNewerVersion(String string) {
        String string2 = (String)compatibilityTable.get(string);
        if (string2 != null && LocalJarClassLoader.locateJarFile(string2) != null) {
            return string2;
        }
        return null;
    }

    protected static boolean loadJarFile(ConsoleInfo consoleInfo, HttpManager httpManager, String string, String string2, IProgressListener iProgressListener, Vector vector) throws Exception {
        if (httpManager == null) {
            httpManager = new HttpManager();
            httpManager.setBufferSize(32768);
            httpManager.setTimeout(20);
        }
        if (Debug.isEnabled()) {
            Debug.println((int)5, (String)("ClassLoader: loadJarFile(): attempting to download " + string + string2));
        }
        if (iProgressListener != null) {
            iProgressListener.progressUpdate(string2, 0, 0);
        }
        URL uRL = null;
        try {
            InputStream inputStream;
            uRL = new URL(string + string2);
            GetJarCommClient getJarCommClient = new GetJarCommClient(consoleInfo, string2, iProgressListener);
            Response response = new Response();
            httpManager.get(uRL, (CommClient)getJarCommClient, (Object)response, 2);
            while ((inputStream = response.getInputStream()) == null) {
                if (getJarCommClient.isError()) {
                    if (getJarCommClient.getException() != null) {
                        throw getJarCommClient.getException();
                    }
                    return false;
                }
                Thread.currentThread();
                Thread.sleep(20L);
            }
            String string3 = "jars";
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdir();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string3 + "/" + string2);
            AsyncByteArrayInputStream asyncByteArrayInputStream = (AsyncByteArrayInputStream)inputStream;
            fileOutputStream.write(asyncByteArrayInputStream.getBuf(), 0, asyncByteArrayInputStream.size());
            fileOutputStream.close();
            vector.addElement(string2);
            return true;
        }
        catch (ConnectException connectException) {
            String string4 = string;
            if (uRL != null) {
                string4 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort();
            }
            Debug.println((int)0, (String)("ClassLoader: loadJarFile(): unable to connect " + connectException));
            throw new ConnectException(MessageFormat.format(_resource.getString("error", "CanNotConnect"), string4));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.println((int)0, (String)("ClassLoader: loadJarFile(): " + fileNotFoundException));
            throw new Exception(MessageFormat.format(_resource.getString("error", "SaveFile"), fileNotFoundException.getMessage()));
        }
        catch (HttpException httpException) {
            Debug.println((int)0, (String)("ClassLoader: loadJarFile(): " + (Object)((Object)httpException)));
            return false;
        }
        catch (Exception exception) {
            Debug.println((int)0, (String)("ClassLoader: loadJarFile(): " + exception));
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Vector processManifest(String string) throws Exception {
        Vector<String> vector;
        ZipFile zipFile;
        BufferedInputStream bufferedInputStream;
        block16: {
            Vector<String> vector2;
            block15: {
                Vector<String> vector3;
                block13: {
                    block14: {
                        bufferedInputStream = null;
                        zipFile = null;
                        vector = new Vector<String>();
                        try {
                            zipFile = new ZipFile("jars/" + string);
                            ZipEntry zipEntry = zipFile.getEntry(MANIFEST_FILE_NAME);
                            String string2 = null;
                            if (zipEntry == null) {
                                vector3 = vector;
                                Object var13_7 = null;
                                if (zipFile == null) break block13;
                                break block14;
                            }
                            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(bufferedInputStream);
                            if (propertyResourceBundle == null) {
                                vector2 = vector;
                                break block15;
                            }
                            int n = 0;
                            while (n < 100) {
                                String string3;
                                try {
                                    string3 = propertyResourceBundle.getString("include-jar" + n);
                                }
                                catch (MissingResourceException missingResourceException) {
                                    break;
                                }
                                vector.addElement(string3);
                                ++n;
                            }
                            try {
                                string2 = propertyResourceBundle.getString("backward-compatible");
                            }
                            catch (MissingResourceException missingResourceException) {
                                // empty catch block
                            }
                            if (string2 == null) break block16;
                            CompatibilityPersistance.parseLine((Hashtable)compatibilityTable, (String)(string + ":" + string2));
                            if (Debug.isEnabled()) {
                                Debug.println((int)5, (String)("ClassLoader: Added to compatibiliy " + string + ":" + string2));
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var13_10 = null;
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            if (bufferedInputStream == null) throw throwable;
                            bufferedInputStream.close();
                            throw throwable;
                        }
                    }
                    zipFile.close();
                }
                if (bufferedInputStream == null) return vector3;
                bufferedInputStream.close();
                return vector3;
            }
            Object var13_8 = null;
            if (zipFile != null) {
                zipFile.close();
            }
            if (bufferedInputStream == null) return vector2;
            bufferedInputStream.close();
            return vector2;
        }
        Object var13_9 = null;
        if (zipFile != null) {
            zipFile.close();
        }
        if (bufferedInputStream == null) return vector;
        bufferedInputStream.close();
        return vector;
    }

    public String toString() {
        String string = this.className + " contents: \n";
        int n = 0;
        while (n < this.jarNames.size()) {
            string = string + this.jarNames.elementAt(n).toString() + '\n';
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        Debug.setTrace((boolean)true);
        LocalJarClassLoader localJarClassLoader = new LocalJarClassLoader("test.jar");
        Debug.println((String)localJarClassLoader.toString());
        LocalJarClassLoader localJarClassLoader2 = new LocalJarClassLoader("test.jar");
        Debug.println((String)localJarClassLoader2.toString());
        System.exit(0);
    }

    static {
        CompatibilityPersistance.parseLine((Hashtable)compatibilityTable, (String)"mcc50.jar:mcc42.jar,mcc41.jar,mcc40.jar");
        CompatibilityPersistance.parseLine((Hashtable)compatibilityTable, (String)"nmclf50.jar:nmclf42.jar,nmclf41.jar,nmclf40.jar");
        if (Debug.isEnabled()) {
            Debug.println((int)3, (String)"ClassLoader: start parsing");
        }
        CompatibilityPersistance.parseAllJars((Hashtable)compatibilityTable, (String[])LocalJarClassLoader.getLocalJarList());
        if (Debug.isEnabled()) {
            Debug.println((int)3, (String)"ClassLoader:  done");
        }
    }
}

